/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Gregoire Dupe (Mia-Software) - Bug 340571 - To be able have more than one localCustomization
 *   Gregoire Dupe (Mia-Software) - Bug 340572 - Wrong multiplicity in TableInstance.facets
 *   Nicolas Guyomar (Mia-Software) - Bug 340941 - Need new row and column types in the table
 *   Gregoire Dupe (Mia-Software) - Bug 371219 - Compatibility of org.eclipse.emf.facet.widgets.nattable.instance with EMF 2.6.0
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.EObjectQueryRow;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.PrimitiveTypeQueryRow;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryRow;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryTableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Package;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.ValueColumn;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance
 * hierarchy. It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the
 * result of the switch. <!-- end-user-doc -->
 * 
 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Package
 * @generated
 * @deprecated https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class Tableinstance2Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static Tableinstance2Package modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Tableinstance2Switch() {
		if (modelPackage == null) {
			modelPackage = Tableinstance2Package.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(final EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(final EClass theEClass, final EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(final int classifierID, final EObject theEObject) {
		switch (classifierID) {
			case Tableinstance2Package.TABLE_INSTANCE2: {
				TableInstance2 tableInstance2 = (TableInstance2)theEObject;
				T result = caseTableInstance2(tableInstance2);
				if (result == null) result = caseTableInstance(tableInstance2);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Tableinstance2Package.QUERY_ROW: {
				QueryRow queryRow = (QueryRow)theEObject;
				T result = caseQueryRow(queryRow);
				if (result == null) result = caseRow(queryRow);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Tableinstance2Package.PRIMITIVE_TYPE_QUERY_ROW: {
				PrimitiveTypeQueryRow primitiveTypeQueryRow = (PrimitiveTypeQueryRow)theEObject;
				T result = casePrimitiveTypeQueryRow(primitiveTypeQueryRow);
				if (result == null) result = caseQueryRow(primitiveTypeQueryRow);
				if (result == null) result = caseRow(primitiveTypeQueryRow);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Tableinstance2Package.EOBJECT_QUERY_ROW: {
				EObjectQueryRow eObjectQueryRow = (EObjectQueryRow)theEObject;
				T result = caseEObjectQueryRow(eObjectQueryRow);
				if (result == null) result = caseQueryRow(eObjectQueryRow);
				if (result == null) result = caseRow(eObjectQueryRow);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Tableinstance2Package.VALUE_COLUMN: {
				ValueColumn valueColumn = (ValueColumn)theEObject;
				T result = caseValueColumn(valueColumn);
				if (result == null) result = caseColumn(valueColumn);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2: {
				QueryTableInstance2 queryTableInstance2 = (QueryTableInstance2)theEObject;
				T result = caseQueryTableInstance2(queryTableInstance2);
				if (result == null) result = caseQueryTableInstance(queryTableInstance2);
				if (result == null) result = caseTableInstance2(queryTableInstance2);
				if (result == null) result = caseTableInstance(queryTableInstance2);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Table Instance2</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Table Instance2</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTableInstance2(final TableInstance2 object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Query Row</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Query Row</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQueryRow(final QueryRow object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Primitive Type Query Row</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Primitive Type Query Row</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePrimitiveTypeQueryRow(final PrimitiveTypeQueryRow object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject Query Row</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject Query Row</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEObjectQueryRow(final EObjectQueryRow object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Value Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Value Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseValueColumn(final ValueColumn object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Query Table Instance2</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Query Table Instance2</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQueryTableInstance2(final QueryTableInstance2 object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Table Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Table Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTableInstance(final TableInstance object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Row</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Row</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRow(final Row object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseColumn(final Column object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Query Table Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Query Table Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQueryTableInstance(final QueryTableInstance object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(final EObject object) {
		return null;
	}

} //Tableinstance2Switch
