/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - Bug 331203 - table model editor - initial API and implementation
 *    Nicolas Bros (Mia-Software) - Bug 332215 - customizable NatTable column headers
 *    Nicolas Guyomar (Mia-Software) - Bug 332924 - To be able to save the table
 *    Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 369987 - [Restructuring][Table] Switch to the new customization and facet framework
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.List;

import net.sourceforge.nattable.config.CellConfigAttributes;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.grid.GridRegion;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.layer.config.DefaultColumnHeaderStyleConfiguration;
import net.sourceforge.nattable.painter.cell.BackgroundImagePainter;
import net.sourceforge.nattable.painter.cell.ICellPainter;
import net.sourceforge.nattable.painter.cell.TextPainter;
import net.sourceforge.nattable.sort.config.DefaultSortConfiguration;
import net.sourceforge.nattable.sort.painter.SortableHeaderTextPainter;
import net.sourceforge.nattable.style.DisplayMode;
import net.sourceforge.nattable.util.GUIHelper;

import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget.BodyLayerStack;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

/**
 * Extends the default column header style configuration to add custom painters
 * for the column headers. This has to be added to the table using the
 * addConfiguration() method.
 * 
 * @see StyledGridExample
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class StyledColumnHeaderConfiguration extends DefaultColumnHeaderStyleConfiguration {

	private static final String SELECTED_COLUMN_HEADER_BG_IMAGE = "selected_column_header_bg.png"; //$NON-NLS-1$
	private static final String COLUMN_HEADER_BG_IMAGE = "column_header_bg.png"; //$NON-NLS-1$
	private static final Color COLOR_GRAY = GUIHelper.getColor(192, 192, 192);
	private static final Color COLOR_LIGHT_GRAY = GUIHelper.getColor(230, 230, 230);
	private final BodyLayerStack bodyLayer;
	private final List<Column> columnDescriptions;

	private static final Image BG_IMAGE = new Image(Display.getDefault(),
			StyledColumnHeaderConfiguration.class
					.getResourceAsStream(StyledColumnHeaderConfiguration.COLUMN_HEADER_BG_IMAGE));

	private static final Image SELECTED_BG_IMAGE = new Image(
			Display.getDefault(),
			StyledColumnHeaderConfiguration.class
					.getResourceAsStream(StyledColumnHeaderConfiguration.SELECTED_COLUMN_HEADER_BG_IMAGE));
	private final LabelProvider labelProvider;

	public StyledColumnHeaderConfiguration(final BodyLayerStack bodyLayer,
			final List<Column> columnDescriptions,
			final CustomizableLabelProvider labelProvider) {
		// this.font = GUIHelper.getFont(new FontData("Verdana", 10, SWT.BOLD));
		this.bodyLayer = bodyLayer;
		this.columnDescriptions = columnDescriptions;
		this.labelProvider = labelProvider;
	}

	@Override
	public void configureRegistry(final IConfigRegistry configRegistry) {
		super.configureRegistry(configRegistry);
		addNormalModeStyling(configRegistry);
		addSelectedModeStyling(configRegistry);
		addCornerStyling(configRegistry);
	}

	private void addSelectedModeStyling(final IConfigRegistry configRegistry) {
		ICellPainter selectedCellPainter = new BackgroundImagePainter(createCellPainter(),
				StyledColumnHeaderConfiguration.SELECTED_BG_IMAGE,
				StyledColumnHeaderConfiguration.COLOR_GRAY);

		// If sorting is enabled we still want the sort icon to be drawn.
		SortableHeaderTextPainter selectedHeaderPainter = new SortableHeaderTextPainter(
				selectedCellPainter, false);

		configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER,
				selectedHeaderPainter, DisplayMode.SELECT, GridRegion.COLUMN_HEADER);
	}

	private HorizontalPainterWrapper createCellPainter() {
		TextPainter txtPainter = new TextPainter(false, false);
		return new HorizontalPainterWrapper(
				new ICellPainter[] {
						new HeaderImagePainter(this.bodyLayer, this.columnDescriptions,
								this.labelProvider), txtPainter });
	}

	private void addNormalModeStyling(final IConfigRegistry configurationRegistry) {

		ICellPainter normalCellPainter = new BackgroundImagePainter(createCellPainter(),
				StyledColumnHeaderConfiguration.BG_IMAGE,
				StyledColumnHeaderConfiguration.COLOR_GRAY);

		SortableHeaderTextPainter headerPainter = new SortableHeaderTextPainter(normalCellPainter,
				false);

		configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER,
				headerPainter, DisplayMode.NORMAL, GridRegion.COLUMN_HEADER);
		configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER,
				headerPainter, DisplayMode.NORMAL, DefaultSortConfiguration.SORT_DOWN_CONFIG_TYPE);
		configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER,
				headerPainter, DisplayMode.NORMAL, DefaultSortConfiguration.SORT_UP_CONFIG_TYPE);
	}

	private void addCornerStyling(final IConfigRegistry configurationRegistry) {
		// adds painting of the the gray triangle in the upper left corner
		ICellPainter cornerPainter = new BackgroundImagePainter(createCellPainter(),
				StyledColumnHeaderConfiguration.BG_IMAGE,
				StyledColumnHeaderConfiguration.COLOR_GRAY) {
			@Override
			public void paintCell(final LayerCell cell, final GC gc, final Rectangle rectangle,
					final IConfigRegistry configRegistry) {
				if (cell.getColumnPosition() != 0) {
					super.paintCell(cell, gc, rectangle, configRegistry);
				} else {
					// gc.setForeground(GUIHelper.COLOR_GRAY);
					gc.setBackground(StyledColumnHeaderConfiguration.COLOR_LIGHT_GRAY);
					gc.fillPolygon(new int[] { rectangle.x, rectangle.y + rectangle.height,
							rectangle.x + rectangle.width, rectangle.y,
							rectangle.x + rectangle.width, rectangle.y + rectangle.height });
				}
			}
		};
		SortableHeaderTextPainter headerPainter = new SortableHeaderTextPainter(cornerPainter,
				false);

		configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER,
				headerPainter, DisplayMode.NORMAL, GridRegion.CORNER);
	}
}