/*******************************************************************************
 * Copyright (c) 2012 Mia-Software.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gregoire Dupe (Mia-Software) - Bug 352485 - [Table] Default height of cells is too small, leading to text truncations
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal;

import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public final class DefaultSizeUtils {

	private static final boolean DEBUG = DebugUtils.getDebugStatus(Activator.getDefault());

	private static final int MARGIN = 4;
	private static final int FONT_CELL_RATIO = 2;
	private static final int WIDTH_HEIGHT_RATIO = 8;
	private static final int ROW_HEADER_RATIO = 2; //Row header width height ratio
	private static final int DEFAULT_DPI = 96;
	
	private DefaultSizeUtils() {
		// Must not be used.
	}

	public static int getDefaultCellHeight() {
		int dpiX = Display.getDefault().getDPI().x;
		int dpiY = Display.getDefault().getDPI().y;
		FontData[] fd = Display.getDefault().getSystemFont().getFontData();
		fd[0].getName();
		int height = (fd[0].getHeight() * DefaultSizeUtils.FONT_CELL_RATIO) + DefaultSizeUtils.MARGIN;
		if (DefaultSizeUtils.DEBUG) {
			System.out.println(DefaultSizeUtils.class.getName() + ".getDefaultCellHeight: fd[0].getHeight()=" + fd[0].getHeight()); //$NON-NLS-1$
			System.out.println(DefaultSizeUtils.class.getName() + ".getDefaultCellHeight: height=" + height); //$NON-NLS-1$
			System.out.println(DefaultSizeUtils.class.getName() + ".getDefaultCellHeight: dpi x=" + dpiX); //$NON-NLS-1$
			System.out.println(DefaultSizeUtils.class.getName() + ".getDefaultCellHeight: dpi y=" + dpiY); //$NON-NLS-1$
		}
		return height * (dpiY / DefaultSizeUtils.DEFAULT_DPI);
	}

	public static int getDefaultCellWidth() {
		int width = DefaultSizeUtils.getDefaultCellHeight() * DefaultSizeUtils.WIDTH_HEIGHT_RATIO;
		if (DefaultSizeUtils.DEBUG) {
			System.out.println(DefaultSizeUtils.class.getName() + ".getDefaultCellWidth: " + width); //$NON-NLS-1$
		}
		return width;
	}

	public static int getDefaultRowHeaderWidth() {
		int width = DefaultSizeUtils.getDefaultCellHeight() * DefaultSizeUtils.ROW_HEADER_RATIO;
		if (DefaultSizeUtils.DEBUG) {
			System.out.println(DefaultSizeUtils.class.getName() + ".getDefaultRowHeaderWidth: " + width); //$NON-NLS-1$
		}
		return width;
	}

	public static Font getHeaderFont() {
		FontData[] fd = Display.getDefault().getSystemFont().getFontData().clone();
		fd[0].setStyle(SWT.BOLD);
		// FIXME cache font
		Font headerFont = new Font(Display.getDefault(), fd);
		return headerFont;
	}
}
