/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.ui.internal.exported.ICustomizationCommandFactory;
import org.eclipse.emf.facet.custom.ui.internal.exported.ICustomizationCommandFactoryFactory;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.emf.core.command.ICommandFactoryResult;
import org.eclipse.emf.facet.util.emf.core.command.ICommandFactoryResultFactory;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TableFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TablePackage;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.CustomizationUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.ITableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.internal.TableInstanceUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.command.BrutalListSetCommand;
import org.eclipse.emf.facet.widgets.table.ui.internal.comparator.RowComparator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ColumnSortDirection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableCommandFactory
implements ITableCommandFactory,
org.eclipse.emf.facet.widgets.table.ui.command.ITableCommandFactory {
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    private final Table table;
    private final EditingDomain editingDomain;
    private final ICommandFactory commandFactory;
    private final IFacetManager facetManager;

    public TableCommandFactory(Table table, EditingDomain editingDomain, ICommandFactory commandFactory, IFacetManager facetManager) {
        this.table = table;
        this.editingDomain = editingDomain;
        this.commandFactory = commandFactory;
        this.facetManager = facetManager;
    }

    @Override
    public Command createSetLoadedFacetSetsCommand(List<FacetSet> facetSets) {
        return this.createSetFacetSetsCommand(facetSets);
    }

    private Command createSetLoadedFacetSetsCommand(List<? extends FacetSet> facetSets, boolean manageCustoms) {
        CommandList commandList = new CommandList();
        List<FeatureColumn> columnsToRemove = TableInstanceUtils.columnsToRemove(this.table, facetSets, (List<Row>)this.table.getRows());
        for (Column column : columnsToRemove) {
            Command removeColumnCmd = this.createRemoveColumnCommand(column);
            commandList.add(removeColumnCmd);
        }
        if (!this.table.getFacetSets().equals(facetSets)) {
            Command command = this.commandFactory.createSetCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_FacetSets(), facetSets);
            commandList.add(command);
        }
        LinkedList<Customization> linkedList = new LinkedList<Customization>();
        for (FacetSet facetSet : facetSets) {
            if (!(facetSet instanceof Customization)) continue;
            Customization custom = (Customization)facetSet;
            linkedList.add(custom);
        }
        if (manageCustoms) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.table.getFacetSets());
            arrayList.removeAll(facetSets);
            LinkedList<Customization> removedCustoms = new LinkedList<Customization>();
            for (FacetSet facetSet : arrayList) {
                if (!(facetSet instanceof Customization)) continue;
                Customization custom = (Customization)facetSet;
                removedCustoms.add(custom);
            }
            if (!linkedList.isEmpty() || !removedCustoms.isEmpty()) {
                ArrayList<Customization> customizations = new ArrayList<Customization>();
                customizations.addAll((Collection<Customization>)this.table.getCustomizations());
                customizations.removeAll(removedCustoms);
                customizations.addAll(linkedList);
                Command loadCustom = this.createCoreSetCustomizationsCommand(customizations);
                commandList.add(loadCustom);
            }
        }
        return TableCommandFactory.createResult(commandList, "Set loaded facetSets");
    }

    private static Command createResult(List<Command> commandList, String label) {
        CompoundCommand result = null;
        while (commandList.contains(null)) {
            commandList.remove(null);
        }
        if (!commandList.isEmpty()) {
            result = new CompoundCommand(label, commandList);
        }
        return result;
    }

    @Override
    public Command createRemoveColumnCommand(Column column) {
        ArrayList<Command> commandList = new ArrayList<Command>();
        if (this.table.getColumns().contains((Object)column)) {
            Command command = this.commandFactory.createRemoveCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)column);
            commandList.add(command);
        }
        return TableCommandFactory.createResult(commandList, "Remove column");
    }

    @Override
    public Command createAddColumnCommand(List<ETypedElement> eTypedElements, List<FacetSet> facetSets) {
        CommandList commandList = new CommandList();
        LinkedHashSet<FacetSet> newFacetSets = new LinkedHashSet<FacetSet>();
        newFacetSets.addAll(facetSets);
        newFacetSets.addAll((Collection<FacetSet>)this.table.getFacetSets());
        for (ETypedElement eTypedElement : eTypedElements) {
            FacetSet signatureFS = TableCommandFactory.getSignatureFacetSet(eTypedElement);
            if (signatureFS == null) continue;
            newFacetSets.add(signatureFS);
        }
        Command addFacetCommand = this.createSetLoadedFacetSetsCommand(new ArrayList<FacetSet>(newFacetSets));
        commandList.add(addFacetCommand);
        Command addColumn = this.createAddColumn(eTypedElements);
        commandList.add(addColumn);
        return TableCommandFactory.createResult(commandList, "Add columns and facetSets");
    }

    private static FacetSet getSignatureFacetSet(ETypedElement eTypedElement) {
        FacetSet result = null;
        if (eTypedElement instanceof DerivedTypedElement) {
            DerivedTypedElement signatureTE;
            DerivedTypedElement derivedTE = (DerivedTypedElement)eTypedElement;
            try {
                signatureTE = FacetUtils.getTopOverrideFeature((DerivedTypedElement)derivedTE);
            }
            catch (FacetManagerException e) {
                throw new TableWidgetRuntimeException(e);
            }
            if (derivedTE.getOverride() != null && signatureTE != null) {
                FacetSet signatureFS;
                result = signatureFS = FacetUtils.getFacetSet((ETypedElement)signatureTE);
            }
        }
        return result;
    }

    private Command createAddColumn(List<ETypedElement> eTypedElements) {
        CommandList commandList = new CommandList();
        for (ETypedElement eTypedElement : eTypedElements) {
            Command addColumn = this.createAddColumn(eTypedElement);
            commandList.add(addColumn);
        }
        return TableCommandFactory.createResult(commandList, "Add columns");
    }

    private Command createAddColumn(ETypedElement eTypedElement) {
        ETypedElement signature = eTypedElement;
        if (eTypedElement instanceof FacetOperation) {
            FacetOperation facetOperation = (FacetOperation)eTypedElement;
            signature = FacetUtils.getSignature((FacetOperation)facetOperation);
        }
        Column existingColumn = null;
        for (Column column : this.table.getColumns()) {
            FeatureColumn featureColumn;
            if (!(column instanceof FeatureColumn) || !(featureColumn = (FeatureColumn)column).getFeature().equals(signature)) continue;
            existingColumn = column;
            break;
        }
        CommandList commandList = new CommandList();
        if (existingColumn == null) {
            FeatureColumn column = TableFactory.eINSTANCE.createFeatureColumn();
            Command setColumn = this.commandFactory.createAddCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)column);
            commandList.add(setColumn);
            Command setETypedElement = this.commandFactory.createSetCommand(this.editingDomain, (Object)column, (Object)TablePackage.eINSTANCE.getFeatureColumn_Feature(), (Object)signature);
            commandList.add(setETypedElement);
        }
        return TableCommandFactory.createResult(commandList, "Add column");
    }

    @Override
    public Command createSetCustomizationCommand(List<Customization> customizations) {
        CommandList commandList = new CommandList();
        Set<FacetSet> referredFS = CustomizationUtils.findFacetsCustomizedBy(customizations);
        EList alreadyLoaded = this.table.getFacetSets();
        ArrayList removedCustoms = new ArrayList();
        removedCustoms.addAll(this.table.getCustomizations());
        removedCustoms.removeAll(customizations);
        ArrayList<Object> facetSets = new ArrayList<Object>();
        facetSets.addAll(customizations);
        facetSets.removeAll((Collection<?>)alreadyLoaded);
        facetSets.addAll((Collection<Object>)alreadyLoaded);
        facetSets.removeAll(referredFS);
        facetSets.addAll(referredFS);
        facetSets.removeAll(removedCustoms);
        Command facetLoad = this.createSetLoadedFacetSetsCommand(facetSets, false);
        commandList.add(facetLoad);
        Command customLoad = this.createCoreSetCustomizationsCommand(customizations);
        commandList.add(customLoad);
        return TableCommandFactory.createResult(commandList, "Load cutomizations and associated facet sets");
    }

    private Command createCoreSetCustomizationsCommand(List<Customization> customizations) {
        ArrayList<Customization> sortedCustoms = new ArrayList<Customization>();
        sortedCustoms.addAll((Collection<Customization>)this.table.getLocalCustomizations());
        for (Customization customization : customizations) {
            if (sortedCustoms.contains(customization)) continue;
            sortedCustoms.add(customization);
        }
        CommandList commandList = new CommandList();
        if (!this.table.getCustomizations().equals(sortedCustoms)) {
            Command command = this.commandFactory.createSetCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_Customizations(), sortedCustoms);
            commandList.add(command);
        }
        return TableCommandFactory.createResult(commandList, "Set loaded cutomizations");
    }

    @Override
    public Command createRemoveColumnsCommand(List<ETypedElement> elements) {
        ArrayList<Command> commandList = new ArrayList<Command>();
        if (elements != null && !elements.isEmpty()) {
            for (Column column : this.table.getColumns()) {
                FeatureColumn featureColumn;
                if (!(column instanceof FeatureColumn) || !elements.contains((featureColumn = (FeatureColumn)column).getFeature())) continue;
                Command rmCommand = this.commandFactory.createRemoveCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)featureColumn);
                commandList.add(rmCommand);
            }
        }
        return TableCommandFactory.createResult(commandList, NLS.bind((String)"Remove {0} columms", (Object)commandList.size()));
    }

    @Override
    public Command createSortRowCommand(FeatureColumn featureColumn, ColumnSortDirection direction) {
        ArrayList rows = new ArrayList(this.table.getRows());
        ETypedElement eTypedElement = featureColumn.getFeature();
        RowComparator comparator = new RowComparator(eTypedElement, direction, this.facetManager);
        Collections.sort(rows, comparator);
        return new BrutalListSetCommand(this.table, TablePackage.eINSTANCE.getTable_Rows(), rows, Messages.TableCommandFactory_row_sort_label, NLS.bind((String)Messages.TableCommandFactory_row_sort_description, (Object)eTypedElement.getName()));
    }

    @Override
    public Command createRemoveRowByEObjectCommand(Collection<? extends EObject> eObjectRows) {
        ArrayList<Row> rowsToRemove = new ArrayList<Row>();
        for (Row row : this.table.getRows()) {
            if (!eObjectRows.contains(row.getElement())) continue;
            rowsToRemove.add(row);
        }
        return this.createRemoveRowsCommand(rowsToRemove);
    }

    public Command createRemoveUselessColumnsCommand(Collection<Row> rowsToRemove, List<FacetSet> nextLoadedFS) {
        CommandList commandList = new CommandList();
        ArrayList<Row> rowsToKeep = new ArrayList<Row>((Collection<Row>)this.table.getRows());
        rowsToKeep.removeAll(rowsToRemove);
        EList facetSets = nextLoadedFS == null ? this.table.getFacetSets() : nextLoadedFS;
        List<FeatureColumn> columns = TableInstanceUtils.columnsToRemove(this.table, (List<? extends FacetSet>)facetSets, rowsToKeep);
        for (FeatureColumn column : columns) {
            DebugUtils.debug((boolean)DEBUG, (String)("column to remove: " + EcoreUtil.getURI((EObject)column.getFeature())));
            Command rmColumnCmd = this.commandFactory.createRemoveCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)column);
            commandList.add(rmColumnCmd);
        }
        if (DEBUG) {
            DebugUtils.debug((String)("Columns to be removed: " + commandList.size()));
        }
        return TableCommandFactory.createResult(commandList, Messages.TableInstanceCommandFactory_removeUselessColumn);
    }

    public Command createRemoveRowsCommand(Collection<Row> rows) {
        CommandList cmdList = new CommandList();
        for (Row row : rows) {
            Command removeRowCommand = this.commandFactory.createRemoveCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_Rows(), (Object)row);
            cmdList.add(removeRowCommand);
        }
        Command updateColumnCmd = this.createRemoveUselessColumnsCommand(rows, null);
        cmdList.add(updateColumnCmd);
        return TableCommandFactory.createResult(cmdList, NLS.bind((String)"Remove {0} row(s)", (Object)cmdList.size()));
    }

    @Override
    public Command createAddRowsCommand(Collection<? extends EObject> eObjects) {
        CommandList cmdList = new CommandList();
        int nbRows = 0;
        HashSet<EPackage> alreadyDone = new HashSet<EPackage>();
        ArrayList<EStructuralFeature> processedSF = new ArrayList<EStructuralFeature>();
        List<EObject> tableContent = TableWidgetUtils.getElements(this.table);
        for (EObject eObject : eObjects) {
            if (tableContent.contains(eObject)) continue;
            Row row = TableFactory.eINSTANCE.createRow();
            Command setToRowCmd = this.commandFactory.createSetCommand(this.editingDomain, (Object)row, (Object)TablePackage.eINSTANCE.getRow_Element(), (Object)eObject);
            cmdList.add(setToRowCmd);
            Command addRowCmd = this.commandFactory.createAddCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_Rows(), (Object)row);
            cmdList.add(addRowCmd);
            ++nbRows;
            for (EStructuralFeature eStructuralFeature : eObject.eClass().getEAllStructuralFeatures()) {
                if (processedSF.contains(eStructuralFeature)) continue;
                processedSF.add(eStructuralFeature);
                Command createAddColumn = this.createAddColumn(alreadyDone, eStructuralFeature);
                cmdList.add(createAddColumn);
            }
        }
        return TableCommandFactory.createResult(cmdList, NLS.bind((String)"Add of {0} rows", (Object)nbRows));
    }

    private Command createAddColumn(Set<EPackage> alreadyDone, EStructuralFeature structuralFeature) {
        CommandList cmdList = new CommandList();
        if (!TableInstanceUtils.isColumnAlreadyDeclared(this.table, structuralFeature)) {
            EPackage ePackage;
            FeatureColumn referenceColumn = TableFactory.eINSTANCE.createFeatureColumn();
            referenceColumn.setFeature((ETypedElement)structuralFeature);
            Command cmd = this.commandFactory.createAddCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)referenceColumn);
            cmdList.add(cmd);
            EList localCustoms = this.table.getLocalCustomizations();
            EClass eClass = structuralFeature.getEContainingClass();
            if (eClass != null && !alreadyDone.contains(ePackage = eClass.getEPackage()) && CustomizationUtils.findCustomizationExtendingEPackage((List<Customization>)localCustoms, ePackage) == null) {
                Command localCustomCmd = this.createAddLocalCustomCommand(ePackage);
                if (localCustomCmd.canExecute()) {
                    cmdList.add(localCustomCmd);
                }
                alreadyDone.add(ePackage);
            }
        }
        return TableCommandFactory.createResult(cmdList, NLS.bind((String)"Add a column for {0}::{1}", (Object)structuralFeature.getEContainingClass().getName(), (Object)structuralFeature.getName()));
    }

    private Command createAddLocalCustomCommand(EPackage ePackage) {
        CommandList cmdList = new CommandList();
        ICommandFactoryResult<Customization> cmdFactoryResult = this.createCreateLocalCustom(ePackage);
        Customization newCustom = (Customization)cmdFactoryResult.getResult();
        cmdList.add(cmdFactoryResult.getCommand());
        ArrayList<Customization> customs = new ArrayList<Customization>();
        customs.addAll((Collection<Customization>)this.table.getCustomizations());
        EList localCustoms = this.table.getLocalCustomizations();
        int index = 0;
        for (Customization custom : customs) {
            if (localCustoms.contains(custom)) break;
            ++index;
        }
        customs.add(index, newCustom);
        Command setCustomCmd = this.commandFactory.createSetCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_Customizations(), customs);
        cmdList.add(setCustomCmd);
        return TableCommandFactory.createResult(cmdList, NLS.bind((String)"Add of a new customization for the ePackage '{0}'", (Object)ePackage.getName()));
    }

    public ICommandFactoryResult<Customization> createCreateLocalCustom(EPackage ePackage) {
        ICustomizationCommandFactory customCmdFactory = ICustomizationCommandFactoryFactory.DEFAULT.createCustomizationCommandFactory(this.editingDomain, (org.eclipse.emf.facet.util.emf.core.internal.exported.ICommandFactory)this.commandFactory);
        CommandList cmdList = new CommandList();
        ICommandFactoryResult cmdFactoryResult = customCmdFactory.createCustomization("Column hiding customization for " + ePackage.getName());
        Customization customization = (Customization)cmdFactoryResult.getResult();
        cmdList.add(cmdFactoryResult.getCommand());
        Command addToLocalCmd = this.commandFactory.createAddCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_LocalCustomizations(), (Object)customization);
        cmdList.add(addToLocalCmd);
        Command addAllCmd = this.commandFactory.createAddCommand(this.editingDomain, (Object)this.table, (Object)TablePackage.eINSTANCE.getTable_Customizations(), (Object)customization);
        cmdList.add(addAllCmd);
        Command cmd = TableCommandFactory.createResult(cmdList, "Create a local custom.");
        return ICommandFactoryResultFactory.DEFAULT.createCommandFactoryResult(cmd, (Object)customization);
    }

    @Override
    public Command createSetFacetSetsCommand(List<? extends FacetSet> facetSets) {
        return this.createSetLoadedFacetSetsCommand(facetSets, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CommandList
    extends LinkedList<Command> {
        private static final long serialVersionUID = 8581553157248060152L;

        CommandList() {
        }

        @Override
        public boolean add(Command command) {
            boolean result = command == null ? false : super.add(command);
            return result;
        }
    }
}

