/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.io.java;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.gmt.modisco.java.ArrayType;
import org.eclipse.gmt.modisco.java.Expression;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.NamedElement;
import org.eclipse.gmt.modisco.java.NamespaceAccess;
import org.eclipse.gmt.modisco.java.PackageAccess;
import org.eclipse.gmt.modisco.java.ParameterizedType;
import org.eclipse.gmt.modisco.java.PrimitiveType;
import org.eclipse.gmt.modisco.java.PrimitiveTypeInt;
import org.eclipse.gmt.modisco.java.SingleVariableAccess;
import org.eclipse.gmt.modisco.java.TypeAccess;
import org.eclipse.gmt.modisco.java.UnresolvedItemAccess;
import org.eclipse.gmt.modisco.java.WildCardType;
import org.eclipse.gmt.modisco.java.emf.JavaFactory;
import org.eclipse.gmt.modisco.java.io.java.JDTVisitor;
import org.eclipse.gmt.modisco.java.io.java.binding.Binding;
import org.eclipse.gmt.modisco.java.io.java.binding.BindingManager;
import org.eclipse.gmt.modisco.java.io.java.binding.JDTDelegateBindingFactory;
import org.eclipse.gmt.modisco.java.io.java.binding.PendingElement;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WildcardType;

@Deprecated
public final class JDTVisitorUtils {
    private static final String TRACEID_QN = "JavaDiscovererUtils/getQualifiedName";
    private static final boolean TRACE_QN = JavaActivator.getDefault().isDebugging() && new Boolean(Platform.getDebugOption((String)"JavaDiscovererUtils/getQualifiedName")) != false;

    private JDTVisitorUtils() {
    }

    public static void manageBindingDeclaration(NamedElement element, Name name, JDTVisitor visitor) {
        Binding id = JDTDelegateBindingFactory.getInstance().getBindingForName(name);
        if (!id.isUnresolved()) {
            if (JDTDelegateBindingFactory.getInstance().isLocal(name)) {
                visitor.getLocalBindings().addTarget(id, element);
            } else {
                visitor.getGlobalBindings().addTarget(id, element);
            }
        }
    }

    public static NamedElement manageBindingRef(PendingElement element, Name name, JDTVisitor visitor) {
        Binding id = JDTDelegateBindingFactory.getInstance().getBindingForName(name);
        NamedElement target = visitor.getGlobalBindings().getTarget(id);
        if (target == null) {
            if (JDTDelegateBindingFactory.getInstance().isLocal(name)) {
                visitor.getLocalBindings().addPending(element, id);
            } else {
                visitor.getGlobalBindings().addPending(element, id);
            }
        }
        return target;
    }

    public static PrimitiveType manageBindingRef(org.eclipse.jdt.core.dom.PrimitiveType type, JDTVisitor visitor) {
        Binding id = JDTDelegateBindingFactory.getInstance().getBindingForPrimitiveType(type);
        PrimitiveType primitiveType = (PrimitiveType)visitor.getGlobalBindings().getTarget(id);
        if (primitiveType == null) {
            JDTVisitorUtils.initializePrimitiveTypes(visitor.getFactory(), visitor.getJdtModel(), visitor.getGlobalBindings());
            primitiveType = (PrimitiveType)visitor.getGlobalBindings().getTarget(id);
        }
        if (primitiveType == null) {
            primitiveType = visitor.getFactory().createPrimitiveType();
            primitiveType.setName(id.toString());
            visitor.getJdtModel().getOrphanTypes().add((Object)primitiveType);
            visitor.getGlobalBindings().addTarget(id, (NamedElement)primitiveType);
            MoDiscoLogger.logError((String)"primitiveType == null", (Plugin)JavaActivator.getDefault());
        }
        return primitiveType;
    }

    public static ParameterizedType manageBindingRef(org.eclipse.jdt.core.dom.ParameterizedType type, JDTVisitor visitor) {
        Binding id = JDTDelegateBindingFactory.getInstance().getBindingForParameterizedType(type);
        ParameterizedType parameterizedType = (ParameterizedType)visitor.getGlobalBindings().getTarget(id);
        if (parameterizedType == null) {
            parameterizedType = visitor.getFactory().createParameterizedType();
            parameterizedType.setName(id.toString());
            if (visitor.getBijectiveMap().get(type.getType()) != null) {
                parameterizedType.setType(JDTVisitorUtils.completeTypeAccess(visitor.getBijectiveMap().get(type.getType()), visitor));
            }
            for (Object typeArgument : type.typeArguments()) {
                TypeAccess itElement;
                ASTNode node = visitor.getBijectiveMap().get(typeArgument);
                if (node == null) {
                    RuntimeException e = new RuntimeException("typeArgument not found in visitor bijective map: " + type.getParent().getParent().toString());
                    MoDiscoLogger.logWarning((Throwable)e, (Plugin)JavaActivator.getDefault());
                }
                if ((itElement = JDTVisitorUtils.completeTypeAccess(node, visitor)) == null) continue;
                parameterizedType.getTypeArguments().add((Object)itElement);
            }
            visitor.getJdtModel().getOrphanTypes().add((Object)parameterizedType);
            visitor.getGlobalBindings().addTarget(id, (NamedElement)parameterizedType);
        }
        return parameterizedType;
    }

    public static WildCardType manageBindingRef(WildcardType type, JDTVisitor visitor) {
        Binding id = JDTDelegateBindingFactory.getInstance().getBindingForWildCardType(type);
        WildCardType wildCardType = (WildCardType)visitor.getGlobalBindings().getTarget(id);
        if (wildCardType == null) {
            wildCardType = visitor.getFactory().createWildCardType();
            if (visitor.getBijectiveMap().get(type.getBound()) != null) {
                wildCardType.setBound(JDTVisitorUtils.completeTypeAccess(visitor.getBijectiveMap().get(type.getBound()), visitor));
            }
            wildCardType.setName(id.toString());
            wildCardType.setUpperBound(type.isUpperBound());
            visitor.getJdtModel().getOrphanTypes().add((Object)wildCardType);
            visitor.getGlobalBindings().addTarget(id, (NamedElement)wildCardType);
        }
        return wildCardType;
    }

    public static ArrayType manageBindingRef(org.eclipse.jdt.core.dom.ArrayType type, JDTVisitor visitor) {
        Binding id = JDTDelegateBindingFactory.getInstance().getBindingForArrayType(type);
        ArrayType arrayType = (ArrayType)visitor.getGlobalBindings().getTarget(id);
        if (arrayType == null) {
            arrayType = visitor.getFactory().createArrayType();
            arrayType.setDimensions(type.getDimensions());
            arrayType.setName(id.toString());
            if (visitor.getBijectiveMap().get(type.getElementType()) != null) {
                arrayType.setElementType(JDTVisitorUtils.completeTypeAccess(visitor.getBijectiveMap().get(type.getElementType()), visitor));
            }
            visitor.getJdtModel().getOrphanTypes().add((Object)arrayType);
            visitor.getGlobalBindings().addTarget(id, (NamedElement)arrayType);
        }
        return arrayType;
    }

    public static void manageBindingRef(PendingElement element, ClassInstanceCreation constructorCall, JDTVisitor visitor) {
        Binding id = JDTDelegateBindingFactory.getInstance().getBindingForClassInstanceCreation(constructorCall);
        AbstractMethodDeclaration method = (AbstractMethodDeclaration)visitor.getGlobalBindings().getTarget(id);
        if (method != null) {
            element.affectTarget((ASTNode)method);
        } else {
            visitor.getGlobalBindings().addPending(element, id);
        }
    }

    public static void manageBindingRef(PendingElement element, ConstructorInvocation constructorCall, JDTVisitor visitor) {
        Binding id = JDTDelegateBindingFactory.getInstance().getBindingForConstructorInvocation(constructorCall);
        AbstractMethodDeclaration method = (AbstractMethodDeclaration)visitor.getGlobalBindings().getTarget(id);
        if (method != null) {
            element.affectTarget((ASTNode)method);
        } else {
            visitor.getGlobalBindings().addPending(element, id);
        }
    }

    public static void manageBindingRef(PendingElement element, SuperConstructorInvocation constructorCall, JDTVisitor visitor) {
        Binding id = JDTDelegateBindingFactory.getInstance().getBindingForSuperConstructorInvocation(constructorCall);
        AbstractMethodDeclaration method = (AbstractMethodDeclaration)visitor.getGlobalBindings().getTarget(id);
        if (method != null) {
            element.affectTarget((ASTNode)method);
        } else {
            visitor.getGlobalBindings().addPending(element, id);
        }
    }

    public static void initializePrimitiveTypes(JavaFactory factory, Model model, BindingManager globalBindings) {
        PrimitiveTypeInt primitiveType;
        if (globalBindings.getTarget(org.eclipse.jdt.core.dom.PrimitiveType.INT.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeInt();
            primitiveType.setName(org.eclipse.jdt.core.dom.PrimitiveType.INT.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(org.eclipse.jdt.core.dom.PrimitiveType.INT.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(org.eclipse.jdt.core.dom.PrimitiveType.LONG.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeLong();
            primitiveType.setName(org.eclipse.jdt.core.dom.PrimitiveType.LONG.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(org.eclipse.jdt.core.dom.PrimitiveType.LONG.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(org.eclipse.jdt.core.dom.PrimitiveType.FLOAT.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeFloat();
            primitiveType.setName(org.eclipse.jdt.core.dom.PrimitiveType.FLOAT.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(org.eclipse.jdt.core.dom.PrimitiveType.FLOAT.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(org.eclipse.jdt.core.dom.PrimitiveType.DOUBLE.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeDouble();
            primitiveType.setName(org.eclipse.jdt.core.dom.PrimitiveType.DOUBLE.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(org.eclipse.jdt.core.dom.PrimitiveType.DOUBLE.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(org.eclipse.jdt.core.dom.PrimitiveType.BOOLEAN.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeBoolean();
            primitiveType.setName(org.eclipse.jdt.core.dom.PrimitiveType.BOOLEAN.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(org.eclipse.jdt.core.dom.PrimitiveType.BOOLEAN.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(org.eclipse.jdt.core.dom.PrimitiveType.VOID.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeVoid();
            primitiveType.setName(org.eclipse.jdt.core.dom.PrimitiveType.VOID.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(org.eclipse.jdt.core.dom.PrimitiveType.VOID.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(org.eclipse.jdt.core.dom.PrimitiveType.CHAR.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeChar();
            primitiveType.setName(org.eclipse.jdt.core.dom.PrimitiveType.CHAR.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(org.eclipse.jdt.core.dom.PrimitiveType.CHAR.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(org.eclipse.jdt.core.dom.PrimitiveType.SHORT.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeShort();
            primitiveType.setName(org.eclipse.jdt.core.dom.PrimitiveType.SHORT.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(org.eclipse.jdt.core.dom.PrimitiveType.SHORT.toString(), (NamedElement)primitiveType);
        }
        if (globalBindings.getTarget(org.eclipse.jdt.core.dom.PrimitiveType.BYTE.toString()) == null) {
            primitiveType = factory.createPrimitiveTypeByte();
            primitiveType.setName(org.eclipse.jdt.core.dom.PrimitiveType.BYTE.toString());
            model.getOrphanTypes().add((Object)primitiveType);
            globalBindings.addTarget(org.eclipse.jdt.core.dom.PrimitiveType.BYTE.toString(), (NamedElement)primitiveType);
        }
    }

    public static void substitutePendingClientNode(ASTNode oldClientNode, ASTNode newClientNode, String oldClientLinkName, String newClientLinkName, JDTVisitor visitor) {
        PendingElement pe = visitor.getGlobalBindings().getPending(oldClientNode, oldClientLinkName);
        if (pe != null) {
            pe.setClientNode(newClientNode);
            pe.setLinkName(newClientLinkName);
            visitor.getBijectiveMap().put(visitor.getBijectiveMap().getKey(oldClientNode), newClientNode);
            EcoreUtil.remove((EObject)oldClientNode);
        }
    }

    public static boolean completeBinding(ASTNode clientNode, ASTNode modiscoNode, String clientLinkName) {
        if (modiscoNode != null) {
            if (modiscoNode instanceof PendingElement) {
                PendingElement pending = (PendingElement)modiscoNode;
                pending.setLinkName(clientLinkName);
                pending.setClientNode(clientNode);
            } else {
                return true;
            }
        }
        return false;
    }

    public static TypeAccess completeTypeAccess(ASTNode node, JDTVisitor visitor) {
        if (node instanceof TypeAccess) {
            return (TypeAccess)node;
        }
        if (node instanceof PackageAccess) {
            TypeAccess typAcc = visitor.getFactory().createTypeAccess();
            typAcc.setQualifier((NamespaceAccess)((PackageAccess)node));
            JDTVisitorUtils.substitutePendingClientNode(node, (ASTNode)typAcc, "element", "type", visitor);
            return typAcc;
        }
        if (node instanceof UnresolvedItemAccess) {
            TypeAccess typAcc = visitor.getFactory().createTypeAccess();
            if (((UnresolvedItemAccess)node).getQualifier() != null) {
                typAcc.setQualifier((NamespaceAccess)((UnresolvedItemAccess)node).getQualifier());
            }
            JDTVisitorUtils.substitutePendingClientNode(node, (ASTNode)typAcc, "element", "type", visitor);
            return typAcc;
        }
        TypeAccess typAcc = visitor.getFactory().createTypeAccess();
        ((PendingElement)node).setClientNode((ASTNode)typAcc);
        ((PendingElement)node).setLinkName("type");
        return typAcc;
    }

    public static SingleVariableAccess completeVariableAccess(ASTNode node, JDTVisitor visitor) {
        if (node instanceof SingleVariableAccess) {
            return (SingleVariableAccess)node;
        }
        if (node instanceof UnresolvedItemAccess) {
            SingleVariableAccess varAcc = visitor.getFactory().createSingleVariableAccess();
            if (((UnresolvedItemAccess)node).getQualifier() != null) {
                varAcc.setQualifier((Expression)((UnresolvedItemAccess)node).getQualifier());
            }
            JDTVisitorUtils.substitutePendingClientNode(node, (ASTNode)varAcc, "element", "variable", visitor);
            return varAcc;
        }
        SingleVariableAccess variableAccess = visitor.getFactory().createSingleVariableAccess();
        ((PendingElement)node).setClientNode((ASTNode)variableAccess);
        ((PendingElement)node).setLinkName("variable");
        return variableAccess;
    }

    public static Expression completeExpression(ASTNode node, JDTVisitor visitor) {
        if (node instanceof Expression) {
            return (Expression)node;
        }
        UnresolvedItemAccess unrAcc = visitor.getFactory().createUnresolvedItemAccess();
        ((PendingElement)node).setClientNode((ASTNode)unrAcc);
        ((PendingElement)node).setLinkName("element");
        return unrAcc;
    }

    public static ASTNode completeExpressionOrPackageAccess(ASTNode node, JDTVisitor visitor) {
        if (node instanceof Expression || node instanceof PackageAccess) {
            return node;
        }
        UnresolvedItemAccess unrAcc = visitor.getFactory().createUnresolvedItemAccess();
        ((PendingElement)node).setClientNode((ASTNode)unrAcc);
        ((PendingElement)node).setLinkName("element");
        return unrAcc;
    }

    public static String getQualifiedName(org.eclipse.jdt.core.dom.ASTNode node) {
        String resultQualifiedName = "";
        if (node instanceof PackageDeclaration) {
            Name name = ((PackageDeclaration)node).getName();
            resultQualifiedName = JDTDelegateBindingFactory.getInstance().getBindingForName(name).toString();
        } else if (node instanceof MethodDeclaration) {
            SimpleName name = ((MethodDeclaration)node).getName();
            resultQualifiedName = JDTDelegateBindingFactory.getInstance().getBindingForName((Name)name).toString();
        } else if (node instanceof AbstractTypeDeclaration) {
            SimpleName name = ((AbstractTypeDeclaration)node).getName();
            resultQualifiedName = JDTDelegateBindingFactory.getInstance().getBindingForName((Name)name).toString();
        } else if (node instanceof AbstractTypeDeclaration) {
            SimpleName name = ((AbstractTypeDeclaration)node).getName();
            resultQualifiedName = JDTDelegateBindingFactory.getInstance().getBindingForName((Name)name).toString();
        } else if (node instanceof SingleVariableDeclaration) {
            SingleVariableDeclaration svd = (SingleVariableDeclaration)node;
            if (svd.getParent() instanceof MethodDeclaration) {
                MethodDeclaration md = (MethodDeclaration)svd.getParent();
                resultQualifiedName = String.valueOf(JDTVisitorUtils.getQualifiedName((org.eclipse.jdt.core.dom.ASTNode)md)) + "." + svd.getName().getIdentifier();
            }
        } else if (node instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment vdf = (VariableDeclarationFragment)node;
            if (vdf.getParent() instanceof FieldDeclaration) {
                resultQualifiedName = JDTDelegateBindingFactory.getInstance().getBindingForName((Name)vdf.getName()).toString();
            }
        } else if (node instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumDecl = (EnumConstantDeclaration)node;
            resultQualifiedName = JDTDelegateBindingFactory.getInstance().getBindingForName((Name)enumDecl.getName()).toString();
        } else if (node instanceof AnnotationTypeMemberDeclaration) {
            AnnotationTypeMemberDeclaration annoDecl = (AnnotationTypeMemberDeclaration)node;
            resultQualifiedName = JDTDelegateBindingFactory.getInstance().getBindingForName((Name)annoDecl.getName()).toString();
        }
        if (TRACE_QN) {
            System.out.println("JavaDiscovererUtils/getQualifiedName : " + resultQualifiedName);
        }
        return resultQualifiedName;
    }
}

