/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.mm.chess.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.graphiti.examples.mm.chess.Board;
import org.eclipse.graphiti.examples.mm.chess.ChessFactory;
import org.eclipse.graphiti.examples.mm.chess.ChessPackage;
import org.eclipse.graphiti.examples.mm.chess.Colors;
import org.eclipse.graphiti.examples.mm.chess.Files;
import org.eclipse.graphiti.examples.mm.chess.Piece;
import org.eclipse.graphiti.examples.mm.chess.Ranks;
import org.eclipse.graphiti.examples.mm.chess.Square;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoardImpl
extends EObjectImpl
implements Board {
    protected EList<Square> squares;
    protected EList<Piece> pieces;

    protected BoardImpl() {
        int i = 0;
        while (i < 64) {
            Square square = ChessFactory.eINSTANCE.createSquare();
            square.setIndex(i);
            int rank = (63 - square.getIndex()) / 8 + 1;
            square.setRank(Ranks.get(rank));
            int file = square.getIndex() % 8 + 1;
            square.setFile(Files.get(file));
            Colors color = file % 2 == 0 ? (rank % 2 == 0 ? Colors.LIGHT : Colors.DARK) : (rank % 2 == 0 ? Colors.DARK : Colors.LIGHT);
            square.setColor(color);
            this.getSquares().add((Object)square);
            ++i;
        }
    }

    protected EClass eStaticClass() {
        return ChessPackage.Literals.BOARD;
    }

    @Override
    public EList<Square> getSquares() {
        if (this.squares == null) {
            this.squares = new EObjectContainmentWithInverseEList(Square.class, (InternalEObject)this, 0, 0);
        }
        return this.squares;
    }

    @Override
    public EList<Piece> getPieces() {
        if (this.pieces == null) {
            this.pieces = new EObjectContainmentWithInverseEList(Piece.class, (InternalEObject)this, 1, 3);
        }
        return this.pieces;
    }

    @Override
    public Square getSquare(Ranks rank, Files file) {
        for (Square square : this.getSquares()) {
            if (!rank.equals((Object)square.getRank()) || !file.equals((Object)square.getFile())) continue;
            return square;
        }
        return null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getSquares()).basicAdd((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getPieces()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getSquares()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getPieces()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getSquares();
            }
            case 1: {
                return this.getPieces();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getSquares().clear();
                this.getSquares().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getPieces().clear();
                this.getPieces().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getSquares().clear();
                return;
            }
            case 1: {
                this.getPieces().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.squares != null && !this.squares.isEmpty();
            }
            case 1: {
                return this.pieces != null && !this.pieces.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

