/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.ui.print;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.editor.GFFigureCanvas;
import org.eclipse.graphiti.ui.internal.fixed.FixedScaledGraphics;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.internal.util.ui.DefaultPreferences;
import org.eclipse.graphiti.ui.internal.util.ui.print.DefaultPrintPreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AbstractFigureSelectionDialog
extends Dialog
implements SelectionListener {
    protected GraphicalViewer _graphicalViewer;
    protected IFigure _allFigure;
    protected IFigure _selectionFigure;
    protected boolean _insideInternalModify = false;
    private Button _allFigureButton;
    private Button _selectionFigureButton;
    protected IFigure _figure;
    private Image _imageSelection;
    private Image _imageAll;
    protected Image _image;
    private Image _scaledImage;
    protected DefaultPreferences _preferences;
    private GraphicalEditPart _selectedEditPart;

    public AbstractFigureSelectionDialog(Shell shell, GraphicalViewer graphicalViewer) {
        super(shell);
        this._graphicalViewer = graphicalViewer;
        this._preferences = new DefaultPrintPreferences();
        this.determinePossibleFigures();
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.AbstractFigureSelectionDialog_0_xtxt);
        super.configureShell(newShell);
    }

    protected Group createChooseFigureGroup(Composite composite) {
        Group figureGroup = new Group(composite, 0);
        figureGroup.setText(Messages.AbstractFigureSelectionDialog_1_xtxt);
        GridLayout layout = new GridLayout(1, false);
        figureGroup.setLayout((Layout)layout);
        figureGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        boolean singleSelection = this.isFigureSelected();
        this._allFigureButton = new Button((Composite)figureGroup, 16);
        this._allFigureButton.setText(Messages.AbstractFigureSelectionDialog_2_xbut);
        this._allFigureButton.setSelection(!singleSelection);
        GridData data = new GridData(768);
        this._allFigureButton.setLayoutData((Object)data);
        this._allFigureButton.addSelectionListener((SelectionListener)this);
        this._selectionFigureButton = new Button((Composite)figureGroup, 16);
        this._selectionFigureButton.setText(Messages.AbstractFigureSelectionDialog_3_xbut);
        this._selectionFigureButton.setSelection(singleSelection);
        this._selectionFigureButton.setEnabled(this._selectionFigure != null);
        data = new GridData(768);
        this._selectionFigureButton.setLayoutData((Object)data);
        this._selectionFigureButton.addSelectionListener((SelectionListener)this);
        return figureGroup;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this._insideInternalModify) {
            return;
        }
        if (e.getSource() == this._allFigureButton || e.getSource() == this._selectionFigureButton) {
            this._figure = this._allFigureButton.getSelection() ? this._allFigure : this._selectionFigure;
            this._image = this._allFigureButton.getSelection() ? this._imageAll : this._imageSelection;
            this.updateControls();
        }
    }

    public void updateControls() {
    }

    public final IFigure getFigure() {
        return this._figure;
    }

    public final GraphicalViewer getGraphicalViewer() {
        return this._graphicalViewer;
    }

    private void determinePossibleFigures() {
        RootEditPart rootEditPart;
        this._allFigure = null;
        this._selectionFigure = null;
        this._figure = null;
        GraphicalViewer viewer = this.getGraphicalViewer();
        Control control = viewer.getControl();
        if (control instanceof GFFigureCanvas) {
            GFFigureCanvas canvas = (GFFigureCanvas)control;
            canvas.regainSpace();
        }
        if (!((rootEditPart = viewer.getRootEditPart()) instanceof GraphicalEditPart)) {
            return;
        }
        GraphicalEditPart graphicalRootEditPart = (GraphicalEditPart)rootEditPart;
        IFigure rootFigure = ((LayerManager)graphicalRootEditPart).getLayer((Object)"Printable Layers");
        if (rootFigure == null) {
            return;
        }
        this._allFigure = rootFigure;
        List selectedEditParts = viewer.getSelectedEditParts();
        Iterator iterator = selectedEditParts.iterator();
        if (iterator.hasNext()) {
            EditPart selectedEditPart = (EditPart)iterator.next();
            if (!(selectedEditPart instanceof GraphicalEditPart) || selectedEditPart == this.getGraphicalViewer().getContents()) {
                this._selectionFigure = null;
            } else {
                this._selectedEditPart = (GraphicalEditPart)selectedEditPart;
                this._selectionFigure = this._selectedEditPart.getFigure();
            }
        }
        this._figure = this._selectionFigure == null ? this._allFigure : this._selectionFigure;
    }

    public void setScaledImage(double scaleFactor, double upperBoundPixels) {
        this.cleanUp();
        this._imageAll = null;
        this._scaledImage = null;
        this._image = null;
        this.initImageAll(upperBoundPixels);
        this.initScaledImage(scaleFactor, upperBoundPixels);
        this.initImage();
    }

    public void setScaledImage(double scaleFactor) {
        this.setScaledImage(scaleFactor, 3000.0);
    }

    private void initImage() {
        if (this._selectionFigure != null) {
            this._imageSelection = new Image((Device)Display.getDefault(), this._selectionFigure.getBounds().width, this._selectionFigure.getBounds().height);
            GC gc = new GC((Drawable)this._imageSelection);
            SWTGraphics graphics = new SWTGraphics(gc);
            graphics.translate(-this._selectionFigure.getBounds().x, -this._selectionFigure.getBounds().y);
            this._selectionFigure.paint((Graphics)graphics);
            this.addRelatedEditParts((Graphics)graphics, this._selectedEditPart);
            if (gc != null) {
                gc.dispose();
            }
            if (graphics != null) {
                graphics.dispose();
            }
            this._image = this._imageSelection;
        } else {
            this._image = this._imageAll != null ? this._imageAll : null;
        }
    }

    private void initImageAll(double upperBoundPixels) {
        int width = this._allFigure.getBounds().width;
        int height = this._allFigure.getBounds().height;
        if ((double)width <= upperBoundPixels && (double)height <= upperBoundPixels) {
            this._imageAll = new Image((Device)Display.getDefault(), width, height);
            GC gc = new GC((Drawable)this._imageAll);
            SWTGraphics graphics = new SWTGraphics(gc);
            EditPart contents = this.getGraphicalViewer().getContents();
            if (contents instanceof GraphicalEditPart) {
                IFigure contentsFigure = ((GraphicalEditPart)contents).getFigure();
                Rectangle contentBounds = contentsFigure.getBounds();
                graphics.translate(-contentBounds.x, -contentBounds.y);
            }
            this._allFigure.paint((Graphics)graphics);
            if (gc != null) {
                gc.dispose();
            }
            if (graphics != null) {
                graphics.dispose();
            }
        } else {
            this._imageAll = null;
        }
    }

    private void initScaledImage(double scaleFactor, double upperBoundPixels) {
        GC gc = null;
        FixedScaledGraphics graphics = null;
        if (!this.isFigureSelected()) {
            if (scaleFactor * (double)this._allFigure.getBounds().width > upperBoundPixels || scaleFactor * (double)this._allFigure.getBounds().height > upperBoundPixels) {
                scaleFactor = Math.min(upperBoundPixels / (double)this._allFigure.getBounds().width, upperBoundPixels / (double)this._allFigure.getBounds().height);
            }
            this._scaledImage = new Image((Device)Display.getDefault(), (int)((double)this._allFigure.getBounds().width * scaleFactor), (int)(scaleFactor * (double)this._allFigure.getBounds().height));
            gc = new GC((Drawable)this._scaledImage);
            graphics = new FixedScaledGraphics((Graphics)new SWTGraphics(gc));
            graphics.scale(scaleFactor);
            EditPart contents = this.getGraphicalViewer().getContents();
            if (contents instanceof GraphicalEditPart) {
                IFigure contentsFigure = ((GraphicalEditPart)contents).getFigure();
                Rectangle contentBounds = contentsFigure.getBounds();
                graphics.translate(-contentBounds.x, -contentBounds.y);
            }
            this._allFigure.paint((Graphics)graphics);
        } else {
            if (scaleFactor * (double)this._selectionFigure.getBounds().width > upperBoundPixels || scaleFactor * (double)this._selectionFigure.getBounds().height > upperBoundPixels) {
                scaleFactor = Math.min(upperBoundPixels / (double)this._selectionFigure.getBounds().width, upperBoundPixels / (double)this._selectionFigure.getBounds().height);
            }
            this._scaledImage = new Image(null, (int)((double)this._selectionFigure.getBounds().width * scaleFactor), (int)(scaleFactor * (double)this._selectionFigure.getBounds().height));
            gc = new GC((Drawable)this._scaledImage);
            graphics = new FixedScaledGraphics((Graphics)new SWTGraphics(gc));
            graphics.scale(scaleFactor);
            graphics.translate(-this._selectionFigure.getBounds().x, -this._selectionFigure.getBounds().y);
            this._selectionFigure.paint((Graphics)graphics);
            this.addRelatedEditParts((Graphics)graphics, this._selectedEditPart);
        }
        if (gc != null) {
            gc.dispose();
        }
        if (graphics != null) {
            graphics.dispose();
        }
    }

    private void addRelatedEditParts(Graphics graphics, GraphicalEditPart ep) {
        List<EditPart> relatedEditParts = GraphitiUiInternal.getGefService().getConnectionsContainedInEditPart((EditPart)ep);
        for (EditPart conn : relatedEditParts) {
            PictogramElement pe;
            GraphicalEditPart conn2;
            if (!(conn instanceof GraphicalEditPart) || !((conn2 = (GraphicalEditPart)conn).getModel() instanceof PictogramElement) || !(pe = (PictogramElement)conn2.getModel()).isVisible()) continue;
            IFigure figure = conn2.getFigure();
            figure.paint(graphics);
        }
    }

    public Image getImage() {
        return this._image;
    }

    public Image getScaledImage() {
        return this._scaledImage;
    }

    private boolean isFigureSelected() {
        return this._selectedEditPart != null && (this._selectionFigureButton == null || this._selectionFigureButton.getSelection());
    }

    public void cleanUp() {
        if (this._scaledImage != null) {
            this._scaledImage.dispose();
        }
        if (this._image != null) {
            this._image.dispose();
        }
        if (this._imageAll != null) {
            this._imageAll.dispose();
        }
        if (this._imageSelection != null) {
            this._imageSelection.dispose();
        }
    }
}

