/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.context.internal;

import org.eclipse.gyrex.admin.ui.context.internal.AddContextDialog;
import org.eclipse.gyrex.admin.ui.context.internal.ContextUiLabelProvider;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.Infobox;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.context.internal.ContextActivator;
import org.eclipse.gyrex.context.internal.registry.ContextDefinition;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ContextsSection {
    private Composite pageComposite;
    private Button addButton;
    private Button removeButton;
    private ListViewer contextsList;
    protected IViewerObservableValue selectedValue;

    void addButtonPressed() {
        AddContextDialog dialog = new AddContextDialog(SwtUtil.getShell((Widget)this.addButton), this.getContextRegistry());
        dialog.openNonBlocking(new DialogCallback(){

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    ContextsSection.this.refresh();
                }
            }
        });
    }

    private Button createButton(Composite buttons, String buttonLabel) {
        Button b = new Button(buttons, 0);
        b.setText(buttonLabel);
        b.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return b;
    }

    public void createContextSectionControl(Composite parent) {
        this.pageComposite = parent;
        Infobox infobox = new Infobox(this.pageComposite);
        infobox.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        infobox.addHeading("Contexts section in Gyrex.");
        infobox.addParagraph("Gyrex provides a contextual runtime, which means it holds all its configuration information in the Context Tree, where configuration settings can be inherited and stored at the different context tree nodes. The context tree can reflect tenants or other configuration assets you build in your Gyrex application.<br/><br/>Every context is defined by name and path. ");
        Composite description = new Composite(this.pageComposite, 0);
        GridData gd = AdminUiUtil.createFillData();
        gd.verticalIndent = 10;
        description.setLayoutData((Object)gd);
        description.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin((int)2, (boolean)false));
        this.contextsList = new ListViewer(description, 2820);
        List list = this.contextsList.getList();
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.contextsList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.contextsList.setLabelProvider((IBaseLabelProvider)new ContextUiLabelProvider());
        this.contextsList.setInput((Object)this.getContextRegistry().getDefinedContexts());
        this.selectedValue = ViewersObservables.observeSingleSelection((Viewer)this.contextsList);
        Composite buttons = new Composite(description, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, false, true));
        buttons.setLayout((Layout)new GridLayout());
        this.addButton = this.createButton(buttons, "Add");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ContextsSection.this.addButtonPressed();
            }
        });
        this.removeButton = this.createButton(buttons, "Remove");
        this.removeButton.setEnabled(true);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ContextsSection.this.removeButtonPressed();
            }
        });
    }

    private ContextRegistryImpl getContextRegistry() {
        return ContextActivator.getInstance().getContextRegistryImpl();
    }

    private ContextDefinition getSelectedContext() {
        return (ContextDefinition)(this.selectedValue != null ? this.selectedValue.getValue() : null);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.contextsList;
    }

    public void refresh() {
        this.contextsList.setInput((Object)this.getContextRegistry().getDefinedContexts());
    }

    void removeButtonPressed() {
        final ContextDefinition contextDefinition = this.getSelectedContext();
        if (contextDefinition == null) {
            return;
        }
        NonBlockingMessageDialogs.openQuestion((Shell)SwtUtil.getShell((Widget)this.pageComposite), (String)"Remove Context", (String)String.format("Do you really want to delete the context %s?", contextDefinition.getPath() + contextDefinition.getName()), (DialogCallback)new DialogCallback(){

            public void dialogClosed(int returnCode) {
                if (returnCode != 0) {
                    return;
                }
                ContextsSection.this.getContextRegistry().removeDefinition(contextDefinition);
                ContextsSection.this.refresh();
            }
        });
    }
}

