/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.data.Stat;

public class RunningJob {
    final String storageKey;
    final String id;
    private final String nodeId;
    private final Stat stat;
    boolean aborting;

    public RunningJob(String storageKey, String id, String nodeId, Stat stat) {
        this.storageKey = storageKey;
        this.id = id;
        this.nodeId = nodeId;
        this.stat = stat;
    }

    public String getLabel() {
        StringBuilder l = new StringBuilder();
        l.append(this.id);
        l.append(" (");
        if (this.aborting) {
            l.append("ABORTING ");
        }
        l.append(this.nodeId).append(", started ");
        long started = System.currentTimeMillis() - this.stat.getCtime();
        if (started < TimeUnit.MINUTES.toMillis(2L)) {
            l.append("a minute ago");
        } else if (started < TimeUnit.HOURS.toMillis(1L)) {
            l.append(TimeUnit.MILLISECONDS.toMinutes(started)).append(" minutes ago");
        } else {
            if (started < TimeUnit.DAYS.toMillis(1L)) {
                l.append(TimeUnit.MILLISECONDS.toHours(started)).append(" hours ago");
                return String.format("%s (%s, started %d hours ago)", this.id, this.nodeId, TimeUnit.MILLISECONDS.toHours(started));
            }
            l.append(TimeUnit.MILLISECONDS.toDays(started)).append(" days ago");
            return String.format("%s (%s, started %d days ago)", this.id, this.nodeId, TimeUnit.MILLISECONDS.toDays(started));
        }
        l.append(')');
        return l.toString();
    }
}

