/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.p2.internal;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.admin.ui.p2.internal.FilteredIUSelectionDialog;
import org.eclipse.gyrex.admin.ui.p2.internal.P2UiLabelProvider;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.p2.internal.packages.IPackageManager;
import org.eclipse.gyrex.p2.internal.packages.InstallableUnitReference;
import org.eclipse.gyrex.p2.internal.packages.PackageDefinition;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class AddPackageDialog
extends StatusDialog {
    private final ILabelProvider labelProvider = new P2UiLabelProvider();
    private final StringDialogField idField = new StringDialogField();
    private final StringDialogField nodeFilterField = new StringDialogField();
    private final ListDialogField componentsField = new ListDialogField(new IListAdapter(){

        public void customButtonPressed(ListDialogField field, int index) {
            if (index == 0) {
                AddPackageDialog.this.addComponentButtonPressed();
            }
        }

        public void doubleClicked(ListDialogField field) {
        }

        public void selectionChanged(ListDialogField field) {
        }
    }, new String[]{"Add...", "Remove"}, this.labelProvider);
    private final IPackageManager packageManager;

    public AddPackageDialog(Shell parent, IPackageManager packageManager) {
        super(parent);
        this.packageManager = packageManager;
        this.setTitle("New Software Package");
        this.setShellStyle(67696);
    }

    void addComponentButtonPressed() {
        Object[] result;
        IQuery query = QueryUtil.createMatchQuery((String)"properties[$0] == true || providedCapabilities.exists(p | p.namespace == 'osgi.bundle')", (Object[])new Object[]{"org.eclipse.equinox.p2.type.group"});
        FilteredIUSelectionDialog dialog = new FilteredIUSelectionDialog(this.getShell(), (IQuery<IInstallableUnit>)query);
        int status = dialog.open();
        if (status == 0 && (result = dialog.getResult()) != null) {
            int i = 0;
            while (i < result.length) {
                if (result[i] instanceof IInstallableUnit) {
                    IInstallableUnit iu = (IInstallableUnit)result[i];
                    InstallableUnitReference unit = new InstallableUnitReference();
                    unit.setId(iu.getId());
                    unit.setVersion(iu.getVersion());
                    this.componentsField.addElement((Object)unit);
                }
                ++i;
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(200);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        this.idField.setLabelText("Id");
        this.nodeFilterField.setLabelText("Node Filter");
        this.componentsField.setRemoveButtonIndex(1);
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddPackageDialog.this.validate();
            }
        };
        this.idField.setDialogFieldListener(validateListener);
        this.nodeFilterField.setDialogFieldListener(validateListener);
        Text warning = new Text(composite, 72);
        warning.setText("Warning: this dialog is ugly. Please help us improve the UI. Any mockups and/or patches are very much appreciated!");
        warning.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.idField, this.nodeFilterField, new Separator(), this.componentsField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.idField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.componentsField.getListControl(null));
        GridLayout masterLayout = (GridLayout)composite.getLayout();
        masterLayout.marginWidth = 5;
        masterLayout.marginHeight = 5;
        LayoutUtil.setHorizontalSpan((Control)warning, (int)masterLayout.numColumns);
        return composite;
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        try {
            PackageDefinition packageDefinition = new PackageDefinition();
            packageDefinition.setId(this.idField.getText());
            packageDefinition.setNodeFilter(StringUtils.trimToNull((String)this.nodeFilterField.getText()));
            List components = this.componentsField.getElements();
            for (Object component : components) {
                packageDefinition.addComponentToInstall((InstallableUnitReference)component);
            }
            this.packageManager.savePackage(packageDefinition);
        }
        catch (Exception e) {
            this.setError(e.getMessage());
            return;
        }
        super.okPressed();
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.p2", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.p2", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.p2", message));
    }

    void validate() {
        String id = this.idField.getText();
        if (StringUtils.isNotBlank((String)id) && !IdHelper.isValidId((String)id)) {
            this.setError("The entered connector id is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.");
            return;
        }
        String nodeFilter = this.nodeFilterField.getText();
        if (StringUtils.isNotBlank((String)nodeFilter)) {
            try {
                FrameworkUtil.createFilter((String)nodeFilter);
            }
            catch (InvalidSyntaxException e) {
                this.setError("The entered node filter is invalid. Please use valid LDAP filter syntax. " + e.getMessage());
                return;
            }
        }
        if (StringUtils.isBlank((String)id)) {
            this.setInfo("Please enter a connector id.");
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

