/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.app;

import java.net.URL;

public class UrlUtil {
    public static String getNormalizedDomain(URL url) {
        return UrlUtil.normalizeDomain(url.getHost());
    }

    public static String getNormalizedPath(URL url) {
        return UrlUtil.stripTrailingSlahes(url.getPath());
    }

    public static int getNormalizedPort(URL url) {
        return url.getPort() != url.getDefaultPort() ? url.getPort() : -1;
    }

    public static String getNormalizedProtocol(URL url) {
        return url.getProtocol().toLowerCase();
    }

    public static boolean isDefaultPort(int port, String protocol) {
        switch (port) {
            case 80: {
                return "http".equals(protocol);
            }
            case 443: {
                return "https".equals(protocol);
            }
            case -1: 
            case 0: {
                return true;
            }
        }
        return false;
    }

    public static String normalizeDomain(String domain) {
        if (domain == null) {
            return null;
        }
        if (domain.endsWith(".")) {
            return domain.substring(0, domain.length() - 1);
        }
        return domain.toLowerCase();
    }

    private static String stripTrailingSlahes(String path) {
        while (path.length() > 0 && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private UrlUtil() {
    }
}

