/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal.application.manager;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.ApplicationException;
import org.eclipse.gyrex.http.application.context.IApplicationContext;
import org.eclipse.gyrex.http.internal.HttpDebug;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInstance {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationInstance.class);
    private final AtomicReference<Application> applicationRef;
    private final AtomicReference<IApplicationContext> applicationContextRef;
    private final String applicationId;

    public ApplicationInstance(Application application, IApplicationContext applicationContext) {
        this.applicationRef = new AtomicReference<Application>(application);
        this.applicationContextRef = new AtomicReference<IApplicationContext>(applicationContext);
        this.applicationId = application.getId();
    }

    void destroy() {
        Application application = this.getApplication();
        if (this.applicationRef.compareAndSet(application, null)) {
            try {
                try {
                    application.destroy();
                }
                catch (Exception e) {
                    if (HttpDebug.applicationLifecycle) {
                        LOG.debug("Error destorying application '{}'.", (Object)this.applicationId, (Object)e);
                    }
                    this.applicationContextRef.set(null);
                }
            }
            finally {
                this.applicationContextRef.set(null);
            }
        }
    }

    public Application getApplication() {
        return this.applicationRef.get();
    }

    public IApplicationContext getApplicationContext() {
        return this.applicationContextRef.get();
    }

    public void initialize() {
        Application application = this.getApplication();
        IApplicationContext applicationContext = this.applicationContextRef.get();
        if (application == null || applicationContext == null) {
            throw new IllegalStateException(String.format("Application '%s' already destroyed.", this.applicationId));
        }
        try {
            application.initialize(applicationContext);
        }
        catch (Exception e) {
            LOG.error("Error initializing application '{}'. {}", new Object[]{this.applicationId, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            throw new ApplicationException(500, "Initialization Error", e);
        }
    }
}

