/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal.application.manager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.gyrex.http.application.provider.ApplicationProvider;
import org.eclipse.gyrex.http.internal.HttpDebug;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationProviderRegistry
extends ServiceTracker<ApplicationProvider, ApplicationProvider> {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationProviderRegistry.class);
    private final ConcurrentMap<String, ApplicationProviderRegistration> providersById = new ConcurrentHashMap<String, ApplicationProviderRegistration>(1);
    private final List<ProviderListener> providerListeners = new CopyOnWriteArrayList<ProviderListener>();

    public ApplicationProviderRegistry(BundleContext context) {
        super(context, ApplicationProvider.class, null);
    }

    public ApplicationProvider addingService(ServiceReference<ApplicationProvider> reference) {
        ApplicationProvider provider = (ApplicationProvider)super.addingService(reference);
        if (HttpDebug.applicationLifecycle) {
            LOG.debug("Registering new ApplicationProvider: {}", (Object)provider);
        }
        ApplicationProviderRegistration registration = new ApplicationProviderRegistration(reference, provider);
        ApplicationProviderRegistration existingRegistration = this.providersById.putIfAbsent(provider.getId(), registration);
        if (existingRegistration != null) {
            LOG.error("Unable to add provider ({}) using id '{}' due to conflict with existing registration ({}). Please open a bug and ask for supporting multiple providers for the same id in different versions.");
        } else {
            for (ProviderListener l : this.providerListeners) {
                try {
                    l.providerAdded(registration);
                }
                catch (Exception e) {
                    if (!HttpDebug.debug) continue;
                    LOG.debug("Ignored exception in listener ({})", (Object)l, (Object)e);
                }
            }
        }
        return provider;
    }

    public void addProviderListener(ProviderListener listener) {
        this.providerListeners.add(listener);
    }

    public ApplicationProviderRegistration getProviderRegistration(String providerId) {
        return (ApplicationProviderRegistration)this.providersById.get(providerId);
    }

    public Map<String, ApplicationProviderRegistration> getRegisteredProviders() {
        return new HashMap<String, ApplicationProviderRegistration>(this.providersById);
    }

    public void removedService(ServiceReference<ApplicationProvider> reference, ApplicationProvider provider) {
        ApplicationProviderRegistration providerRegistration;
        if (HttpDebug.applicationLifecycle) {
            LOG.debug("Unregistering ApplicationProvider: {}", (Object)provider);
        }
        if ((providerRegistration = (ApplicationProviderRegistration)this.providersById.remove(provider.getId())) != null) {
            providerRegistration.destroy();
            for (ProviderListener l : this.providerListeners) {
                try {
                    l.providerRemoved(providerRegistration);
                }
                catch (Exception e) {
                    if (!HttpDebug.debug) continue;
                    LOG.debug("Ignored exception in listener ({})", (Object)l, (Object)e);
                }
            }
        }
        super.removedService(reference, (Object)provider);
    }

    public void removeProviderListener(ProviderListener listener) {
        this.providerListeners.remove(listener);
    }

    public static interface ProviderListener {
        public void providerAdded(ApplicationProviderRegistration var1);

        public void providerRemoved(ApplicationProviderRegistration var1);
    }
}

