/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal.httpservice;

import java.net.MalformedURLException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.http.application.manager.ApplicationRegistrationException;
import org.eclipse.gyrex.http.application.manager.IApplicationManager;
import org.eclipse.gyrex.http.application.manager.MountConflictException;
import org.eclipse.gyrex.server.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceAppComponent {
    private static final String DEFAULT_APP_ID = "org.eclipse.gyrex.http.httpservice.application";
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceAppComponent.class);
    private volatile IRuntimeContextRegistry runtimeContextRegistry;
    private volatile IApplicationManager applicationManager;

    public void activate() {
        if (!Platform.inDevelopmentMode() || Boolean.TRUE.toString().equals(System.getProperty("gyrex.http.equinoxhttpservice.default.disabled"))) {
            return;
        }
        IRuntimeContext context = this.getRuntimeContextRegistry().get((IPath)Path.ROOT);
        if (context == null) {
            LOG.warn("Unable to start default HttpService application; context {} not available", (Object)Path.ROOT.toString());
            return;
        }
        IApplicationManager manager = this.getApplicationManager();
        try {
            manager.register(DEFAULT_APP_ID, "org.eclipse.gyrex.http.httpservice.application.provider", context, null);
            try {
                manager.mount("http:/", DEFAULT_APP_ID);
                manager.mount("https:/", DEFAULT_APP_ID);
            }
            catch (MountConflictException e) {
                LOG.warn("Unable to register default HttpService application; failed to mount the application: {} ", (Object)e.toString());
                return;
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
        }
        catch (ApplicationRegistrationException applicationRegistrationException) {
            LOG.info("Application with id {} already registered. Not registering HttpService application again. ", (Object)DEFAULT_APP_ID);
            return;
        }
    }

    public void deactivate() {
    }

    public IApplicationManager getApplicationManager() {
        IApplicationManager manager = this.applicationManager;
        if (manager == null) {
            throw new IllegalStateException("application manager not available");
        }
        return manager;
    }

    public IRuntimeContextRegistry getRuntimeContextRegistry() {
        IRuntimeContextRegistry registry = this.runtimeContextRegistry;
        if (registry == null) {
            throw new IllegalStateException("context registry not available");
        }
        return registry;
    }

    public void setApplicationManager(IApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setRuntimeContextRegistry(IRuntimeContextRegistry runtimeContextRegistry) {
        this.runtimeContextRegistry = runtimeContextRegistry;
    }
}

