/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.gyrex.cloud.services.queue.IQueueService;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.registry.JobProviderRegistry;
import org.osgi.framework.BundleContext;

public class JobsActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.jobs";
    private static final AtomicReference<JobsActivator> instanceRef = new AtomicReference();
    private volatile IServiceProxy<IQueueService> queueServiceProxy;
    private volatile JobProviderRegistry jobProviderRegistry;

    public static JobsActivator getInstance() {
        JobsActivator activator = instanceRef.get();
        if (activator == null) {
            throw new IllegalStateException("inactive");
        }
        return activator;
    }

    public JobsActivator() {
        super(SYMBOLIC_NAME);
    }

    protected void doStart(BundleContext context) throws Exception {
        instanceRef.set(this);
        this.queueServiceProxy = this.getServiceHelper().trackService(IQueueService.class);
        this.jobProviderRegistry = new JobProviderRegistry(context);
        this.jobProviderRegistry.open();
    }

    protected void doStop(BundleContext context) throws Exception {
        instanceRef.set(null);
        this.queueServiceProxy = null;
        this.jobProviderRegistry.close();
        this.jobProviderRegistry = null;
    }

    protected Class<?> getDebugOptions() {
        return JobsDebug.class;
    }

    public JobProviderRegistry getJobProviderRegistry() {
        JobProviderRegistry providerRegistry = this.jobProviderRegistry;
        if (providerRegistry == null) {
            throw this.createBundleInactiveException();
        }
        return providerRegistry;
    }

    public IQueueService getQueueService() {
        IServiceProxy<IQueueService> proxy = this.queueServiceProxy;
        if (proxy == null) {
            this.createBundleInactiveException();
        }
        return (IQueueService)proxy.getService();
    }

    public void removeService(Object service) {
    }
}

