/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.commands;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.internal.commands.BaseScheduleStoreCmd;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleEntryImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class UpdateScheduleEntryCmd
extends BaseScheduleStoreCmd {
    @Argument(index=1, usage="the entry id", required=true, metaVar="ENTRYID")
    String entryId;
    @Option(name="--cron-expression", aliases={"-cron"}, usage="updates the cron expression", metaVar="EXPR")
    String cronExpression;
    @Option(name="--enable", aliases={"-on"}, usage="enables the schedule entry")
    Boolean enable;
    @Option(name="--disable", aliases={"-off"}, usage="disables the schedule entry")
    Boolean disable;
    @Option(name="--set-parameter", aliases={"-set"}, usage="sets a schedule paramater", multiValued=true, metaVar="KEY=VALUE")
    List<String> parameterToSet;
    @Option(name="--unset-parameter", aliases={"-unset"}, usage="unsets a schedule paramater", multiValued=true, metaVar="KEY")
    List<String> parameterToRemove;

    public UpdateScheduleEntryCmd() {
        super("<entryId> - Updates a schedule entry");
    }

    @Override
    protected void doExecute(String storageId, String scheduleId) throws Exception {
        String action;
        ScheduleImpl schedule = ScheduleStore.load(storageId, scheduleId, true);
        if (schedule.isEnabled()) {
            this.printf("Schedule %s is enabled, please disable first!", new Object[]{scheduleId});
            return;
        }
        if (!IdHelper.isValidId((String)this.entryId)) {
            throw new IllegalArgumentException("invalid entry id");
        }
        ScheduleEntryImpl entry = schedule.getEntry(this.entryId);
        if (this.enable != null && this.enable.booleanValue()) {
            action = "Enabled";
            entry.setEnabled(true);
        } else if (this.disable != null && this.disable.booleanValue()) {
            action = "Disabled";
            entry.setEnabled(false);
        } else {
            action = "Updated";
            if (this.cronExpression != null) {
                try {
                    entry.setCronExpression(this.cronExpression);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("invalid cron expression, please see http://en.wikipedia.org/wiki/Cron#CRON_expression", e);
                }
            }
            HashMap<String, String> newParameter = new HashMap<String, String>(entry.getJobParameter());
            if (this.parameterToSet != null) {
                for (String param : this.parameterToSet) {
                    String[] args = StringUtils.split((String)param, (String)"=", (int)2);
                    if (args == null || args.length != 2) {
                        throw new IllegalArgumentException(String.format("cannot parse parameter to set: %s; please check syntax", param));
                    }
                    newParameter.put(args[0], args[1]);
                }
                entry.setJobParameter(newParameter);
            }
            if (this.parameterToRemove != null) {
                for (String key : this.parameterToRemove) {
                    newParameter.remove(key);
                }
                entry.setJobParameter(newParameter);
            }
        }
        ScheduleStore.flush(storageId, schedule);
        this.printf("%s entry %s in schedule %s!", new Object[]{action, this.entryId, scheduleId});
    }
}

