/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.jobs.internal.manager.JobHistoryImpl;
import org.eclipse.gyrex.preferences.CloudScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class JobHistoryStore {
    private static final String NODE_HISTORY = "history";
    private static final String NODE_JOBS = "jobs";

    public static JobHistoryImpl create(String jobStorageKey, String jobId, IRuntimeContext context) throws BackingStoreException {
        IEclipsePreferences historyNode = JobHistoryStore.getHistoryNode(jobStorageKey);
        JobHistoryImpl jobHistoryImpl = new JobHistoryImpl(jobId, context.getContextPath());
        jobHistoryImpl.load(historyNode);
        return jobHistoryImpl;
    }

    public static void flush(String jobStorageKey, JobHistoryImpl history) throws BackingStoreException {
        IEclipsePreferences historyNode = JobHistoryStore.getHistoryNode(jobStorageKey);
        history.save(historyNode);
    }

    public static IEclipsePreferences getHistoryNode(String jobStorageKey) throws BackingStoreException {
        if (JobHistoryStore.getJobsNode().nodeExists(String.valueOf(jobStorageKey) + '/' + NODE_HISTORY)) {
            JobHistoryStore.migrateOldJobHistory(jobStorageKey);
        }
        return (IEclipsePreferences)JobHistoryStore.getJobsHistoryNode().node(jobStorageKey);
    }

    public static IEclipsePreferences getJobsHistoryNode() {
        return (IEclipsePreferences)CloudScope.INSTANCE.getNode("org.eclipse.gyrex.jobs").node(NODE_HISTORY);
    }

    public static IEclipsePreferences getJobsNode() {
        return (IEclipsePreferences)CloudScope.INSTANCE.getNode("org.eclipse.gyrex.jobs").node(NODE_JOBS);
    }

    private static void migrateOldJobHistory(String jobStorageKey) throws BackingStoreException {
        long abortTime = System.currentTimeMillis() + 60000L;
        while (JobHistoryStore.getJobsNode().nodeExists(String.valueOf(jobStorageKey) + '/' + NODE_HISTORY) && abortTime > System.currentTimeMillis()) {
            JobHistoryStore.getJobsNode().node(jobStorageKey).sync();
            try {
                Preferences newHistory = JobHistoryStore.getJobsHistoryNode().node(jobStorageKey);
                Preferences oldHistory = JobHistoryStore.getJobsNode().node(String.valueOf(jobStorageKey) + '/' + NODE_HISTORY);
                String[] stringArray = oldHistory.childrenNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    Preferences oldItem = oldHistory.node(name);
                    Preferences newItem = newHistory.node(name);
                    String[] stringArray2 = oldItem.keys();
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String key = stringArray2[n4];
                        String value = oldItem.get(key, null);
                        if (value != null) {
                            newItem.put(key, value);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                newHistory.flush();
                Preferences oldHistoryParent = oldHistory.parent();
                oldHistory.removeNode();
                oldHistoryParent.flush();
            }
            catch (Exception exception) {}
        }
    }
}

