/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.CLIText;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.opt.CmdLineParser;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(common=true, usage="usage_listCreateOrDeleteBranches")
class Branch
extends TextBuiltin {
    @Option(name="--remote", aliases={"-r"}, usage="usage_actOnRemoteTrackingBranches")
    private boolean remote = false;
    @Option(name="--all", aliases={"-a"}, usage="usage_listBothRemoteTrackingAndLocalBranches")
    private boolean all = false;
    @Option(name="--delete", aliases={"-d"}, usage="usage_deleteFullyMergedBranch")
    private boolean delete = false;
    @Option(name="--delete-force", aliases={"-D"}, usage="usage_deleteBranchEvenIfNotMerged")
    private boolean deleteForce = false;
    @Option(name="--create-force", aliases={"-f"}, usage="usage_forceCreateBranchEvenExists")
    private boolean createForce = false;
    @Option(name="-m", usage="usage_moveRenameABranch")
    private boolean rename = false;
    @Option(name="--verbose", aliases={"-v"}, usage="usage_beVerbose")
    private boolean verbose = false;
    @Argument
    private List<String> branches = new ArrayList<String>();
    private final Map<String, Ref> printRefs = new LinkedHashMap<String, Ref>();
    private RevWalk rw;
    private int maxNameLength;

    Branch() {
    }

    @Override
    protected void run() throws Exception {
        if (this.delete || this.deleteForce) {
            this.delete(this.deleteForce);
        } else {
            if (this.branches.size() > 2) {
                throw Branch.die(CLIText.get().tooManyRefsGiven + new CmdLineParser(this).printExample(ExampleMode.ALL));
            }
            if (this.rename) {
                String dst;
                String src;
                if (this.branches.size() == 1) {
                    Ref head = this.db.getRef("HEAD");
                    if (head == null || !head.isSymbolic()) {
                        throw Branch.die(CLIText.get().cannotRenameDetachedHEAD);
                    }
                    src = head.getLeaf().getName();
                    dst = this.branches.get(0);
                } else {
                    src = this.branches.get(0);
                    Ref old = this.db.getRef(src);
                    if (old == null) {
                        throw Branch.die(MessageFormat.format(CLIText.get().doesNotExist, src));
                    }
                    if (!old.getName().startsWith("refs/heads/")) {
                        throw Branch.die(MessageFormat.format(CLIText.get().notABranch, src));
                    }
                    src = old.getName();
                    dst = this.branches.get(1);
                }
                if (!dst.startsWith("refs/heads/")) {
                    dst = "refs/heads/" + dst;
                }
                if (!Repository.isValidRefName((String)dst)) {
                    throw Branch.die(MessageFormat.format(CLIText.get().notAValidRefName, dst));
                }
                RefRename r = this.db.renameRef(src, dst);
                if (r.rename() != RefUpdate.Result.RENAMED) {
                    throw Branch.die(MessageFormat.format(CLIText.get().cannotBeRenamed, src));
                }
            } else if (this.branches.size() > 0) {
                String newHead = this.branches.get(0);
                String startBranch = this.branches.size() == 2 ? this.branches.get(1) : "HEAD";
                Ref startRef = this.db.getRef(startBranch);
                ObjectId startAt = this.db.resolve(startBranch + "^0");
                startBranch = startRef != null ? startRef.getName() : startAt.name();
                startBranch = Repository.shortenRefName((String)startBranch);
                String newRefName = newHead;
                if (!newRefName.startsWith("refs/heads/")) {
                    newRefName = "refs/heads/" + newRefName;
                }
                if (!Repository.isValidRefName((String)newRefName)) {
                    throw Branch.die(MessageFormat.format(CLIText.get().notAValidRefName, newRefName));
                }
                if (!this.createForce && this.db.resolve(newRefName) != null) {
                    throw Branch.die(MessageFormat.format(CLIText.get().branchAlreadyExists, newHead));
                }
                RefUpdate updateRef = this.db.updateRef(newRefName);
                updateRef.setNewObjectId((AnyObjectId)startAt);
                updateRef.setForceUpdate(this.createForce);
                updateRef.setRefLogMessage(MessageFormat.format(CLIText.get().branchCreatedFrom, startBranch), false);
                RefUpdate.Result update = updateRef.update();
                if (update == RefUpdate.Result.REJECTED) {
                    throw Branch.die(MessageFormat.format(CLIText.get().couldNotCreateBranch, newHead, update.toString()));
                }
            } else {
                if (this.verbose) {
                    this.rw = new RevWalk(this.db);
                }
                this.list();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void list() throws Exception {
        Map refs = this.db.getAllRefs();
        Ref head = (Ref)refs.get("HEAD");
        if (head != null) {
            String current = head.getLeaf().getName();
            if (current.equals("HEAD")) {
                this.addRef("(no branch)", head);
            }
            this.addRefs(refs, "refs/heads/", !this.remote);
            this.addRefs(refs, "refs/remotes/", this.remote);
            ObjectReader reader = this.db.newObjectReader();
            try {
                for (Map.Entry<String, Ref> e : this.printRefs.entrySet()) {
                    Ref ref = e.getValue();
                    this.printHead(reader, e.getKey(), current.equals(ref.getName()), ref);
                }
            }
            finally {
                reader.release();
            }
        }
    }

    private void addRefs(Map<String, Ref> allRefs, String prefix, boolean add) {
        if (this.all || add) {
            for (Ref ref : RefComparator.sort(allRefs.values())) {
                String name = ref.getName();
                if (!name.startsWith(prefix)) continue;
                this.addRef(name.substring(name.indexOf(47, 5) + 1), ref);
            }
        }
    }

    private void addRef(String name, Ref ref) {
        this.printRefs.put(name, ref);
        this.maxNameLength = Math.max(this.maxNameLength, name.length());
    }

    private void printHead(ObjectReader reader, String ref, boolean isCurrent, Ref refObj) throws Exception {
        this.outw.print(isCurrent ? (char)'*' : ' ');
        this.outw.print(' ');
        this.outw.print((Object)ref);
        if (this.verbose) {
            int spaces = this.maxNameLength - ref.length() + 1;
            this.outw.format("%" + spaces + "s", new Object[]{""});
            ObjectId objectId = refObj.getObjectId();
            this.outw.print((Object)reader.abbreviate((AnyObjectId)objectId).name());
            this.outw.print(' ');
            this.outw.print((Object)this.rw.parseCommit((AnyObjectId)objectId).getShortMessage());
        }
        this.outw.println();
    }

    private void delete(boolean force) throws IOException {
        String current = this.db.getBranch();
        ObjectId head = this.db.resolve("HEAD");
        for (String branch : this.branches) {
            if (current.equals(branch)) {
                throw Branch.die(MessageFormat.format(CLIText.get().cannotDeleteTheBranchWhichYouAreCurrentlyOn, branch));
            }
            RefUpdate update = this.db.updateRef((this.remote ? "refs/remotes/" : "refs/heads/") + branch);
            update.setNewObjectId((AnyObjectId)head);
            update.setForceUpdate(force || this.remote);
            RefUpdate.Result result = update.delete();
            if (result == RefUpdate.Result.REJECTED) {
                throw Branch.die(MessageFormat.format(CLIText.get().branchIsNotAnAncestorOfYourCurrentHEAD, branch));
            }
            if (result == RefUpdate.Result.NEW) {
                throw Branch.die(MessageFormat.format(CLIText.get().branchNotFound, branch));
            }
            if (this.remote) {
                this.outw.println(MessageFormat.format(CLIText.get().deletedRemoteBranch, branch));
                continue;
            }
            if (!this.verbose) continue;
            this.outw.println(MessageFormat.format(CLIText.get().deletedBranch, branch));
        }
    }
}

