/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JptPlugin
extends Plugin {
    protected BundleContext bundleContext;
    protected ServiceTracker<DebugOptions, DebugOptions> debugOptionsServiceTracker;
    protected static final String DEBUG_OPTION_SCOPE = "/debug/";

    protected JptPlugin() {
    }

    public void logError(String message) {
        this.log(4, message);
    }

    public void log(int severity, String message) {
        this.log(severity, message, null);
    }

    public void logError(Throwable throwable) {
        this.log(4, throwable);
    }

    public void log(int severity, Throwable throwable) {
        this.log(severity, throwable.getLocalizedMessage(), throwable);
    }

    public void logError(String msg, Throwable throwable) {
        this.log(4, msg, throwable);
    }

    public void log(int severity, String msg, Throwable throwable) {
        this.log(severity, 0, msg, throwable);
    }

    public void log(int severity, int code, String msg, Throwable throwable) {
        this.getLog().log((IStatus)new Status(severity, this.getPluginID(), code, msg, throwable));
    }

    public boolean getBooleanDebugOption(String option) {
        return this.getBooleanDebugOption(option, false);
    }

    public boolean getBooleanDebugOption(String option, boolean defaultValue) {
        String value = this.getDebugOption(option);
        return value == null ? defaultValue : Boolean.parseBoolean(value.trim());
    }

    public int getIntegerDebugOption(String option) {
        return this.getIntegerDebugOption(option, -1);
    }

    public int getIntegerDebugOption(String option, int defaultValue) {
        String value = this.getDebugOption(option);
        return value == null ? defaultValue : Integer.parseInt(value.trim());
    }

    public String getDebugOption(String option) {
        return this.getDebugOption(option, null);
    }

    public String getDebugOption(String option, String defaultValue) {
        return this.isDebugging() ? this.getDebugOption_(option, defaultValue) : defaultValue;
    }

    protected String getDebugOption_(String option, String defaultValue) {
        if (StringTools.stringIsEmpty((String)option)) {
            throw new IllegalArgumentException("debug option cannot be blank");
        }
        String value = this.getDebugOption_(option);
        return value != null ? value : defaultValue;
    }

    protected String getDebugOption_(String option) {
        DebugOptions debugOptions = this.getDebugOptions();
        return debugOptions == null ? null : debugOptions.getOption(String.valueOf(this.getPluginDebugOption()) + option);
    }

    protected DebugOptions getDebugOptions() {
        ServiceTracker<DebugOptions, DebugOptions> tracker = this.getDebugOptionsServiceTracker();
        return tracker == null ? null : (DebugOptions)tracker.getService();
    }

    private synchronized ServiceTracker<DebugOptions, DebugOptions> getDebugOptionsServiceTracker() {
        if (this.isActive() && this.debugOptionsServiceTracker == null) {
            this.debugOptionsServiceTracker = this.buildDebugOptionsServiceTracker();
            this.debugOptionsServiceTracker.open();
        }
        return this.debugOptionsServiceTracker;
    }

    private ServiceTracker<DebugOptions, DebugOptions> buildDebugOptionsServiceTracker() {
        return new ServiceTracker(this.bundleContext, DebugOptions.class, null);
    }

    protected String getPluginDebugOption() {
        return String.valueOf(this.getPluginID()) + DEBUG_OPTION_SCOPE;
    }

    public synchronized void start(BundleContext context) throws Exception {
        super.start(context);
        this.bundleContext = context;
    }

    public synchronized void stop(BundleContext context) throws Exception {
        try {
            this.stop_();
        }
        finally {
            this.bundleContext = null;
            super.stop(context);
        }
    }

    protected void stop_() throws Exception {
        if (this.debugOptionsServiceTracker != null) {
            this.debugOptionsServiceTracker.close();
            this.debugOptionsServiceTracker = null;
        }
    }

    public String getPluginID() {
        return this.getBundle().getSymbolicName();
    }

    public synchronized boolean isActive() {
        return this.bundleContext != null;
    }

    public boolean isInactive() {
        return !this.isActive();
    }
}

