/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.SimpleJavaResourceLocator;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class PluginResourceLocator
extends SimpleJavaResourceLocator {
    public IContainer getDefaultResourceLocation(IProject project) {
        IContainer bundleRoot = this.getBundleRoot(project);
        return bundleRoot != null ? bundleRoot.getFolder(META_INF_PATH) : super.getDefaultResourceLocation(project);
    }

    public IPath getResourcePath(IProject project, IPath runtimePath) {
        IContainer bundleRoot = this.getBundleRoot(project);
        if (bundleRoot != null) {
            IPath resourcePath = bundleRoot.getFullPath().append(runtimePath);
            if (project.getWorkspace().getRoot().getFile(resourcePath).exists()) {
                return resourcePath;
            }
        }
        return super.getResourcePath(project, runtimePath);
    }

    public IPath getRuntimePath(IProject project, IPath resourcePath) {
        IFile file;
        IContainer bundleRoot = this.getBundleRoot(project);
        if (bundleRoot != null && bundleRoot.contains((ISchedulingRule)(file = PlatformTools.getFile(resourcePath)))) {
            return resourcePath.makeRelativeTo(bundleRoot.getFullPath());
        }
        return super.getRuntimePath(project, resourcePath);
    }

    protected IContainer getBundleRoot(IProject project) {
        try {
            return this.getBundleRoot_(project);
        }
        catch (CoreException ex) {
            JptCommonCorePlugin.log(ex);
            return null;
        }
    }

    protected IContainer getBundleRoot_(IProject project) throws CoreException {
        BundleContext bundleContext = JptCommonCorePlugin.instance().getBundle().getBundleContext();
        if (bundleContext == null) {
            return project;
        }
        ServiceReference serviceRef = bundleContext.getServiceReference(IBundleProjectService.class);
        if (serviceRef == null) {
            return project;
        }
        IBundleProjectService service = (IBundleProjectService)bundleContext.getService(serviceRef);
        if (service == null) {
            bundleContext.ungetService(serviceRef);
            return project;
        }
        IPath bundleRoot = service.getDescription(project).getBundleRoot();
        bundleContext.ungetService(serviceRef);
        return bundleRoot == null ? project : project.getFolder(bundleRoot);
    }

    protected IBundleProjectService getBundleProjectService() {
        BundleContext context = JptCommonCorePlugin.instance().getBundle().getBundleContext();
        ServiceReference reference = context.getServiceReference(IBundleProjectService.class);
        if (reference == null) {
            return null;
        }
        IBundleProjectService service = (IBundleProjectService)context.getService(reference);
        if (service != null) {
            context.ungetService(reference);
        }
        return service;
    }
}

