/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTMember;
import org.eclipse.jpt.common.core.internal.utility.jdt.JPTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.core.utility.jdt.MethodAttribute;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.utility.JavaType;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.command.CommandExecutor;
import org.eclipse.jpt.common.utility.internal.NameTools;
import org.eclipse.jpt.common.utility.internal.SimpleMethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTMethodAttribute
extends JDTMember
implements MethodAttribute {
    private final JavaType[] parameterTypes;
    protected static final MethodDeclaration[] EMPTY_METHOD_DECLARATION_ARRAY = new MethodDeclaration[0];

    public static JDTMethodAttribute newInstance(Type declaringType, MethodSignature signature, int occurrence, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor) {
        return JDTMethodAttribute.newInstance(declaringType, signature, occurrence, compilationUnit, modifySharedDocumentCommandExecutor, DefaultAnnotationEditFormatter.instance());
    }

    public static JDTMethodAttribute newInstance(Type declaringType, MethodSignature signature, int occurrence, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor, AnnotationEditFormatter annotationEditFormatter) {
        return new JDTMethodAttribute(declaringType, signature, occurrence, compilationUnit, modifySharedDocumentCommandExecutor, annotationEditFormatter);
    }

    private JDTMethodAttribute(Type declaringType, MethodSignature methodSignature, int occurrence, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor, AnnotationEditFormatter annotationEditFormatter) {
        super(declaringType, methodSignature.getName(), occurrence, compilationUnit, modifySharedDocumentCommandExecutor, annotationEditFormatter);
        this.parameterTypes = methodSignature.getParameterTypes();
    }

    public JDTMethodAttribute(Type declaringType, String name, String[] parameterTypeNames, int occurrence, ICompilationUnit compilationUnit) {
        this(declaringType, (MethodSignature)new SimpleMethodSignature(name, parameterTypeNames), occurrence, compilationUnit, CommandExecutor.Default.instance(), (AnnotationEditFormatter)DefaultAnnotationEditFormatter.instance());
    }

    @Override
    protected Type getDeclaringType() {
        return (Type)super.getDeclaringType();
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public IMethodBinding getBinding(CompilationUnit astRoot) {
        return this.getBodyDeclaration(astRoot).resolveBinding();
    }

    @Override
    public MethodDeclaration getBodyDeclaration(CompilationUnit astRoot) {
        int count = 0;
        MethodDeclaration[] methodDeclarationArray = this.getDeclaringTypeMethodDeclarations(astRoot);
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            if (this.matches(methodDeclaration) && ++count == this.getOccurrence()) {
                return methodDeclaration;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean matches(MethodSignature signature, int occurrence) {
        return this.matches(signature) && occurrence == this.getOccurrence();
    }

    protected boolean matches(MethodSignature signature) {
        return signature.getName().equals(this.getName()) && Arrays.equals(this.parameterTypes, signature.getParameterTypes());
    }

    protected boolean matches(MethodDeclaration methodDeclaration) {
        return this.matches(ASTTools.buildMethodSignature(methodDeclaration));
    }

    protected static List<SingleVariableDeclaration> parameters(MethodDeclaration methodDeclaration) {
        return methodDeclaration.parameters();
    }

    @Override
    public boolean matches(String memberName, int occurrence) {
        throw new UnsupportedOperationException("Use #matches(MethodSignature, int).");
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        MethodDeclaration methodDeclaration = this.getBodyDeclaration(astRoot);
        return methodDeclaration == null ? null : ASTTools.buildTextRange((ASTNode)methodDeclaration.getName());
    }

    @Override
    public String getAttributeName() {
        return NameTools.convertGetterSetterMethodNameToPropertyName((String)this.getName());
    }

    @Override
    public ITypeBinding getTypeBinding(CompilationUnit astRoot) {
        IMethodBinding methodBinding = this.getBodyDeclaration(astRoot).resolveBinding();
        return methodBinding == null ? null : methodBinding.getReturnType();
    }

    @Override
    public boolean isPersistable(CompilationUnit astRoot) {
        IMethodBinding binding = this.getBinding(astRoot);
        return binding == null ? false : JPTTools.methodIsPersistablePropertyGetter(new JPTToolsAdapter(binding));
    }

    protected TypeDeclaration getDeclaringTypeDeclaration(CompilationUnit astRoot) {
        return this.getDeclaringType().getBodyDeclaration(astRoot);
    }

    protected MethodDeclaration[] getDeclaringTypeMethodDeclarations(CompilationUnit astRoot) {
        TypeDeclaration typeDeclaration = this.getDeclaringTypeDeclaration(astRoot);
        return typeDeclaration == null ? EMPTY_METHOD_DECLARATION_ARRAY : typeDeclaration.getMethods();
    }

    protected static class JPTToolsAdapter
    extends SimpleJPTToolsAdapter
    implements JPTTools.MethodAdapter {
        protected JPTToolsAdapter(IMethodBinding methodBinding) {
            super(methodBinding);
        }

        public String getName() {
            return this.methodBinding.getName();
        }

        public int getParametersLength() {
            return this.methodBinding.getParameterTypes().length;
        }

        public JPTTools.SimpleMethodAdapter getSibling(String name) {
            ITypeBinding typeBinding = this.methodBinding.getDeclaringClass();
            if (typeBinding == null) {
                return null;
            }
            IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding sibling = iMethodBindingArray[n2];
                if (sibling.getParameterTypes().length == 0 && sibling.getName().equals(name)) {
                    return new SimpleJPTToolsAdapter(sibling);
                }
                ++n2;
            }
            return null;
        }

        public JPTTools.SimpleMethodAdapter getSibling(String name, String parameterTypeErasureName) {
            ITypeBinding typeBinding = this.methodBinding.getDeclaringClass();
            if (typeBinding == null) {
                return null;
            }
            IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding sibling = iMethodBindingArray[n2];
                ITypeBinding[] siblingParmTypes = sibling.getParameterTypes();
                if (siblingParmTypes.length == 1 && sibling.getName().equals(name) && siblingParmTypes[0].getTypeDeclaration().getErasure().getQualifiedName().equals(parameterTypeErasureName)) {
                    return new SimpleJPTToolsAdapter(sibling);
                }
                ++n2;
            }
            return null;
        }
    }

    protected static class SimpleJPTToolsAdapter
    implements JPTTools.SimpleMethodAdapter {
        protected final IMethodBinding methodBinding;

        protected SimpleJPTToolsAdapter(IMethodBinding methodBinding) {
            if (methodBinding == null) {
                throw new NullPointerException();
            }
            this.methodBinding = methodBinding;
        }

        public int getModifiers() {
            return this.methodBinding.getModifiers();
        }

        public String getReturnTypeErasureName() {
            ITypeBinding returnType = this.methodBinding.getReturnType();
            return returnType == null ? null : returnType.getTypeDeclaration().getErasure().getQualifiedName();
        }

        public boolean isConstructor() {
            return this.methodBinding.isConstructor();
        }
    }
}

