/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemLabelProvider;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemExtendedLabelProvider<I>
implements ItemExtendedLabelProvider {
    protected final ItemLabelProvider.Manager manager;
    protected final I item;
    protected volatile PropertyChangeListener listener;
    protected volatile PropertyValueModel<Image> imageModel;
    protected volatile PropertyValueModel<String> textModel;
    protected volatile PropertyValueModel<String> descriptionModel;

    protected AbstractItemExtendedLabelProvider(I item, ItemLabelProvider.Manager manager) {
        this.item = item;
        this.manager = manager;
    }

    @Override
    public Image getImage() {
        return (Image)this.getImageModel().getValue();
    }

    protected synchronized PropertyValueModel<Image> getImageModel() {
        if (this.imageModel == null) {
            this.imageModel = this.buildImageModel();
            this.engageImageModel();
        }
        return this.imageModel;
    }

    protected PropertyValueModel<Image> buildImageModel() {
        throw new UnsupportedOperationException();
    }

    protected void engageImageModel() {
        this.imageModel.addPropertyChangeListener("value", this.getListener());
    }

    protected void disengageImageModel() {
        this.imageModel.removePropertyChangeListener("value", this.listener);
    }

    protected void disposeImageModel() {
        if (this.imageModel != null) {
            this.disengageImageModel();
            this.imageModel = null;
        }
    }

    @Override
    public String getText() {
        return (String)this.getTextModel().getValue();
    }

    protected synchronized PropertyValueModel<String> getTextModel() {
        if (this.textModel == null) {
            this.textModel = this.buildTextModel();
            this.engageTextModel();
        }
        return this.textModel;
    }

    protected PropertyValueModel<String> buildTextModel() {
        throw new UnsupportedOperationException();
    }

    protected void engageTextModel() {
        this.textModel.addPropertyChangeListener("value", this.getListener());
    }

    protected void disengageTextModel() {
        this.textModel.removePropertyChangeListener("value", this.listener);
    }

    protected void disposeTextModel() {
        if (this.textModel != null) {
            this.disengageTextModel();
            this.textModel = null;
        }
    }

    @Override
    public String getDescription() {
        return (String)this.getDescriptionModel().getValue();
    }

    protected synchronized PropertyValueModel<String> getDescriptionModel() {
        if (this.descriptionModel == null) {
            this.descriptionModel = this.buildDescriptionModel();
            this.engageDescriptionModel();
        }
        return this.descriptionModel;
    }

    protected PropertyValueModel<String> buildDescriptionModel() {
        throw new UnsupportedOperationException();
    }

    protected void engageDescriptionModel() {
        this.descriptionModel.addPropertyChangeListener("value", this.getListener());
    }

    protected void disengageDescriptionModel() {
        this.descriptionModel.removePropertyChangeListener("value", this.listener);
    }

    protected void disposeDescriptionModel() {
        if (this.descriptionModel != null) {
            this.disengageDescriptionModel();
            this.descriptionModel = null;
        }
    }

    protected synchronized PropertyChangeListener getListener() {
        if (this.listener == null) {
            this.listener = this.buildListener();
        }
        return this.listener;
    }

    protected PropertyChangeListener buildListener() {
        return new Listener();
    }

    void itemChanged() {
        this.manager.updateLabel(this.item);
    }

    @Override
    public synchronized void dispose() {
        this.disposeImageModel();
        this.disposeTextModel();
        this.disposeDescriptionModel();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.item);
    }

    class Listener
    extends PropertyChangeAdapter {
        Listener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            AbstractItemExtendedLabelProvider.this.itemChanged();
        }
    }
}

