/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jpt.common.utility.internal.StringTools;

public abstract class AbstractSelectionProvider
extends EventManager
implements ISelectionProvider {
    protected AbstractSelectionProvider() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.addListenerObject(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.removeListenerObject(listener);
    }

    protected void fireSelectionChanged(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ListenerNotifier(listener, event));
            ++n2;
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)((Object)this));
    }

    class ListenerNotifier
    extends SafeRunnable {
        private final ISelectionChangedListener listener;
        private final SelectionChangedEvent event;

        ListenerNotifier(Object listener, SelectionChangedEvent event) {
            this.listener = (ISelectionChangedListener)listener;
            this.event = event;
        }

        public void run() {
            this.listener.selectionChanged(this.event);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)((Object)this), (Object)this.listener);
        }
    }
}

