/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.util;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SWTUtil {
    public static void asyncExec(Runnable runnable) {
        SWTUtil.getDisplay().asyncExec(runnable);
    }

    public static void syncExec(Runnable runnable) {
        SWTUtil.getDisplay().syncExec(runnable);
    }

    public static void delayedExec(Runnable runnable) {
        SWTUtil.timerExec(OpenStrategy.getPostSelectionDelay(), runnable);
    }

    public static void timerExec(int milliseconds, Runnable runnable) {
        SWTUtil.getDisplay().timerExec(milliseconds, runnable);
    }

    public static void execute(Runnable runnable) {
        Display display = Display.getCurrent();
        if (display != null) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public static void execute(Viewer viewer, Runnable runnable) {
        SWTUtil.execute(viewer.getControl(), runnable);
    }

    public static void execute(Control control, Runnable runnable) {
        SWTUtil.execute(control.getDisplay(), runnable);
    }

    public static void execute(Display display, Runnable runnable) {
        if (display.getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            display.asyncExec(runnable);
        }
    }

    public static Shell getShell() {
        Shell shell = SWTUtil.getDisplay().getActiveShell();
        if (shell != null) {
            return shell;
        }
        shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return shell != null ? shell : new Shell();
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        return display != null ? display : Display.getDefault();
    }

    public static void center(Shell shell) {
        shell.setBounds(SWTUtil.calculateCenteredBounds(shell.getBounds(), shell.getDisplay().getBounds()));
    }

    public static void center(Shell shell, Shell parentShell) {
        shell.setBounds(SWTUtil.calculateCenteredBounds(shell.getBounds(), parentShell.getBounds()));
    }

    public static Rectangle calculateCenteredBounds(Rectangle rectangle1, Rectangle rectangle2) {
        return SWTUtil.calculateCenteredBounds(rectangle1.width, rectangle1.height, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public static Rectangle calculateCenteredBounds(Point size1, Point size2) {
        return SWTUtil.calculateCenteredBounds(size1.x, size1.y, size2.x, size2.y);
    }

    public static Rectangle calculateCenteredBounds(int width1, int height1, int width2, int height2) {
        return SWTUtil.calculateCenteredBounds(width1, height1, 0, 0, width2, height2);
    }

    public static Rectangle calculateCenteredBounds(int width1, int height1, int x2, int y2, int width2, int height2) {
        return new Rectangle(x2 + (width2 - width1) / 2, y2 + (height2 - height1) / 2, width1, height1);
    }

    public static Point calculateCenteredPosition(Rectangle rectangle1, Rectangle rectangle2) {
        return SWTUtil.calculateCenteredPosition(rectangle1.width, rectangle1.height, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public static Point calculateCenteredPosition(Point size1, Point size2) {
        return SWTUtil.calculateCenteredPosition(size1.x, size1.y, size2.x, size2.y);
    }

    public static Point calculateCenteredPosition(int width1, int height1, int width2, int height2) {
        return SWTUtil.calculateCenteredPosition(width1, height1, 0, 0, width2, height2);
    }

    public static Point calculateCenteredPosition(int width1, int height1, int x2, int y2, int width2, int height2) {
        return new Point(x2 + (width2 - width1) / 2, y2 + (height2 - height1) / 2);
    }

    public static void attachDefaultValueHandler(Combo combo) {
        ComboHandler handler = new ComboHandler();
        combo.addFocusListener((FocusListener)handler);
        combo.addModifyListener((ModifyListener)handler);
    }

    public static int getTableHeightHint(Table table, int rows) {
        if (table.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            table.setFont(JFaceResources.getDialogFont());
        }
        int result = table.getItemHeight() * rows + table.getHeaderHeight();
        if (table.getLinesVisible()) {
            result += table.getGridLineWidth() * (rows - 1);
        }
        return result;
    }

    public static void reflow(Composite pane) {
        Composite composite = pane;
        while (composite != null) {
            composite.setRedraw(false);
            composite = composite.getParent();
            if (composite instanceof ScrolledForm || composite instanceof Shell) break;
        }
        for (composite = pane; composite != null; composite = composite.getParent()) {
            composite.layout(true);
            if (!(composite instanceof ScrolledForm)) continue;
            ((ScrolledForm)composite).reflow(true);
            break;
        }
        composite = pane;
        while (composite != null) {
            composite.setRedraw(true);
            composite = composite.getParent();
            if (composite instanceof ScrolledForm || composite instanceof Shell) break;
        }
    }

    public static boolean uiThread() {
        return Display.getCurrent() != null;
    }

    public static boolean uiThread(Viewer viewer) {
        return SWTUtil.uiThread((Widget)viewer.getControl());
    }

    public static boolean uiThread(Widget widget) {
        return widget.getDisplay().getThread() == Thread.currentThread();
    }

    private static class ComboHandler
    implements ModifyListener,
    FocusListener {
        private ComboHandler() {
        }

        public void focusGained(FocusEvent e) {
            Combo combo = (Combo)e.widget;
            if (combo.getSelectionIndex() == 0) {
                SWTUtil.asyncExec(new SelectText(combo));
            }
        }

        public void focusLost(FocusEvent e) {
        }

        public void modifyText(ModifyEvent e) {
            Combo combo = (Combo)e.widget;
            if (combo.isFocusControl() && combo.getSelectionIndex() == 0) {
                SWTUtil.asyncExec(new ModifyText(combo));
            }
        }

        private class ModifyText
        implements Runnable {
            private final Combo combo;

            public ModifyText(Combo combo) {
                this.combo = combo;
            }

            public void run() {
                if (this.combo.isDisposed()) {
                    return;
                }
                String text = this.combo.getText();
                if (text.length() == 0) {
                    text = this.combo.getItem(0);
                    this.combo.setText(text);
                }
                this.combo.setSelection(new Point(0, text.length()));
            }
        }

        private class SelectText
        implements Runnable {
            private final Combo combo;

            public SelectText(Combo combo) {
                this.combo = combo;
            }

            public void run() {
                if (this.combo.isDisposed()) {
                    return;
                }
                String text = this.combo.getText();
                this.combo.setSelection(new Point(0, text.length()));
            }
        }
    }
}

