/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.utility.swt;

import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextFieldModelBinding {
    private final ModifiablePropertyValueModel<String> textModel;
    private final PropertyChangeListener textModelChangeListener;
    private final Text textField;
    private final ModifyListener textFieldModifyListener;
    private final DisposeListener textFieldDisposeListener;
    private boolean settingTextFieldText = false;

    TextFieldModelBinding(ModifiablePropertyValueModel<String> textModel, Text textField) {
        if (textModel == null || textField == null) {
            throw new NullPointerException();
        }
        this.textModel = textModel;
        this.textField = textField;
        this.textModelChangeListener = this.buildTextModelChangeListener();
        this.textModel.addPropertyChangeListener("value", this.textModelChangeListener);
        this.textFieldModifyListener = this.buildTextFieldModifyListener();
        this.textField.addModifyListener(this.textFieldModifyListener);
        this.textFieldDisposeListener = this.buildTextFieldDisposeListener();
        this.textField.addDisposeListener(this.textFieldDisposeListener);
        this.setTextFieldText((String)textModel.getValue());
    }

    private PropertyChangeListener buildTextModelChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildTextModelChangeListener_());
    }

    private PropertyChangeListener buildTextModelChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                TextFieldModelBinding.this.textModelChanged(event);
            }

            public String toString() {
                return "text listener";
            }
        };
    }

    private ModifyListener buildTextFieldModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TextFieldModelBinding.this.textFieldModified();
            }

            public String toString() {
                return "text field modify listener";
            }
        };
    }

    private DisposeListener buildTextFieldDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TextFieldModelBinding.this.textFieldDisposed();
            }

            public String toString() {
                return "text field dispose listener";
            }
        };
    }

    void textModelChanged(PropertyChangeEvent event) {
        if (!this.textField.isDisposed()) {
            this.setTextFieldText((String)event.getNewValue());
        }
    }

    private void setTextFieldText(String text) {
        this.setTextFieldText_(text == null ? "" : text);
    }

    private void setTextFieldText_(String text) {
        if (!text.equals(this.textField.getText())) {
            this.setTextFieldText__(text);
        }
    }

    private void setTextFieldText__(String text) {
        this.settingTextFieldText = true;
        try {
            this.textField.setText(text);
        }
        finally {
            this.settingTextFieldText = false;
        }
    }

    void textFieldModified() {
        if (!this.settingTextFieldText) {
            this.setTextModelText(this.textField.getText());
        }
    }

    private void setTextModelText(String text) {
        if (!text.equals(this.textModel.getValue())) {
            this.textModel.setValue((Object)text);
        }
    }

    void textFieldDisposed() {
        this.textField.removeDisposeListener(this.textFieldDisposeListener);
        this.textField.removeModifyListener(this.textFieldModifyListener);
        this.textModel.removePropertyChangeListener("value", this.textModelChangeListener);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.textModel);
    }
}

