/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.jaxb.core.GenericJaxbPlatform;
import org.eclipse.jpt.jaxb.core.GenericJaxbProjectManager;
import org.eclipse.jpt.jaxb.core.JaxbFacet;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbProjectManager;
import org.eclipse.jpt.jaxb.core.internal.platform.JaxbPlatformManagerImpl;
import org.eclipse.jpt.jaxb.core.internal.prefs.JaxbPreferencesManager;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformManager;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JptJaxbCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.jpt.jaxb.core";
    public static final String PLUGIN_ID_ = "org.eclipse.jpt.jaxb.core.";
    public static final String VALIDATION_MARKER_ID = "org.eclipse.jpt.jaxb.core.jaxbProblemMarker";
    public static final IContentType JAXB_INDEX_CONTENT_TYPE = JptJaxbCorePlugin.getJaxbContentType("jaxbIndex");
    public static final JptResourceType JAXB_INDEX_RESOURCE_TYPE = new JptResourceType(JAXB_INDEX_CONTENT_TYPE);
    public static final IContentType JAXB_PROPERTIES_CONTENT_TYPE = JptJaxbCorePlugin.getJaxbContentType("jaxbProperties");
    public static final JptResourceType JAXB_PROPERTIES_RESOURCE_TYPE = new JptResourceType(JAXB_PROPERTIES_CONTENT_TYPE);
    public static final String CONTENT_PREFIX = "org.eclipse.jpt.jaxb.core.content";
    public static final String CONTENT_PREFIX_ = "org.eclipse.jpt.jaxb.core.content.";
    private volatile GenericJaxbProjectManager projectManager;
    private static JptJaxbCorePlugin INSTANCE;

    private static IContentType getJaxbContentType(String contentType) {
        return JptJaxbCorePlugin.getContentType(CONTENT_PREFIX_ + contentType);
    }

    private static IContentType getContentType(String contentType) {
        return Platform.getContentTypeManager().getContentType(contentType);
    }

    public static JptJaxbCorePlugin instance() {
        return INSTANCE;
    }

    public static JaxbProjectManager getProjectManager() {
        return INSTANCE.getProjectManager_();
    }

    public static JaxbProject getJaxbProject(IProject project) {
        return JptJaxbCorePlugin.getProjectManager().getJaxbProject(project);
    }

    public static JaxbPlatformManager getJaxbPlatformManager() {
        return JaxbPlatformManagerImpl.instance();
    }

    public static void setDefaultJaxbPlatform(IProjectFacetVersion jaxbFacetVersion, JaxbPlatformDescription platform) {
        String preferenceKey = null;
        if (JaxbFacet.VERSION_2_1.equals(jaxbFacetVersion)) {
            preferenceKey = JaxbPreferencesManager.DEFAULT_JAXB_PLATFORM_2_1_PREF_KEY;
        } else if (JaxbFacet.VERSION_2_2.equals(jaxbFacetVersion)) {
            preferenceKey = JaxbPreferencesManager.DEFAULT_JAXB_PLATFORM_2_2_PREF_KEY;
        } else {
            throw new IllegalArgumentException("Illegal JAXB facet version: " + jaxbFacetVersion);
        }
        JaxbPreferencesManager.setWorkspacePreference(preferenceKey, platform.getId());
    }

    public static JaxbPlatformDescription getDefaultPlatform(IProjectFacetVersion jaxbFacetVersion) {
        JaxbPlatformDescription defaultPlatform = JptJaxbCorePlugin.getDefaultPlatform(jaxbFacetVersion, new Preferences[]{JaxbPreferencesManager.getWorkspacePreferences(), JaxbPreferencesManager.getDefaultPreferences()});
        if (defaultPlatform == null) {
            defaultPlatform = JptJaxbCorePlugin.getDefaultPlatform(jaxbFacetVersion, new Preferences[]{JaxbPreferencesManager.getDefaultPreferences()});
        }
        return defaultPlatform;
    }

    private static JaxbPlatformDescription getDefaultPlatform(IProjectFacetVersion jaxbFacetVersion, Preferences ... nodes) {
        String preferenceKey;
        JaxbPlatformDescription defaultDefaultPlatform;
        if (jaxbFacetVersion.equals(JaxbFacet.VERSION_2_1)) {
            defaultDefaultPlatform = GenericJaxbPlatform.VERSION_2_1;
            preferenceKey = JaxbPreferencesManager.DEFAULT_JAXB_PLATFORM_2_1_PREF_KEY;
        } else if (jaxbFacetVersion.equals(JaxbFacet.VERSION_2_2)) {
            defaultDefaultPlatform = GenericJaxbPlatform.VERSION_2_2;
            preferenceKey = JaxbPreferencesManager.DEFAULT_JAXB_PLATFORM_2_2_PREF_KEY;
        } else {
            throw new IllegalArgumentException("Illegal JAXB facet version: " + jaxbFacetVersion);
        }
        return JptJaxbCorePlugin.getDefaultPlatform(jaxbFacetVersion, preferenceKey, defaultDefaultPlatform, nodes);
    }

    private static JaxbPlatformDescription getDefaultPlatform(IProjectFacetVersion jaxbFacetVersion, String preferenceKey, JaxbPlatformDescription defaultDefault, Preferences ... nodes) {
        String defaultDefaultId = defaultDefault == null ? null : defaultDefault.getId();
        String defaultPlatformId = Platform.getPreferencesService().get(preferenceKey, defaultDefaultId, nodes);
        JaxbPlatformDescription defaultPlatform = JptJaxbCorePlugin.getJaxbPlatformManager().getJaxbPlatform(defaultPlatformId);
        if (defaultPlatform != null && defaultPlatform.supportsJaxbFacetVersion(jaxbFacetVersion)) {
            return defaultPlatform;
        }
        if (defaultDefault != null && defaultDefault.supportsJaxbFacetVersion(jaxbFacetVersion)) {
            return defaultDefault;
        }
        return null;
    }

    public static String getJaxbPlatformId(IProject project) {
        return new JaxbPreferencesManager(project).getJaxbPlatformId();
    }

    public static JaxbPlatformDescription getJaxbPlatformDescription(IProject project) {
        String jpaPlatformId = JptJaxbCorePlugin.getJaxbPlatformId(project);
        return JptJaxbCorePlugin.getJaxbPlatformManager().getJaxbPlatform(jpaPlatformId);
    }

    public static void setJaxbPlatform(IProject project, JaxbPlatformDescription platform) {
        new JaxbPreferencesManager(project).setJaxbPlatform(platform);
    }

    public static List<String> getSchemaLocations(IProject project) {
        return new JaxbPreferencesManager(project).getSchemaLocations();
    }

    public static void setSchemaLocations(IProject project, List<String> schemaLocations) {
        new JaxbPreferencesManager(project).setSchemaLocations(schemaLocations);
    }

    public static void log(IStatus status) {
        INSTANCE.getLog().log(status);
    }

    public static void log(String msg) {
        JptJaxbCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, null));
    }

    public static void log(Throwable throwable) {
        JptJaxbCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, throwable.getLocalizedMessage(), throwable));
    }

    public JptJaxbCorePlugin() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.projectManager != null) {
                this.projectManager.stop();
                this.projectManager = null;
            }
        }
        finally {
            super.stop(context);
        }
    }

    private synchronized GenericJaxbProjectManager getProjectManager_() {
        if (this.projectManager == null) {
            this.projectManager = this.buildProjectManager();
            this.projectManager.start();
        }
        return this.projectManager;
    }

    private GenericJaxbProjectManager buildProjectManager() {
        return new GenericJaxbProjectManager();
    }
}

