/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbElementFactoryMethod;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.JaxbTypeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlElementRef;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.context.XmlRegistry;
import org.eclipse.jpt.jaxb.core.context.XmlRootElement;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaElementQName;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaQName;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.QNameAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlElementRef
extends AbstractJavaContextNode
implements XmlElementRef {
    protected final Context context;
    protected final JaxbQName qName;
    protected Boolean specifiedRequired;
    protected String specifiedType;
    protected String defaultType;

    public GenericJavaXmlElementRef(JavaContextNode parent, Context context) {
        super(parent);
        this.context = context;
        this.qName = this.buildQName();
        this.specifiedRequired = this.buildSpecifiedRequired();
        this.specifiedType = this.buildSpecifiedType();
        this.defaultType = this.buildDefaultType();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.qName.synchronizeWithResourceModel();
        this.setSpecifiedRequired_(this.buildSpecifiedRequired());
        this.setSpecifiedType_(this.buildSpecifiedType());
        this.setDefaultType_(this.buildDefaultType());
    }

    @Override
    public void update() {
        super.update();
        this.qName.update();
    }

    @Override
    public JavaContextNode getParent() {
        return (JavaContextNode)super.getParent();
    }

    protected Context getContext() {
        return this.context;
    }

    protected JaxbPersistentAttribute getPersistentAttribute() {
        return this.getContext().getAttributeMapping().getPersistentAttribute();
    }

    protected JaxbClassMapping getJaxbClassMapping() {
        return this.getPersistentAttribute().getClassMapping();
    }

    protected JaxbPackage getJaxbPackage() {
        return this.getJaxbClassMapping().getJaxbType().getJaxbPackage();
    }

    @Override
    public XmlElementRefAnnotation getAnnotation() {
        return this.context.getAnnotation();
    }

    @Override
    public JaxbQName getQName() {
        return this.qName;
    }

    protected JaxbQName buildQName() {
        return new XmlElementRefQName(this);
    }

    @Override
    public boolean isRequired() {
        return this.specifiedRequired == null ? this.isDefaultRequired() : this.specifiedRequired.booleanValue();
    }

    @Override
    public Boolean getSpecifiedRequired() {
        return this.specifiedRequired;
    }

    @Override
    public void setSpecifiedRequired(Boolean newSpecifiedRequired) {
        this.getAnnotation().setRequired(newSpecifiedRequired);
        this.setSpecifiedRequired_(newSpecifiedRequired);
    }

    protected void setSpecifiedRequired_(Boolean newSpecifiedRequired) {
        Boolean oldRequired = this.specifiedRequired;
        this.specifiedRequired = newSpecifiedRequired;
        this.firePropertyChanged("specifiedRequired", oldRequired, newSpecifiedRequired);
    }

    protected Boolean buildSpecifiedRequired() {
        return this.getAnnotation().getRequired();
    }

    @Override
    public boolean isDefaultRequired() {
        return false;
    }

    @Override
    public String getType() {
        return this.specifiedType == null ? this.getDefaultType() : this.specifiedType;
    }

    @Override
    public String getSpecifiedType() {
        return this.specifiedType;
    }

    @Override
    public void setSpecifiedType(String newSpecifiedType) {
        this.getAnnotation().setType(newSpecifiedType);
        this.setSpecifiedType_(newSpecifiedType);
    }

    protected void setSpecifiedType_(String newSpecifiedType) {
        String oldType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        this.firePropertyChanged("specifiedType", oldType, newSpecifiedType);
    }

    protected String buildSpecifiedType() {
        return this.getAnnotation().getType();
    }

    @Override
    public String getDefaultType() {
        return this.defaultType;
    }

    protected void setDefaultType_(String newType) {
        String oldType = this.defaultType;
        this.defaultType = newType;
        this.firePropertyChanged("defaultType", oldType, newType);
    }

    protected String buildDefaultType() {
        return this.context.getDefaultType();
    }

    @Override
    public String getFullyQualifiedType() {
        return this.specifiedType == null ? this.getDefaultType() : this.getAnnotation().getFullyQualifiedTypeName();
    }

    @Override
    public Iterable<String> getReferencedXmlTypeNames() {
        if (this.specifiedType != null && !this.isTypeJAXBElement()) {
            return new SingleElementIterable((Object)this.getFullyQualifiedType());
        }
        return EmptyIterable.instance();
    }

    protected boolean isTypeJAXBElement() {
        return StringTools.stringsAreEqual((String)"javax.xml.bind.JAXBElement", (String)this.getFullyQualifiedType());
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        result = this.qName.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getAnnotation().getTextRange(astRoot);
    }

    @Override
    public TextRange getTypeTextRange(CompilationUnit astRoot) {
        return this.getAnnotation().getTypeTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.qName.validate(messages, reporter, astRoot);
        this.validateType(messages, reporter, astRoot);
    }

    protected void validateType(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        String fqType = this.getFullyQualifiedType();
        if (StringTools.stringIsEmpty((String)fqType)) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENT_REF__UNSPECIFIED_TYPE", this, this.getTypeTextRange(astRoot)));
        } else if (!StringTools.stringIsEmpty((String)this.specifiedType) && JDTTools.findType((IJavaProject)this.getJaxbProject().getJavaProject(), (String)fqType) != null) {
            JaxbTypeMapping typeMapping;
            String attributeValueType = this.getContext().getAttributeMapping().getValueTypeName();
            if (!JDTTools.typeIsSubType((IJavaProject)this.getJaxbProject().getJavaProject(), (String)fqType, (String)attributeValueType)) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENT_REF__ILLEGAL_TYPE", new String[]{attributeValueType}, this, this.getTypeTextRange(astRoot)));
            }
            if ((typeMapping = this.getJaxbProject().getContextRoot().getTypeMapping(fqType)) != null && !typeMapping.hasRootElementInHierarchy()) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENT_REF__NO_ROOT_ELEMENT", new String[]{attributeValueType}, this, this.getTypeTextRange(astRoot)));
            }
        }
    }

    public static interface Context {
        public JaxbAttributeMapping getAttributeMapping();

        public XmlElementRefAnnotation getAnnotation();

        public String getDefaultType();

        public XmlElementWrapper getElementWrapper();
    }

    protected class QNameAnnotationProxy
    extends AbstractJavaQName.AbstractQNameAnnotationProxy {
        protected QNameAnnotationProxy() {
        }

        protected QNameAnnotation getAnnotation(boolean createIfNull) {
            return GenericJavaXmlElementRef.this.getAnnotation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlElementRefQName
    extends AbstractJavaElementQName {
        protected XmlElementRefQName(JavaContextNode parent) {
            super(parent, new QNameAnnotationProxy());
        }

        @Override
        protected JaxbPersistentAttribute getPersistentAttribute() {
            return GenericJavaXmlElementRef.this.getPersistentAttribute();
        }

        protected boolean isTypeJAXBElement() {
            return GenericJavaXmlElementRef.this.isTypeJAXBElement();
        }

        protected JaxbTypeMapping getReferencedTypeMapping() {
            String fqTypeName = GenericJavaXmlElementRef.this.getFullyQualifiedType();
            return this.getJaxbProject().getContextRoot().getTypeMapping(fqTypeName);
        }

        @Override
        protected XmlElementWrapper getElementWrapper() {
            return GenericJavaXmlElementRef.this.context.getElementWrapper();
        }

        @Override
        public String getDefaultName() {
            XmlRootElement rootElement;
            if (this.isTypeJAXBElement()) {
                return super.getDefaultName();
            }
            JaxbTypeMapping referencedTypeMapping = this.getReferencedTypeMapping();
            if (referencedTypeMapping != null && (rootElement = referencedTypeMapping.getXmlRootElement()) != null) {
                return rootElement.getQName().getName();
            }
            return "";
        }

        @Override
        public String getDefaultNamespace() {
            XmlRootElement rootElement;
            JaxbTypeMapping referencedTypeMapping = this.getReferencedTypeMapping();
            if (referencedTypeMapping != null && (rootElement = referencedTypeMapping.getXmlRootElement()) != null) {
                return rootElement.getQName().getNamespace();
            }
            return super.getDefaultNamespace();
        }

        @Override
        protected void validateName(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
            if (this.isTypeJAXBElement()) {
                super.validateName(messages, reporter, astRoot);
            }
        }

        @Override
        protected void validateReference(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
            super.validateReference(messages, reporter, astRoot);
            if (!this.isTypeJAXBElement()) {
                return;
            }
            XmlRegistry registry = this.getJaxbPackage().getRegistry();
            if (registry == null) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENT_REF__NO_REGISTRY", this, this.getValidationTextRange(astRoot)));
                return;
            }
            for (JaxbElementFactoryMethod elementDecl : registry.getElementFactoryMethods()) {
                if (!Tools.valuesAreEqual((Object)this.getName(), (Object)elementDecl.getQName().getName()) || !Tools.valuesAreEqual((Object)this.getNamespace(), (Object)elementDecl.getQName().getNamespace())) continue;
                return;
            }
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENT_REF__NO_MATCHING_ELEMENT_DECL", new String[]{this.getNamespace(), this.getName()}, this, this.getValidationTextRange(astRoot)));
        }
    }
}

