/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlValueMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaXmlNodeMapping;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.XmlValueAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlValueMapping
extends AbstractJavaXmlNodeMapping<XmlValueAnnotation>
implements XmlValueMapping {
    public GenericJavaXmlValueMapping(JaxbPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public String getKey() {
        return "xml-value";
    }

    @Override
    protected String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlValue";
    }

    @Override
    protected boolean calculateDefaultXmlList() {
        return this.getPersistentAttribute().isJavaResourceAttributeCollectionType();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateSchemaType(messages, reporter, astRoot);
    }

    protected void validateSchemaType(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        XsdTypeDefinition xsdClassType = this.getClassMapping().getXsdTypeDefinition();
        if (xsdClassType == null) {
            return;
        }
        if (!xsdClassType.hasTextContent()) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_VALUE__NO_TEXT_CONTENT", this, this.getValidationTextRange(astRoot)));
            return;
        }
        XsdTypeDefinition xsdType = xsdClassType.getBaseType();
        XsdTypeDefinition expectedSchemaType = this.getDataTypeXsdTypeDefinition();
        if (xsdType == null || expectedSchemaType == null) {
            return;
        }
        if (!xsdType.typeIsValid(expectedSchemaType, this.isXmlList())) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_VALUE__INVALID_SCHEMA_TYPE", new String[]{this.getValueTypeName()}, this, this.getValidationTextRange(astRoot)));
        }
    }
}

