/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceXmlJavaTypeAdapterAnnotation
extends SourceAnnotation
implements XmlJavaTypeAdapterAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
    public static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters");
    private final DeclarationAnnotationElementAdapter<String> valueDeclarationAdapter;
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;
    private String fullyQualifiedValue;
    private boolean suppressFQValueEventNotification = false;
    private final DeclarationAnnotationElementAdapter<String> typeDeclarationAdapter;
    private final AnnotationElementAdapter<String> typeAdapter;
    private String type;
    private String fullyQualifiedType;
    private boolean suppressFQTypeEventNotification = false;

    public static SourceXmlJavaTypeAdapterAnnotation buildSourceXmlJavaTypeAdapterAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, int index) {
        IndexedDeclarationAnnotationAdapter idaa = SourceXmlJavaTypeAdapterAnnotation.buildXmlJavaTypeAdapterDeclarationAnnotationAdapter(index);
        IndexedAnnotationAdapter iaa = SourceXmlJavaTypeAdapterAnnotation.buildXmlJavaTypeAdapterAnnotationAdapter(annotatedElement, idaa);
        return new SourceXmlJavaTypeAdapterAnnotation(parent, annotatedElement, idaa, iaa);
    }

    private SourceXmlJavaTypeAdapterAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter daa, IndexedAnnotationAdapter annotationAdapter) {
        super((JavaResourceNode)parent, annotatedElement, (DeclarationAnnotationAdapter)daa, (AnnotationAdapter)annotationAdapter);
        this.valueDeclarationAdapter = this.buildValueAdapter((DeclarationAnnotationAdapter)daa);
        this.valueAdapter = this.buildAnnotationElementAdapter(this.valueDeclarationAdapter);
        this.typeDeclarationAdapter = this.buildTypeAdapter((DeclarationAnnotationAdapter)daa);
        this.typeAdapter = this.buildAnnotationElementAdapter(this.typeDeclarationAdapter);
    }

    private DeclarationAnnotationElementAdapter<String> buildValueAdapter(DeclarationAnnotationAdapter daa) {
        return SourceXmlJavaTypeAdapterAnnotation.buildAnnotationElementAdapter(daa, "value", (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    private DeclarationAnnotationElementAdapter<String> buildTypeAdapter(DeclarationAnnotationAdapter daa) {
        return SourceXmlJavaTypeAdapterAnnotation.buildAnnotationElementAdapter(daa, "type", (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    protected AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getAnnotationName() {
        return "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter";
    }

    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
        this.fullyQualifiedValue = this.buildFullyQualifiedValue(astRoot);
        this.type = this.buildType(astRoot);
        this.fullyQualifiedType = this.buildFullyQualifiedType(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncValue(this.buildValue(astRoot));
        this.syncType(this.buildType(astRoot));
        this.syncFullyQualifiedValue(this.buildFullyQualifiedValue(astRoot));
        this.syncFullyQualifiedType(this.buildFullyQualifiedType(astRoot));
        this.suppressFQValueEventNotification = false;
        this.suppressFQTypeEventNotification = false;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasChanged(this.value, value)) {
            this.value = value;
            this.suppressFQValueEventNotification = true;
            this.valueAdapter.setValue((Object)value);
        }
    }

    private void syncValue(String astValue) {
        String old = this.value;
        this.value = astValue;
        this.suppressFQValueEventNotification |= StringTools.stringsAreEqual((String)old, (String)astValue);
        this.firePropertyChanged("value", old, astValue);
    }

    private String buildValue(CompilationUnit astRoot) {
        return (String)this.valueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.valueDeclarationAdapter, astRoot);
    }

    @Override
    public String getFullyQualifiedValue() {
        return this.fullyQualifiedValue;
    }

    private void syncFullyQualifiedValue(String name) {
        String old = this.fullyQualifiedValue;
        this.fullyQualifiedValue = name;
        if (!this.suppressFQValueEventNotification) {
            this.firePropertyChanged("fullyQualifiedValue", old, name);
        }
    }

    private String buildFullyQualifiedValue(CompilationUnit astRoot) {
        return this.value == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.valueAdapter.getExpression(astRoot));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (this.attributeValueHasChanged(this.type, type)) {
            this.type = type;
            this.suppressFQTypeEventNotification = true;
            this.typeAdapter.setValue((Object)type);
        }
    }

    private void syncType(String astType) {
        String old = this.type;
        this.type = astType;
        this.suppressFQTypeEventNotification |= StringTools.stringsAreEqual((String)old, (String)astType);
        this.firePropertyChanged("type", old, astType);
    }

    private String buildType(CompilationUnit astRoot) {
        return (String)this.typeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.typeDeclarationAdapter, astRoot);
    }

    @Override
    public String getFullyQualifiedType() {
        return this.fullyQualifiedType;
    }

    private void syncFullyQualifiedType(String name) {
        String old = this.fullyQualifiedType;
        this.fullyQualifiedType = name;
        if (!this.suppressFQTypeEventNotification) {
            this.firePropertyChanged("fullyQualifiedType", old, name);
        }
    }

    private String buildFullyQualifiedType(CompilationUnit astRoot) {
        return this.type == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.typeAdapter.getExpression(astRoot));
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    private static IndexedAnnotationAdapter buildXmlJavaTypeAdapterAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    private static IndexedDeclarationAnnotationAdapter buildXmlJavaTypeAdapterDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        return idaa;
    }
}

