/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.internal.context.AbstractJaxbContextRoot;
import org.eclipse.jpt.jaxb.core.resource.jaxbprops.JaxbPropertiesResource;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.validation.ELJaxbValidationMessageBuilder;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELJaxbContextRoot
extends AbstractJaxbContextRoot {
    public ELJaxbContextRoot(JaxbProject jaxbProject) {
        super(jaxbProject);
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateJaxbProperties(messages, reporter);
    }

    protected void validateJaxbProperties(List<IMessage> messages, IReporter reporter) {
        String factoryProp = "javax.xml.bind.context.factory";
        String factoryPropValue = "org.eclipse.persistence.jaxb.JAXBContextFactory";
        for (JaxbPackage jp : this.getPackages()) {
            String pn = jp.getName();
            JaxbPropertiesResource jpr = this.getJaxbProject().getJaxbPropertiesResource(pn);
            if (jpr == null || !StringTools.stringsAreEqual((String)jpr.getProperty(factoryProp), (String)factoryPropValue)) continue;
            return;
        }
        messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "PROJECT_MISSING_ECLIPSELINK_JAXB_CONTEXT_FACTORY", (JaxbNode)this.getJaxbProject()));
    }
}

