/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.java.ELXmlInverseReferenceMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.validation.ELJaxbValidationMessageBuilder;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlInverseReferenceAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELJavaXmlInverseReferenceMapping
extends AbstractJavaAttributeMapping<XmlInverseReferenceAnnotation>
implements ELXmlInverseReferenceMapping {
    protected String mappedBy = this.getResourceMappedBy();
    protected static final String[] VALID_REFERENCED_ATTRIBUTE_MAPPING_KEYS = new String[]{"xml-element", "xml-elements", "xml-attribute", "xml-value"};

    public ELJavaXmlInverseReferenceMapping(JaxbPersistentAttribute parent) {
        super(parent);
    }

    public String getKey() {
        return "xml-inverse-reference";
    }

    protected String getAnnotationName() {
        return "org.eclipse.persistence.oxm.annotations.XmlInverseReference";
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setMappedBy_(this.getResourceMappedBy());
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String mappedBy) {
        this.getXmlInverseReferenceAnnotation().setMappedBy(mappedBy);
        this.setMappedBy_(mappedBy);
    }

    protected void setMappedBy_(String mappedBy) {
        String old = this.mappedBy;
        this.mappedBy = mappedBy;
        this.firePropertyChanged("mappedBy", old, mappedBy);
    }

    public XmlInverseReferenceAnnotation getXmlInverseReferenceAnnotation() {
        return (XmlInverseReferenceAnnotation)this.getJavaResourceAttribute().getAnnotation("org.eclipse.persistence.oxm.annotations.XmlInverseReference");
    }

    public String getResourceMappedBy() {
        return this.getXmlInverseReferenceAnnotation().getMappedBy();
    }

    protected JaxbClassMapping getReferencedClassMapping() {
        String referencedClassName = this.getValueTypeName();
        return referencedClassName == null ? null : this.getContextRoot().getClassMapping(referencedClassName);
    }

    protected JaxbPersistentAttribute getReferencedAttribute() {
        String mappedBy = this.getMappedBy();
        if (StringTools.stringIsEmpty((String)mappedBy)) {
            return null;
        }
        JaxbClassMapping referencedClassMapping = this.getReferencedClassMapping();
        if (referencedClassMapping == null) {
            return null;
        }
        JaxbPersistentAttribute tempResult = null;
        for (JaxbPersistentAttribute attribute : referencedClassMapping.getAllLocallyDefinedAttributes()) {
            if (!attribute.getName().equals(mappedBy)) continue;
            if (attribute.getMappingKey() == "xml-transient") {
                tempResult = attribute;
                continue;
            }
            return attribute;
        }
        return tempResult;
    }

    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty((Iterable)result)) {
            return result;
        }
        if (this.getXmlInverseReferenceAnnotation().mappedByTouches(pos, astRoot)) {
            result = this.getMappedByProposals(filter, astRoot);
        }
        if (!CollectionTools.isEmpty((Iterable)result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    protected Iterable<String> getMappedByProposals(Filter<String> filter, CompilationUnit astRoot) {
        JaxbClassMapping referencedClassMapping = this.getReferencedClassMapping();
        if (referencedClassMapping == null) {
            return EmptyIterable.instance();
        }
        return StringTools.convertToJavaStringLiterals((Iterable)new TransformationIterable<JaxbPersistentAttribute, String>(referencedClassMapping.getAllLocallyDefinedAttributes()){

            protected String transform(JaxbPersistentAttribute o) {
                return o.getName();
            }
        });
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateMappedBy(messages, reporter, astRoot);
    }

    protected void validateMappedBy(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (StringTools.stringIsEmpty((String)this.mappedBy)) {
            messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XML_INVERSE_REFERENCE__MAPPED_BY_NOT_SPECIFIED", (JaxbNode)this, this.getMappedByTextRange(astRoot)));
            return;
        }
        JaxbClassMapping referencedClassMapping = this.getReferencedClassMapping();
        if (referencedClassMapping == null) {
            return;
        }
        JaxbPersistentAttribute referencedAttribute = this.getReferencedAttribute();
        if (referencedAttribute == null) {
            messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XML_INVERSE_REFERENCE__MAPPED_BY_NOT_RESOLVED", new String[]{this.mappedBy, referencedClassMapping.getJaxbType().getFullyQualifiedName()}, (JaxbNode)this, this.getMappedByTextRange(astRoot)));
        } else if (!ArrayTools.contains((Object[])this.getValidReferencedAttributeMappingKeys(), (Object)referencedAttribute.getMappingKey())) {
            messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XML_INVERSE_REFERENCE__MAPPED_BY_ILLEGAL_MAPPING_TYPE", new String[]{this.mappedBy, referencedClassMapping.getJaxbType().getFullyQualifiedName()}, (JaxbNode)this, this.getMappedByTextRange(astRoot)));
        }
    }

    protected String[] getValidReferencedAttributeMappingKeys() {
        return VALID_REFERENCED_ATTRIBUTE_MAPPING_KEYS;
    }

    protected TextRange getMappedByTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getXmlInverseReferenceAnnotation().getMappedByTextRange(astRoot);
        return textRange != null ? textRange : this.getValidationTextRange(astRoot);
    }
}

