/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.context.java.ELXmlPath;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.xpath.java.XPath;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.xpath.java.XPathFactory;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.validation.ELJaxbValidationMessageBuilder;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlPathAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELJavaXmlPath
extends AbstractJavaContextNode
implements ELXmlPath {
    protected String value;
    protected Context context;

    public ELJavaXmlPath(JavaContextNode parent, Context context) {
        super((JaxbNode)parent);
        this.context = context;
        this.initValue();
    }

    protected JaxbPackage getJaxbPackage() {
        return this.getClassMapping().getJaxbType().getJaxbPackage();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncValue();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.getAnnotation().setValue(value);
        this.setValue_(value);
    }

    protected void setValue_(String value) {
        String old = this.value;
        this.value = value;
        this.firePropertyChanged("value", old, this.value);
    }

    protected void initValue() {
        this.value = this.getAnnotation().getValue();
    }

    protected void syncValue() {
        this.setValue_(this.getAnnotation().getValue());
    }

    protected XmlPathAnnotation getAnnotation() {
        return this.context.getAnnotation();
    }

    protected JaxbAttributeMapping getAttributeMapping() {
        return this.context.getAttributeMapping();
    }

    protected JaxbClassMapping getClassMapping() {
        return this.getAttributeMapping().getClassMapping();
    }

    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        if (this.getAnnotation().valueTouches(pos, astRoot) && this.value != null) {
            XsdTypeDefinition xsdType = this.getClassMapping().getXsdTypeDefinition();
            XPath xpath = XPathFactory.instance().getXpath(this.value);
            return xpath.getCompletionProposals(new XPathContext(astRoot), xsdType, pos, filter);
        }
        return EmptyIterable.instance();
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getAnnotation().getTextRange(astRoot);
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (StringTools.stringIsEmpty((String)this.value)) {
            messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XML_PATH__NOT_SPECIFIED", (JaxbNode)this, this.getValueTextRange(astRoot)));
            return;
        }
        if (this.value.startsWith(XPath.DELIM)) {
            messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XPATH__ROOT_NOT_SUPPORTED", (JaxbNode)this, this.getValueTextRange(astRoot)));
            return;
        }
        XsdTypeDefinition xsdType = this.getClassMapping().getXsdTypeDefinition();
        XPath xpath = XPathFactory.instance().getXpath(this.value);
        xpath.validate(new XPathContext(astRoot), xsdType, messages);
    }

    protected TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getAnnotation().getValueTextRange(astRoot);
    }

    public static interface Context {
        public XmlPathAnnotation getAnnotation();

        public JaxbAttributeMapping getAttributeMapping();
    }

    protected class XPathContext
    implements XPath.Context {
        private CompilationUnit astRoot;

        protected XPathContext(CompilationUnit astRoot) {
            this.astRoot = astRoot;
        }

        public JaxbNode getContextObject() {
            return ELJavaXmlPath.this;
        }

        public JaxbPackage getJaxbPackage() {
            return ELJavaXmlPath.this.getJaxbPackage();
        }

        public TextRange getTextRange() {
            return ELJavaXmlPath.this.getValueTextRange(this.astRoot);
        }
    }
}

