/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.JptResourceModelListener;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryTypeCache;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceTypeCompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.command.NotifyingRepeatingJobCommandWrapper;
import org.eclipse.jpt.common.core.internal.utility.command.RepeatingJobCommandWrapper;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackageInfoCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceTypeCache;
import org.eclipse.jpt.common.core.utility.command.JobCommand;
import org.eclipse.jpt.common.core.utility.command.JobCommandExecutor;
import org.eclipse.jpt.common.core.utility.command.NotifyingRepeatingJobCommand;
import org.eclipse.jpt.common.core.utility.command.RepeatingJobCommand;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.command.CommandExecutor;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SnapshotCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaDataSource;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.JpaRootContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.GenericJpaPlatform;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.JpaProject2_0;
import org.eclipse.jpt.jpa.core.jpa2.MetamodelSynchronizer;
import org.eclipse.jpt.jpa.core.jpa2.context.JpaRootContextNode2_0;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaProject
extends AbstractJpaNode
implements JpaProject2_0 {
    protected final JpaProject.Manager manager;
    protected final IProject project;
    protected final JpaPlatform jpaPlatform;
    protected final Hashtable<IFile, JpaFile> jpaFiles = new Hashtable();
    protected final Vector<JavaResourceCompilationUnit> externalJavaResourceCompilationUnits = new Vector();
    protected final JavaResourceTypeCache externalJavaResourceTypeCache;
    protected final JptResourceModelListener resourceModelListener;
    protected final JpaRootContextNode rootContextNode;
    protected volatile RepeatingJobCommand synchronizeContextModelCommand;
    protected volatile boolean synchronizingContextModel = false;
    protected volatile NotifyingRepeatingJobCommand updateCommand;
    protected final NotifyingRepeatingJobCommand.Listener updateCommandListener;
    protected final JpaDataSource dataSource;
    protected volatile String userOverrideDefaultCatalog;
    protected volatile String userOverrideDefaultSchema;
    protected volatile boolean discoversAnnotatedClasses;
    protected volatile String metamodelSourceFolderName;
    protected static final Filter<IPackageFragmentRoot> SOURCE_PACKAGE_FRAGMENT_ROOT_FILTER = new Filter<IPackageFragmentRoot>(){

        public boolean accept(IPackageFragmentRoot pfr) {
            try {
                return this.accept_(pfr);
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }

        private boolean accept_(IPackageFragmentRoot pfr) throws JavaModelException {
            return pfr.exists() && pfr.getKind() == 1;
        }
    };

    protected AbstractJpaProject(JpaProject.Config config) {
        super(null);
        if (config.getJpaProjectManager() == null || config.getProject() == null || config.getJpaPlatform() == null) {
            throw new NullPointerException();
        }
        this.manager = config.getJpaProjectManager();
        this.project = config.getProject();
        this.synchronizeContextModelCommand = this.buildSynchronizeContextModelCommand();
        this.updateCommand = this.buildTempUpdateCommand();
        this.jpaPlatform = config.getJpaPlatform();
        this.dataSource = this.getJpaFactory().buildJpaDataSource(this, config.getConnectionProfileName());
        this.userOverrideDefaultCatalog = config.getUserOverrideDefaultCatalog();
        this.userOverrideDefaultSchema = config.getUserOverrideDefaultSchema();
        this.discoversAnnotatedClasses = config.discoverAnnotatedClasses();
        this.resourceModelListener = this.buildResourceModelListener();
        InitialResourceProxyVisitor visitor = this.buildInitialResourceProxyVisitor();
        visitor.visitProject(this.project);
        this.externalJavaResourceTypeCache = this.buildExternalJavaResourceTypeCache();
        if (this.isJpa2_0Compatible()) {
            this.metamodelSourceFolderName = ((JpaProject2_0.Config)config).getMetamodelSourceFolderName();
            if (this.metamodelSoureFolderNameIsInvalid()) {
                this.metamodelSourceFolderName = null;
            }
        }
        this.rootContextNode = this.buildRootContextNode();
        this.updateCommandListener = this.buildUpdateCommandListener();
        this.initializeContextModel();
        this.externalJavaResourceTypeCache.addResourceModelListener(this.resourceModelListener);
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public IResource getResource() {
        return this.project;
    }

    protected JavaResourceTypeCache buildExternalJavaResourceTypeCache() {
        return new BinaryTypeCache(this.jpaPlatform.getAnnotationProvider());
    }

    protected JpaRootContextNode buildRootContextNode() {
        return this.getJpaFactory().buildRootContextNode(this);
    }

    protected void initializeContextModel() {
        this.synchronizeContextModelCommand.start();
        this.updateCommand.start();
        this.update();
        try {
            this.updateCommand.stop();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.updateCommand = this.buildUpdateCommand();
        this.updateCommand.addListener(this.updateCommandListener);
        this.updateCommand.start();
    }

    protected InitialResourceProxyVisitor buildInitialResourceProxyVisitor() {
        return new InitialResourceProxyVisitor();
    }

    @Override
    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add("externalJavaResourceCompilationUnits");
    }

    @Override
    public JpaProject getJpaProject() {
        return this;
    }

    @Override
    public JpaProject.Manager getManager() {
        return this.manager;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.project);
    }

    @Override
    public JpaPlatform getJpaPlatform() {
        return this.jpaPlatform;
    }

    protected Iterable<JavaResourceCompilationUnit> getCombinedJavaResourceCompilationUnits() {
        return new CompositeIterable(new Iterable[]{this.getInternalJavaResourceCompilationUnits(), this.getExternalJavaResourceCompilationUnits()});
    }

    @Override
    public JpaDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public ConnectionProfile getConnectionProfile() {
        return this.dataSource.getConnectionProfile();
    }

    @Override
    public Catalog getDefaultDbCatalog() {
        String catalog = this.getDefaultCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    @Override
    public String getDefaultCatalog() {
        String catalog = this.getUserOverrideDefaultCatalog();
        return catalog != null ? catalog : this.getDatabaseDefaultCatalog();
    }

    protected String getDatabaseDefaultCatalog() {
        Database db = this.getDatabase();
        return db == null ? null : db.getDefaultCatalogIdentifier();
    }

    @Override
    public SchemaContainer getDefaultDbSchemaContainer() {
        String catalog = this.getDefaultCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Schema getDefaultDbSchema() {
        SchemaContainer sc = this.getDefaultDbSchemaContainer();
        return sc == null ? null : sc.getSchemaForIdentifier(this.getDefaultSchema());
    }

    @Override
    public String getDefaultSchema() {
        String schema = this.getUserOverrideDefaultSchema();
        if (schema != null) {
            return schema;
        }
        String catalog = this.getDefaultCatalog();
        if (catalog == null) {
            return this.getDatabaseDefaultSchema();
        }
        Catalog dbCatalog = this.resolveDbCatalog(catalog);
        if (dbCatalog != null) {
            return dbCatalog.getDefaultSchemaIdentifier();
        }
        return this.getDatabaseDefaultSchema();
    }

    protected String getDatabaseDefaultSchema() {
        Database db = this.getDatabase();
        return db == null ? null : db.getDefaultSchemaIdentifier();
    }

    @Override
    public String getUserOverrideDefaultCatalog() {
        return this.userOverrideDefaultCatalog;
    }

    @Override
    public void setUserOverrideDefaultCatalog(String catalog) {
        String old = this.userOverrideDefaultCatalog;
        this.userOverrideDefaultCatalog = catalog;
        JptJpaCorePlugin.setUserOverrideDefaultCatalog(this.project, catalog);
        this.firePropertyChanged("userOverrideDefaultCatalog", old, catalog);
    }

    @Override
    public String getUserOverrideDefaultSchema() {
        return this.userOverrideDefaultSchema;
    }

    @Override
    public void setUserOverrideDefaultSchema(String schema) {
        String old = this.userOverrideDefaultSchema;
        this.userOverrideDefaultSchema = schema;
        JptJpaCorePlugin.setUserOverrideDefaultSchema(this.project, schema);
        this.firePropertyChanged("userOverrideDefaultSchema", old, schema);
    }

    @Override
    public boolean discoversAnnotatedClasses() {
        return this.discoversAnnotatedClasses;
    }

    @Override
    public void setDiscoversAnnotatedClasses(boolean discoversAnnotatedClasses) {
        boolean old = this.discoversAnnotatedClasses;
        this.discoversAnnotatedClasses = discoversAnnotatedClasses;
        JptJpaCorePlugin.setDiscoverAnnotatedClasses(this.project, discoversAnnotatedClasses);
        this.firePropertyChanged("discoversAnnotatedClasses", old, discoversAnnotatedClasses);
    }

    @Override
    public Iterable<JpaFile> getJpaFiles() {
        return new LiveCloneIterable(this.jpaFiles.values());
    }

    @Override
    public int getJpaFilesSize() {
        return this.jpaFiles.size();
    }

    protected Iterable<JpaFile> getJpaFiles(final IContentType contentType) {
        return new FilteringIterable<JpaFile>(this.getJpaFiles()){

            protected boolean accept(JpaFile jpaFile) {
                return jpaFile.getContentType().isKindOf(contentType);
            }
        };
    }

    @Override
    public JpaFile getJpaFile(IFile file) {
        return file == null ? null : this.jpaFiles.get(file);
    }

    protected boolean addJpaFileMaybe(IFile file) {
        JpaFile jpaFile = this.addJpaFileMaybe_(file);
        if (jpaFile != null) {
            this.fireItemAdded("jpaFiles", jpaFile);
            return true;
        }
        return false;
    }

    protected JpaFile addJpaFileMaybe_(IFile file) {
        if (this.fileIsJavaRelated(file) ? !this.getJavaProject().isOnClasspath((IResource)file) : !this.fileResourceLocationIsValid(file)) {
            return null;
        }
        JpaFile jpaFile = this.buildJpaFile(file);
        if (jpaFile == null) {
            return null;
        }
        jpaFile.getResourceModel().addResourceModelListener(this.resourceModelListener);
        this.jpaFiles.put(file, jpaFile);
        return jpaFile;
    }

    protected boolean fileIsJavaRelated(IFile file) {
        IContentType contentType = AbstractJpaProject.getContentType(file);
        return contentType != null && this.contentTypeIsJavaRelated(contentType);
    }

    protected boolean contentTypeIsJavaRelated(IContentType contentType) {
        return contentType.isKindOf(JptCommonCorePlugin.JAVA_SOURCE_CONTENT_TYPE) || contentType.isKindOf(JptCommonCorePlugin.JAR_CONTENT_TYPE);
    }

    protected boolean fileResourceLocationIsValid(IFile file) {
        return this.getProjectResourceLocator().resourceLocationIsValid(file.getParent());
    }

    protected ProjectResourceLocator getProjectResourceLocator() {
        return (ProjectResourceLocator)this.project.getAdapter(ProjectResourceLocator.class);
    }

    protected JpaFile buildJpaFile(IFile file) {
        try {
            return this.getJpaPlatform().buildJpaFile(this, file);
        }
        catch (Exception ex) {
            JptJpaCorePlugin.log("Error building JPA file: " + file.getFullPath(), ex);
            return null;
        }
    }

    protected boolean removeJpaFile(IFile file) {
        JpaFile jpaFile = this.getJpaFile(file);
        if (jpaFile != null) {
            this.removeJpaFile(jpaFile);
            return true;
        }
        return false;
    }

    protected void removeJpaFile(JpaFile jpaFile) {
        jpaFile.getResourceModel().removeResourceModelListener(this.resourceModelListener);
        if (this.jpaFiles.remove(jpaFile.getFile()) == null) {
            throw new IllegalArgumentException(jpaFile.toString());
        }
        this.fireItemRemoved("jpaFiles", jpaFile);
    }

    protected JavaResourceAbstractType buildExternalJavaResourceType(String typeName) {
        IType jdtType = this.findType(typeName);
        return jdtType == null ? null : this.buildExternalJavaResourceType(jdtType);
    }

    protected IType findType(String typeName) {
        try {
            return typeName.startsWith(".") ? null : this.getJavaProject().findType(typeName);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    protected JavaResourceAbstractType buildExternalJavaResourceType(IType jdtType) {
        return jdtType.isBinary() ? this.buildBinaryExternalJavaResourceType(jdtType) : this.buildSourceExternalJavaResourceType(jdtType);
    }

    protected JavaResourceAbstractType buildBinaryExternalJavaResourceType(IType jdtType) {
        return this.externalJavaResourceTypeCache.addType(jdtType);
    }

    protected JavaResourceAbstractType buildSourceExternalJavaResourceType(IType jdtType) {
        JavaResourceCompilationUnit jrcu = this.getExternalJavaResourceCompilationUnit(jdtType.getCompilationUnit());
        String jdtTypeName = jdtType.getFullyQualifiedName('.');
        for (JavaResourceAbstractType jrat : jrcu.getTypes()) {
            if (!jrat.getQualifiedName().equals(jdtTypeName)) continue;
            return jrat;
        }
        return null;
    }

    @Override
    public JavaResourceTypeCache getExternalJavaResourceTypeCache() {
        return this.externalJavaResourceTypeCache;
    }

    @Override
    public Iterable<JavaResourceCompilationUnit> getExternalJavaResourceCompilationUnits() {
        return new LiveCloneIterable(this.externalJavaResourceCompilationUnits);
    }

    @Override
    public int getExternalJavaResourceCompilationUnitsSize() {
        return this.externalJavaResourceCompilationUnits.size();
    }

    protected JavaResourceCompilationUnit getExternalJavaResourceCompilationUnit(ICompilationUnit jdtCompilationUnit) {
        for (JavaResourceCompilationUnit jrcu : this.getExternalJavaResourceCompilationUnits()) {
            if (!jrcu.getCompilationUnit().equals(jdtCompilationUnit)) continue;
            return jrcu;
        }
        return this.addExternalJavaResourceCompilationUnit(jdtCompilationUnit);
    }

    protected JavaResourceCompilationUnit addExternalJavaResourceCompilationUnit(ICompilationUnit jdtCompilationUnit) {
        JavaResourceCompilationUnit jrcu = this.buildJavaResourceCompilationUnit(jdtCompilationUnit);
        this.addItemToCollection(jrcu, this.externalJavaResourceCompilationUnits, "externalJavaResourceCompilationUnits");
        jrcu.addResourceModelListener(this.resourceModelListener);
        return jrcu;
    }

    protected JavaResourceCompilationUnit buildJavaResourceCompilationUnit(ICompilationUnit jdtCompilationUnit) {
        return new SourceTypeCompilationUnit(jdtCompilationUnit, this.jpaPlatform.getAnnotationProvider(), this.jpaPlatform.getAnnotationEditFormatter(), (CommandExecutor)this.manager.getModifySharedDocumentCommandExecutor());
    }

    protected boolean removeExternalJavaResourceCompilationUnit(IFile file) {
        for (JavaResourceCompilationUnit jrcu : this.getExternalJavaResourceCompilationUnits()) {
            if (!jrcu.getFile().equals((Object)file)) continue;
            this.removeExternalJavaResourceCompilationUnit(jrcu);
            return true;
        }
        return false;
    }

    protected void removeExternalJavaResourceCompilationUnit(JavaResourceCompilationUnit jrcu) {
        jrcu.removeResourceModelListener(this.resourceModelListener);
        this.removeItemFromCollection(jrcu, this.externalJavaResourceCompilationUnits, "externalJavaResourceCompilationUnits");
    }

    @Override
    public JpaRootContextNode getRootContextNode() {
        return this.rootContextNode;
    }

    @Override
    public IFile getPlatformFile(IPath runtimePath) {
        return this.getProjectResourceLocator().getPlatformFile(runtimePath);
    }

    @Override
    public JpaXmlResource getPersistenceXmlResource() {
        return (JpaXmlResource)this.getResourceModel(JptJpaCorePlugin.DEFAULT_PERSISTENCE_XML_RUNTIME_PATH, JptJpaCorePlugin.PERSISTENCE_XML_CONTENT_TYPE);
    }

    @Override
    public JpaXmlResource getDefaultOrmXmlResource() {
        return this.getMappingFileXmlResource(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH);
    }

    @Override
    public JpaXmlResource getMappingFileXmlResource(IPath runtimePath) {
        return (JpaXmlResource)this.getResourceModel(runtimePath, JptJpaCorePlugin.MAPPING_FILE_CONTENT_TYPE);
    }

    protected JptResourceModel getResourceModel(IPath runtimePath, IContentType contentType) {
        IFile file = this.getPlatformFile(runtimePath);
        return file != null && file.exists() ? this.getResourceModel(file, contentType) : null;
    }

    protected JptResourceModel getResourceModel(IFile file, IContentType contentType) {
        JpaFile jpaFile = this.getJpaFile(file);
        return jpaFile == null ? null : jpaFile.getResourceModel(contentType);
    }

    @Override
    public Iterable<String> getAnnotatedJavaSourceClassNames() {
        return new TransformationIterable<JavaResourceAbstractType, String>(this.getInternalAnnotatedSourceJavaResourceTypes()){

            protected String transform(JavaResourceAbstractType jraType) {
                return jraType.getQualifiedName();
            }
        };
    }

    protected Iterable<JavaResourceAbstractType> getInternalAnnotatedSourceJavaResourceTypes() {
        return new FilteringIterable<JavaResourceAbstractType>(this.getInternalSourceJavaResourceTypes()){

            protected boolean accept(JavaResourceAbstractType jraType) {
                return jraType.isAnnotated();
            }
        };
    }

    @Override
    public Iterable<String> getMappedJavaSourceClassNames() {
        return new TransformationIterable<JavaResourceAbstractType, String>(this.getInternalMappedSourceJavaResourceTypes()){

            protected String transform(JavaResourceAbstractType jraType) {
                return jraType.getQualifiedName();
            }
        };
    }

    protected Iterable<JavaResourceAbstractType> getInternalMappedSourceJavaResourceTypes() {
        final Iterable<String> typeMappingAnnotationNames = this.getTypeMappingAnnotationNames();
        return new FilteringIterable<JavaResourceAbstractType>(this.getInternalAnnotatedSourceJavaResourceTypes()){

            protected boolean accept(JavaResourceAbstractType jraType) {
                return jraType.isAnnotatedWithAnyOf(typeMappingAnnotationNames);
            }
        };
    }

    @Override
    public Iterable<String> getTypeMappingAnnotationNames() {
        return new TransformationIterable<JavaTypeMappingDefinition, String>(this.getJpaPlatform().getJavaTypeMappingDefinitions()){

            protected String transform(JavaTypeMappingDefinition o) {
                return o.getAnnotationName();
            }
        };
    }

    protected Iterable<JavaResourceAbstractType> getInternalSourceJavaResourceTypes() {
        return new CompositeIterable(this.getInternalSourceJavaResourceTypeLists());
    }

    protected Iterable<Iterable<JavaResourceAbstractType>> getInternalSourceJavaResourceTypeLists() {
        return new TransformationIterable<JavaResourceCompilationUnit, Iterable<JavaResourceAbstractType>>(this.getInternalJavaResourceCompilationUnits()){

            protected Iterable<JavaResourceAbstractType> transform(JavaResourceCompilationUnit compilationUnit) {
                return compilationUnit.getTypes();
            }
        };
    }

    protected Iterable<JavaResourceCompilationUnit> getInternalJavaResourceCompilationUnits() {
        return new TransformationIterable<JpaFile, JavaResourceCompilationUnit>(this.getJavaSourceJpaFiles()){

            protected JavaResourceCompilationUnit transform(JpaFile jpaFile) {
                return (JavaResourceCompilationUnit)jpaFile.getResourceModel();
            }
        };
    }

    protected Iterable<JpaFile> getJavaSourceJpaFiles() {
        return this.getJpaFiles(JptCommonCorePlugin.JAVA_SOURCE_CONTENT_TYPE);
    }

    @Override
    public JavaResourceAbstractType getJavaResourceType(String typeName) {
        for (JavaResourceAbstractType jraType : this.getJavaResourceTypes()) {
            if (!jraType.getQualifiedName().equals(typeName)) continue;
            return jraType;
        }
        return this.buildExternalJavaResourceType(typeName);
    }

    @Override
    public JavaResourceAbstractType getJavaResourceType(String typeName, JavaResourceAnnotatedElement.Kind kind) {
        JavaResourceAbstractType resourceType = this.getJavaResourceType(typeName);
        if (resourceType == null || resourceType.getKind() != kind) {
            return null;
        }
        return resourceType;
    }

    protected Iterable<JavaResourceAbstractType> getJavaResourceTypes() {
        return new CompositeIterable(this.getJavaResourceTypeSets());
    }

    protected Iterable<Iterable<JavaResourceAbstractType>> getJavaResourceTypeSets() {
        return new TransformationIterable<JavaResourceNode.Root, Iterable<JavaResourceAbstractType>>(this.getJavaResourceNodeRoots()){

            protected Iterable<JavaResourceAbstractType> transform(JavaResourceNode.Root root) {
                return root.getTypes();
            }
        };
    }

    protected Iterable<JavaResourceNode.Root> getJavaResourceNodeRoots() {
        return new CompositeIterable(new Iterable[]{this.getInternalJavaResourceCompilationUnits(), this.getInternalJavaResourcePackageFragmentRoots(), this.getExternalJavaResourceCompilationUnits(), Collections.singleton(this.externalJavaResourceTypeCache)});
    }

    @Override
    public JavaResourcePackage getJavaResourcePackage(String packageName) {
        for (JavaResourcePackage jrp : this.getJavaResourcePackages()) {
            if (!jrp.getName().equals(packageName)) continue;
            return jrp;
        }
        return null;
    }

    @Override
    public Iterable<JavaResourcePackage> getJavaResourcePackages() {
        return new FilteringIterable<JavaResourcePackage>((Iterable)new TransformationIterable<JpaFile, JavaResourcePackage>(this.getPackageInfoSourceJpaFiles()){

            protected JavaResourcePackage transform(JpaFile jpaFile) {
                return ((JavaResourcePackageInfoCompilationUnit)jpaFile.getResourceModel()).getPackage();
            }
        }){

            protected boolean accept(JavaResourcePackage packageInfo) {
                return packageInfo != null;
            }
        };
    }

    protected Iterable<JpaFile> getPackageInfoSourceJpaFiles() {
        return this.getJpaFiles(JptCommonCorePlugin.JAVA_SOURCE_PACKAGE_INFO_CONTENT_TYPE);
    }

    @Override
    public JavaResourcePackageFragmentRoot getJavaResourcePackageFragmentRoot(String jarFileName) {
        return this.getJavaResourcePackageFragmentRoot(this.project.getFile(jarFileName));
    }

    protected JavaResourcePackageFragmentRoot getJavaResourcePackageFragmentRoot(IFile jarFile) {
        for (JavaResourcePackageFragmentRoot pfr : this.getInternalJavaResourcePackageFragmentRoots()) {
            if (!pfr.getFile().equals((Object)jarFile)) continue;
            return pfr;
        }
        return null;
    }

    protected Iterable<JavaResourcePackageFragmentRoot> getInternalJavaResourcePackageFragmentRoots() {
        return new TransformationIterable<JpaFile, JavaResourcePackageFragmentRoot>(this.getJarJpaFiles()){

            protected JavaResourcePackageFragmentRoot transform(JpaFile jpaFile) {
                return (JavaResourcePackageFragmentRoot)jpaFile.getResourceModel();
            }
        };
    }

    @Override
    public Iterable<JpaFile> getJarJpaFiles() {
        return this.getJpaFiles(JptCommonCorePlugin.JAR_CONTENT_TYPE);
    }

    @Override
    public Iterable<JavaResourceAbstractType> getGeneratedMetamodelTopLevelTypes() {
        if (this.metamodelSourceFolderName == null) {
            return EmptyIterable.instance();
        }
        final IPackageFragmentRoot genSourceFolder = this.getMetamodelPackageFragmentRoot();
        return new FilteringIterable<JavaResourceAbstractType>(this.getInternalSourceJavaResourceTypes()){

            protected boolean accept(JavaResourceAbstractType jrat) {
                return MetamodelSynchronizer.MetamodelTools.isGeneratedMetamodelTopLevelType(jrat, genSourceFolder);
            }
        };
    }

    @Override
    public JavaResourceAbstractType getGeneratedMetamodelTopLevelType(IFile file) {
        JavaResourceCompilationUnit jrcu = this.getJavaResourceCompilationUnit(file);
        if (jrcu == null) {
            return null;
        }
        JavaResourceAbstractType primaryType = jrcu.getPrimaryType();
        if (primaryType == null) {
            return null;
        }
        return MetamodelSynchronizer.MetamodelTools.isGeneratedMetamodelTopLevelType(primaryType) ? primaryType : null;
    }

    protected JavaResourceCompilationUnit getJavaResourceCompilationUnit(IFile file) {
        return (JavaResourceCompilationUnit)this.getResourceModel(file, JptCommonCorePlugin.JAVA_SOURCE_CONTENT_TYPE);
    }

    @Override
    public String getMetamodelSourceFolderName() {
        return this.metamodelSourceFolderName;
    }

    @Override
    public void setMetamodelSourceFolderName(String folderName) {
        if (this.setMetamodelSourceFolderName_(folderName)) {
            JptJpaCorePlugin.setMetamodelSourceFolderName(this.project, folderName);
            if (folderName == null) {
                this.disposeMetamodel();
            } else {
                this.initializeMetamodel();
            }
        }
    }

    protected boolean setMetamodelSourceFolderName_(String folderName) {
        String old = this.metamodelSourceFolderName;
        this.metamodelSourceFolderName = folderName;
        return this.firePropertyChanged("metamodelSourceFolderName", old, folderName);
    }

    @Override
    public void initializeMetamodel() {
        if (this.isJpa2_0Compatible()) {
            ((JpaRootContextNode2_0)this.rootContextNode).initializeMetamodel();
        }
    }

    @Override
    public IStatus synchronizeMetamodel(IProgressMonitor monitor) {
        if (this.isJpa2_0Compatible() && this.metamodelSourceFolderName != null) {
            this.scheduleSynchronizeMetamodelJob();
        }
        return Status.OK_STATUS;
    }

    protected void scheduleSynchronizeMetamodelJob() {
        this.buildSynchronizeMetamodelJob().schedule();
    }

    protected Job buildSynchronizeMetamodelJob() {
        Job job = this.buildSynchronizeMetamodelJob_();
        job.setRule((ISchedulingRule)this.project);
        return job;
    }

    protected Job buildSynchronizeMetamodelJob_() {
        return new SynchronizeMetamodelJob(this.buildSynchronizeMetamodelJobName());
    }

    protected String buildSynchronizeMetamodelJobName() {
        return NLS.bind((String)JptCoreMessages.METAMODEL_SYNC_JOB_NAME, (Object)this.getName());
    }

    protected IStatus synchronizeMetamodel_(IProgressMonitor monitor) {
        return ((JpaRootContextNode2_0)this.rootContextNode).synchronizeMetamodel(monitor);
    }

    @Override
    public void disposeMetamodel() {
        if (this.isJpa2_0Compatible()) {
            ((JpaRootContextNode2_0)this.rootContextNode).disposeMetamodel();
        }
    }

    @Override
    public IPackageFragmentRoot getMetamodelPackageFragmentRoot() {
        return this.getJavaProject().getPackageFragmentRoot((IResource)this.getMetaModelSourceFolder());
    }

    protected IFolder getMetaModelSourceFolder() {
        return this.project.getFolder(this.metamodelSourceFolderName);
    }

    protected void checkMetamodelSourceFolderName() {
        if (this.metamodelSoureFolderNameIsInvalid()) {
            this.setMetamodelSourceFolderName(null);
        }
    }

    protected boolean metamodelSoureFolderNameIsInvalid() {
        return !this.metamodelSourceFolderNameIsValid();
    }

    protected boolean metamodelSourceFolderNameIsValid() {
        return CollectionTools.contains(this.getJavaSourceFolderNames(), (Object)this.metamodelSourceFolderName);
    }

    @Override
    public Iterable<String> getJavaSourceFolderNames() {
        try {
            return this.getJavaSourceFolderNames_();
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return EmptyIterable.instance();
        }
    }

    protected Iterable<String> getJavaSourceFolderNames_() throws JavaModelException {
        return new TransformationIterable<IPackageFragmentRoot, String>(this.getJavaSourceFolders()){

            protected String transform(IPackageFragmentRoot pfr) {
                try {
                    return this.transform_(pfr);
                }
                catch (JavaModelException javaModelException) {
                    return "Error: " + pfr.getPath();
                }
            }

            private String transform_(IPackageFragmentRoot pfr) throws JavaModelException {
                return pfr.getUnderlyingResource().getProjectRelativePath().toString();
            }
        };
    }

    protected Iterable<IPackageFragmentRoot> getJavaSourceFolders() throws JavaModelException {
        return new FilteringIterable(this.getPackageFragmentRoots(), SOURCE_PACKAGE_FRAGMENT_ROOT_FILTER);
    }

    protected Iterable<IPackageFragmentRoot> getPackageFragmentRoots() throws JavaModelException {
        return new ArrayIterable((Object[])this.getJavaProject().getPackageFragmentRoots());
    }

    @Override
    public void javaElementChanged(ElementChangedEvent event) {
        this.processJavaDelta(event.getDelta());
    }

    protected void processJavaDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 1: {
                this.processJavaModelDelta(delta);
                break;
            }
            case 2: {
                this.processJavaProjectDelta(delta);
                break;
            }
            case 3: {
                this.processJavaPackageFragmentRootDelta(delta);
                break;
            }
            case 4: {
                this.processJavaPackageFragmentDelta(delta);
                break;
            }
            case 5: {
                this.processJavaCompilationUnitDelta(delta);
                break;
            }
        }
    }

    protected void processJavaDeltaChildren(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            this.processJavaDelta(child);
            ++n2;
        }
    }

    protected static boolean deltaFlagIsSet(IJavaElementDelta delta, int flag) {
        return delta.getKind() == 4 && BitTools.flagIsSet((int)delta.getFlags(), (int)flag);
    }

    protected void processJavaModelDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
    }

    protected void processJavaProjectDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
        if (AbstractJpaProject.classpathHasChanged(delta)) {
            this.rebuild((IJavaProject)delta.getElement());
        }
    }

    protected void rebuild(IJavaProject javaProject) {
        if (javaProject.equals(this.getJavaProject())) {
            this.removeDeadJpaFiles();
            this.checkMetamodelSourceFolderName();
            this.synchronizeWithJavaSource(this.getInternalJavaResourceCompilationUnits());
        } else {
            this.synchronizeWithJavaSource(this.getExternalJavaResourceCompilationUnits());
        }
    }

    protected void removeDeadJpaFiles() {
        for (JpaFile jpaFile : this.getJpaFiles()) {
            if (!this.jpaFileIsDead(jpaFile)) continue;
            this.removeJpaFile(jpaFile);
        }
    }

    protected boolean jpaFileIsDead(JpaFile jpaFile) {
        return !this.jpaFileIsAlive(jpaFile);
    }

    protected boolean jpaFileIsAlive(JpaFile jpaFile) {
        IFile file = jpaFile.getFile();
        if (!file.exists()) {
            return false;
        }
        if (this.fileIsJavaRelated(file)) {
            return this.getJavaProject().isOnClasspath((IResource)file);
        }
        return this.fileResourceLocationIsValid(file);
    }

    protected static boolean classpathHasChanged(IJavaElementDelta delta) {
        return AbstractJpaProject.deltaFlagIsSet(delta, 0x200000);
    }

    protected void synchronizeWithJavaSource(Iterable<JavaResourceCompilationUnit> javaResourceCompilationUnits) {
        for (JavaResourceCompilationUnit javaResourceCompilationUnit : javaResourceCompilationUnits) {
            javaResourceCompilationUnit.synchronizeWithJavaSource();
        }
    }

    protected void processJavaPackageFragmentRootDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
        if (!AbstractJpaProject.classpathEntryHasBeenAdded(delta)) {
            AbstractJpaProject.classpathEntryHasBeenRemoved(delta);
        }
    }

    protected static boolean classpathEntryHasBeenAdded(IJavaElementDelta delta) {
        return AbstractJpaProject.deltaFlagIsSet(delta, 64);
    }

    protected static boolean classpathEntryHasBeenRemoved(IJavaElementDelta delta) {
        return AbstractJpaProject.deltaFlagIsSet(delta, 128);
    }

    protected void processJavaPackageFragmentDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
    }

    protected void processJavaCompilationUnitDelta(IJavaElementDelta delta) {
        if (AbstractJpaProject.javaCompilationUnitDeltaIsRelevant(delta)) {
            ICompilationUnit compilationUnit = (ICompilationUnit)delta.getElement();
            for (JavaResourceCompilationUnit jrcu : this.getCombinedJavaResourceCompilationUnits()) {
                if (!jrcu.getCompilationUnit().equals(compilationUnit)) continue;
                jrcu.synchronizeWithJavaSource();
                break;
            }
        }
    }

    protected static boolean javaCompilationUnitDeltaIsRelevant(IJavaElementDelta delta) {
        ICompilationUnit compilationUnit;
        if (delta.getKind() != 4) {
            return false;
        }
        if (BitTools.onlyFlagIsSet((int)delta.getFlags(), (int)65536)) {
            return false;
        }
        return !BitTools.onlyFlagIsSet((int)delta.getFlags(), (int)262144) || AbstractJpaProject.compilationUnitResourceExists(compilationUnit = (ICompilationUnit)delta.getElement());
    }

    protected static boolean compilationUnitResourceExists(ICompilationUnit compilationUnit) {
        try {
            return compilationUnit.getCorrespondingResource().exists();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    @Override
    public Iterable<IMessage> getValidationMessages(IReporter reporter) {
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        this.validate(messages, reporter);
        return new SnapshotCloneIterable(messages);
    }

    protected void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        this.validateLibraryProvider(messages);
        this.validateConnection(messages);
        this.rootContextNode.validate(messages, reporter);
    }

    protected void validateLibraryProvider(List<IMessage> messages) {
        try {
            this.validateLibraryProvider_(messages);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    protected void validateLibraryProvider_(List<IMessage> messages) throws CoreException {
        HashMap<String, Object> enablementVariables = new HashMap<String, Object>();
        enablementVariables.put("jpaPlatform", this.getJpaPlatform().getId());
        enablementVariables.put("jpaPlatformDescription", this.getJpaPlatform().getDescription());
        ILibraryProvider libraryProvider = LibraryProviderFramework.getCurrentProvider((IProject)this.project, (IProjectFacet)JpaFacet.FACET);
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project);
        IProjectFacetVersion facetVersion = facetedProject.getInstalledVersion(JpaFacet.FACET);
        if (!libraryProvider.isEnabledFor((IFacetedProjectBase)facetedProject, facetVersion, enablementVariables)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PROJECT_INVALID_LIBRARY_PROVIDER", this));
        }
    }

    protected void validateConnection(List<IMessage> messages) {
        String cpName = this.dataSource.getConnectionProfileName();
        if (StringTools.stringIsEmpty((String)cpName)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_NO_CONNECTION", this));
            return;
        }
        ConnectionProfile cp = this.dataSource.getConnectionProfile();
        if (cp == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_INVALID_CONNECTION", new String[]{cpName}, this));
            return;
        }
        if (cp.isInactive()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_INACTIVE_CONNECTION", new String[]{cpName}, this));
        }
    }

    @Override
    public void dispose() {
        this.stopCommand(this.synchronizeContextModelCommand);
        this.stopCommand((RepeatingJobCommand)this.updateCommand);
        this.updateCommand.removeListener(this.updateCommandListener);
        this.dataSource.dispose();
        for (JpaFile jpaFile : this.getJpaFiles()) {
            jpaFile.getResourceModel().removeResourceModelListener(this.resourceModelListener);
        }
    }

    protected void stopCommand(RepeatingJobCommand command) {
        try {
            command.stop();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    protected JptResourceModelListener buildResourceModelListener() {
        return new ResourceModelListener();
    }

    protected void synchronizeContextModel(JptResourceModel jpaResourceModel) {
        this.synchronizeContextModel();
    }

    @Override
    public void projectChanged(IResourceDelta delta) {
        if (delta.getResource().equals((Object)this.project)) {
            this.internalProjectChanged(delta);
        } else {
            this.externalProjectChanged(delta);
        }
    }

    protected void internalProjectChanged(IResourceDelta delta) {
        ResourceDeltaVisitor resourceDeltaVisitor = this.buildInternalResourceDeltaVisitor();
        resourceDeltaVisitor.visitDelta(delta);
        if (resourceDeltaVisitor.encounteredSignificantChange()) {
            this.resolveInternalJavaTypes();
        }
    }

    protected ResourceDeltaVisitor buildInternalResourceDeltaVisitor() {
        return new InternalResourceDeltaVisitor();
    }

    protected boolean synchronizeJpaFiles(IFile file, int deltaKind) {
        switch (deltaKind) {
            case 1: {
                return this.addJpaFileMaybe(file);
            }
            case 2: {
                return this.removeJpaFile(file);
            }
            case 4: {
                return this.checkForChangedFileContent(file);
            }
            case 8: {
                break;
            }
            case 16: {
                break;
            }
        }
        return false;
    }

    protected boolean checkForChangedFileContent(IFile file) {
        JpaFile jpaFile = this.getJpaFile(file);
        if (jpaFile == null) {
            return this.addJpaFileMaybe(file);
        }
        if (jpaFile.getContentType().equals(AbstractJpaProject.getContentType(file))) {
            return false;
        }
        this.removeJpaFile(jpaFile);
        this.addJpaFileMaybe(file);
        return true;
    }

    protected void resolveInternalJavaTypes() {
        for (JavaResourceCompilationUnit jrcu : this.getInternalJavaResourceCompilationUnits()) {
            jrcu.resolveTypes();
        }
    }

    protected void externalProjectChanged(IResourceDelta delta) {
        if (this.getJavaProject().isOnClasspath(delta.getResource())) {
            ResourceDeltaVisitor resourceDeltaVisitor = this.buildExternalResourceDeltaVisitor();
            resourceDeltaVisitor.visitDelta(delta);
            if (resourceDeltaVisitor.encounteredSignificantChange()) {
                this.update();
                this.resolveExternalJavaTypes();
                this.resolveInternalJavaTypes();
            }
        }
    }

    protected ResourceDeltaVisitor buildExternalResourceDeltaVisitor() {
        return new ExternalResourceDeltaVisitor();
    }

    protected boolean synchronizeExternalFiles(IFile file, int deltaKind) {
        switch (deltaKind) {
            case 1: {
                return this.externalFileAdded(file);
            }
            case 2: {
                return this.externalFileRemoved(file);
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 16: {
                break;
            }
        }
        return false;
    }

    protected boolean externalFileAdded(IFile file) {
        IContentType contentType = AbstractJpaProject.getContentType(file);
        if (contentType == null) {
            return false;
        }
        if (contentType.equals(JptCommonCorePlugin.JAVA_SOURCE_CONTENT_TYPE)) {
            return true;
        }
        return contentType.equals(JptCommonCorePlugin.JAR_CONTENT_TYPE);
    }

    protected boolean externalFileRemoved(IFile file) {
        IContentType contentType = AbstractJpaProject.getContentType(file);
        if (contentType == null) {
            return false;
        }
        if (contentType.equals(JptCommonCorePlugin.JAVA_SOURCE_CONTENT_TYPE)) {
            return this.removeExternalJavaResourceCompilationUnit(file);
        }
        if (contentType.equals(JptCommonCorePlugin.JAR_CONTENT_TYPE)) {
            return this.externalJavaResourceTypeCache.removeTypes(file);
        }
        return false;
    }

    protected static IContentType getContentType(IFile file) {
        return GenericJpaPlatform.getContentType(file);
    }

    protected void resolveExternalJavaTypes() {
        for (JavaResourceCompilationUnit jrcu : this.getExternalJavaResourceCompilationUnits()) {
            jrcu.resolveTypes();
        }
    }

    protected RepeatingJobCommand buildSynchronizeContextModelCommand() {
        return new RepeatingJobCommandWrapper(this.buildSynchronizeContextModelJobCommand(), this.buildStartSynchronizeContextModelJobCommandExecutor(), this.manager.getExceptionHandler());
    }

    protected JobCommand buildSynchronizeContextModelJobCommand() {
        return new SynchronizeContextModelJobCommand();
    }

    protected JobCommandExecutor buildStartSynchronizeContextModelJobCommandExecutor() {
        return new ManagerJobCommandExecutor(this.buildSynchronizeContextModelJobName());
    }

    protected String buildSynchronizeContextModelJobName() {
        return NLS.bind((String)JptCoreMessages.CONTEXT_MODEL_SYNC_JOB_NAME, (Object)this.getName());
    }

    @Override
    public void synchronizeContextModel() {
        try {
            this.synchronizingContextModel = true;
            this.synchronizeContextModelCommand.execute(null);
        }
        finally {
            this.synchronizingContextModel = false;
        }
        this.update();
    }

    protected IStatus synchronizeContextModel(IProgressMonitor monitor) {
        this.rootContextNode.synchronizeWithResourceModel();
        return Status.OK_STATUS;
    }

    protected NotifyingRepeatingJobCommand buildTempUpdateCommand() {
        return new NotifyingRepeatingJobCommandWrapper(this.buildUpdateJobCommand(), this.manager.getExceptionHandler());
    }

    protected NotifyingRepeatingJobCommand buildUpdateCommand() {
        return new NotifyingRepeatingJobCommandWrapper(this.buildUpdateJobCommand(), this.buildStartUpdateJobCommandExecutor(), this.manager.getExceptionHandler());
    }

    protected JobCommand buildUpdateJobCommand() {
        return new UpdateJobCommand();
    }

    protected JobCommandExecutor buildStartUpdateJobCommandExecutor() {
        return new ManagerJobCommandExecutor(this.buildUpdateJobName());
    }

    protected String buildUpdateJobName() {
        return NLS.bind((String)JptCoreMessages.UPDATE_JOB_NAME, (Object)this.getName());
    }

    @Override
    public void stateChanged() {
        super.stateChanged();
        this.update();
    }

    protected void update() {
        if (!this.synchronizingContextModel) {
            this.updateCommand.execute(null);
        }
    }

    protected IStatus update(IProgressMonitor monitor) {
        this.rootContextNode.update();
        return Status.OK_STATUS;
    }

    protected NotifyingRepeatingJobCommand.Listener buildUpdateCommandListener() {
        return new UpdateCommandListener();
    }

    protected IStatus updateQuiesced(IProgressMonitor monitor) {
        return this.synchronizeMetamodel(monitor);
    }

    protected class ExternalResourceDeltaVisitor
    extends ResourceDeltaVisitor {
        protected ExternalResourceDeltaVisitor() {
        }

        public boolean fileChangeIsSignificant(IFile file, int deltaKind) {
            return AbstractJpaProject.this.synchronizeExternalFiles(file, deltaKind);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)AbstractJpaProject.this);
        }
    }

    protected class InitialResourceProxyVisitor
    implements IResourceProxyVisitor {
        protected InitialResourceProxyVisitor() {
        }

        protected void visitProject(IProject p) {
            try {
                p.accept((IResourceProxyVisitor)this, 0);
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean visit(IResourceProxy resource) {
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    AbstractJpaProject.this.addJpaFileMaybe_((IFile)resource.requestResource());
                    return false;
                }
            }
            return false;
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)AbstractJpaProject.this);
        }
    }

    protected class InternalResourceDeltaVisitor
    extends ResourceDeltaVisitor {
        protected InternalResourceDeltaVisitor() {
        }

        public boolean fileChangeIsSignificant(IFile file, int deltaKind) {
            return AbstractJpaProject.this.synchronizeJpaFiles(file, deltaKind);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)AbstractJpaProject.this);
        }
    }

    protected class ManagerJobCommandExecutor
    implements JobCommandExecutor {
        protected final String defaultJobName;

        protected ManagerJobCommandExecutor(String defaultJobName) {
            if (defaultJobName == null) {
                throw new NullPointerException();
            }
            this.defaultJobName = defaultJobName;
        }

        public void execute(JobCommand command) {
            this.execute(command, this.defaultJobName);
        }

        public void execute(JobCommand command, String jobName) {
            AbstractJpaProject.this.manager.execute(command, jobName, AbstractJpaProject.this);
        }

        public void execute(JobCommand command, String jobName, ISchedulingRule schedulingRule) {
            this.execute(command, jobName);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.defaultJobName);
        }
    }

    protected abstract class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        protected boolean encounteredSignificantChange = false;

        protected ResourceDeltaVisitor() {
        }

        protected void visitDelta(IResourceDelta delta) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean visit(IResourceDelta delta) {
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    this.fileChanged((IFile)res, delta.getKind());
                    return false;
                }
            }
            return false;
        }

        protected void fileChanged(IFile file, int deltaKind) {
            if (this.fileChangeIsSignificant(file, deltaKind)) {
                this.encounteredSignificantChange = true;
            }
        }

        protected abstract boolean fileChangeIsSignificant(IFile var1, int var2);

        protected boolean encounteredSignificantChange() {
            return this.encounteredSignificantChange;
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)AbstractJpaProject.this);
        }
    }

    protected class ResourceModelListener
    implements JptResourceModelListener {
        protected ResourceModelListener() {
        }

        public void resourceModelChanged(JptResourceModel jpaResourceModel) {
            AbstractJpaProject.this.synchronizeContextModel(jpaResourceModel);
        }

        public void resourceModelReverted(JptResourceModel jpaResourceModel) {
            IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)((JpaXmlResource)jpaResourceModel));
            AbstractJpaProject.this.removeJpaFile(file);
            AbstractJpaProject.this.addJpaFileMaybe(file);
        }

        public void resourceModelUnloaded(JptResourceModel jpaResourceModel) {
            IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)((JpaXmlResource)jpaResourceModel));
            AbstractJpaProject.this.removeJpaFile(file);
            if (file.exists()) {
                AbstractJpaProject.this.addJpaFileMaybe(file);
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)AbstractJpaProject.this);
        }
    }

    protected class SynchronizeContextModelJobCommand
    implements JobCommand {
        protected SynchronizeContextModelJobCommand() {
        }

        public IStatus execute(IProgressMonitor monitor) {
            return AbstractJpaProject.this.synchronizeContextModel(monitor);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)AbstractJpaProject.this);
        }
    }

    protected class SynchronizeMetamodelJob
    extends WorkspaceJob {
        protected SynchronizeMetamodelJob(String name) {
            super(name);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            return AbstractJpaProject.this.synchronizeMetamodel_(monitor);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)((Object)this), (Object)AbstractJpaProject.this);
        }
    }

    protected class UpdateCommandListener
    implements NotifyingRepeatingJobCommand.Listener {
        protected UpdateCommandListener() {
        }

        public IStatus executionQuiesced(JobCommand command, IProgressMonitor monitor) {
            return AbstractJpaProject.this.updateQuiesced(monitor);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)AbstractJpaProject.this);
        }
    }

    protected class UpdateJobCommand
    implements JobCommand {
        protected UpdateJobCommand() {
        }

        public IStatus execute(IProgressMonitor monitor) {
            return AbstractJpaProject.this.update(monitor);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)AbstractJpaProject.this);
        }
    }
}

