/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.internal.InternalJpaProjectManager;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{JpaProject.Reference.class, JpaProject.class};

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IProject) {
            return this.getAdapter((IProject)adaptableObject, adapterType);
        }
        return null;
    }

    private Object getAdapter(IProject project, Class<?> adapterType) {
        if (adapterType == JpaProject.Reference.class) {
            return this.getJpaProjectReference(project);
        }
        if (adapterType == JpaProject.class) {
            return this.getJpaProject(project);
        }
        return null;
    }

    private JpaProject.Reference getJpaProjectReference(IProject project) {
        return new JpaProjectReference(this.getJpaProjectManager(project.getWorkspace()), project);
    }

    private JpaProject getJpaProject(IProject project) {
        for (JpaProject jpaProject : this.getJpaProjectManager(project.getWorkspace()).getJpaProjects_()) {
            if (!jpaProject.getProject().equals((Object)project)) continue;
            return jpaProject;
        }
        return null;
    }

    private InternalJpaProjectManager getJpaProjectManager(IWorkspace workspace) {
        return (InternalJpaProjectManager)workspace.getAdapter(JpaProjectManager.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JpaProjectReference
    implements JpaProject.Reference {
        private InternalJpaProjectManager jpaProjectManager;
        private final IProject project;

        JpaProjectReference(InternalJpaProjectManager jpaProjectManager, IProject project) {
            this.jpaProjectManager = jpaProjectManager;
            this.project = project;
        }

        @Override
        public JpaProject getValue() throws InterruptedException {
            return this.jpaProjectManager.waitToGetJpaProject(this.project);
        }

        @Override
        public JpaProject rebuild() throws InterruptedException {
            return this.jpaProjectManager.rebuildJpaProject(this.project);
        }

        @Override
        public Iterable<IMessage> buildValidationMessages(IReporter reporter) throws InterruptedException {
            return this.jpaProjectManager.buildValidationMessages(this.project, reporter);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.project);
        }
    }
}

