/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.SequenceGenerator;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaSequenceGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.jpa.db.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmSequenceGenerator
extends AbstractOrmGenerator<XmlSequenceGenerator>
implements OrmSequenceGenerator {
    protected String specifiedSequenceName;
    protected String defaultSequenceName;

    protected AbstractOrmSequenceGenerator(XmlContextNode parent, XmlSequenceGenerator xmlSequenceGenerator) {
        super(parent, xmlSequenceGenerator);
        this.specifiedSequenceName = xmlSequenceGenerator.getSequenceName();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedSequenceName_(((XmlSequenceGenerator)this.xmlGenerator).getSequenceName());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultSequenceName(this.buildDefaultSequenceName());
    }

    @Override
    protected int buildDefaultInitialValue() {
        return 1;
    }

    @Override
    public String getSequenceName() {
        return this.specifiedSequenceName != null ? this.specifiedSequenceName : this.defaultSequenceName;
    }

    @Override
    public String getSpecifiedSequenceName() {
        return this.specifiedSequenceName;
    }

    @Override
    public void setSpecifiedSequenceName(String specifiedSequenceName) {
        this.setSpecifiedSequenceName_(specifiedSequenceName);
        ((XmlSequenceGenerator)this.xmlGenerator).setSequenceName(specifiedSequenceName);
    }

    protected void setSpecifiedSequenceName_(String specifiedSequenceName) {
        String old = this.specifiedSequenceName;
        this.specifiedSequenceName = specifiedSequenceName;
        this.firePropertyChanged("specifiedSequenceName", old, specifiedSequenceName);
    }

    @Override
    public String getDefaultSequenceName() {
        return this.defaultSequenceName;
    }

    protected void setDefaultSequenceName(String defaultSequenceName) {
        String old = this.defaultSequenceName;
        this.defaultSequenceName = defaultSequenceName;
        this.firePropertyChanged("defaultSequenceName", old, defaultSequenceName);
    }

    protected String buildDefaultSequenceName() {
        return null;
    }

    public Class<SequenceGenerator> getType() {
        return SequenceGenerator.class;
    }

    @Override
    protected boolean isEquivalentTo(Generator generator) {
        return super.isEquivalentTo(generator) && this.isEquivalentTo((SequenceGenerator)generator);
    }

    protected boolean isEquivalentTo(SequenceGenerator generator) {
        return Tools.valuesAreEqual((Object)this.specifiedSequenceName, (Object)generator.getSpecifiedSequenceName());
    }

    @Override
    public void convertFrom(JavaSequenceGenerator javaGenerator) {
        super.convertFrom(javaGenerator);
        this.setSpecifiedSequenceName(javaGenerator.getSpecifiedSequenceName());
    }

    @Override
    protected Iterable<String> getConnectedXmlCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.sequenceNameTouches(pos)) {
            return this.getCandidateSequences();
        }
        return null;
    }

    protected boolean sequenceNameTouches(int pos) {
        return ((XmlSequenceGenerator)this.xmlGenerator).sequenceNameTouches(pos);
    }

    protected Iterable<String> getCandidateSequences() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.getSortedSequenceIdentifiers() : EmptyIterable.instance();
    }
}

