/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.jpa.core.context.GenerationType;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratedValue;
import org.eclipse.jpt.jpa.core.context.java.JavaIdMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.java.GeneratedValueAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaGeneratedValue
extends AbstractJavaJpaContextNode
implements JavaGeneratedValue {
    protected final GeneratedValueAnnotation generatedValueAnnotation;
    protected GenerationType specifiedStrategy;
    protected GenerationType defaultStrategy;
    protected String specifiedGenerator;
    protected String defaultGenerator;

    public GenericJavaGeneratedValue(JavaIdMapping parent, GeneratedValueAnnotation generatedValueAnnotation) {
        super(parent);
        this.generatedValueAnnotation = generatedValueAnnotation;
        this.specifiedStrategy = this.buildSpecifiedStrategy();
        this.specifiedGenerator = generatedValueAnnotation.getGenerator();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedStrategy_(this.buildSpecifiedStrategy());
        this.setSpecifiedGenerator_(this.generatedValueAnnotation.getGenerator());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultStrategy(this.buildDefaultStrategy());
        this.setDefaultGenerator(this.buildDefaultGenerator());
    }

    @Override
    public GenerationType getStrategy() {
        return this.specifiedStrategy != null ? this.specifiedStrategy : this.defaultStrategy;
    }

    @Override
    public GenerationType getSpecifiedStrategy() {
        return this.specifiedStrategy;
    }

    @Override
    public void setSpecifiedStrategy(GenerationType strategy) {
        this.generatedValueAnnotation.setStrategy(GenerationType.toJavaResourceModel(strategy));
        this.setSpecifiedStrategy_(strategy);
    }

    protected void setSpecifiedStrategy_(GenerationType strategy) {
        GenerationType old = this.specifiedStrategy;
        this.specifiedStrategy = strategy;
        this.firePropertyChanged("specifiedStrategy", (Object)old, (Object)strategy);
    }

    protected GenerationType buildSpecifiedStrategy() {
        return GenerationType.fromJavaResourceModel(this.generatedValueAnnotation.getStrategy());
    }

    @Override
    public GenerationType getDefaultStrategy() {
        return this.defaultStrategy;
    }

    protected void setDefaultStrategy(GenerationType strategy) {
        GenerationType old = this.defaultStrategy;
        this.defaultStrategy = strategy;
        this.firePropertyChanged("defaultStrategy", (Object)old, (Object)strategy);
    }

    protected GenerationType buildDefaultStrategy() {
        return DEFAULT_STRATEGY;
    }

    @Override
    public String getGenerator() {
        return this.specifiedGenerator != null ? this.specifiedGenerator : this.defaultGenerator;
    }

    @Override
    public String getSpecifiedGenerator() {
        return this.specifiedGenerator;
    }

    @Override
    public void setSpecifiedGenerator(String generator) {
        this.generatedValueAnnotation.setGenerator(generator);
        this.setSpecifiedGenerator_(generator);
    }

    protected void setSpecifiedGenerator_(String generator) {
        String old = this.specifiedGenerator;
        this.specifiedGenerator = generator;
        this.firePropertyChanged("specifiedGenerator", old, generator);
    }

    @Override
    public String getDefaultGenerator() {
        return this.defaultGenerator;
    }

    protected void setDefaultGenerator(String generator) {
        String old = this.defaultGenerator;
        this.defaultGenerator = generator;
        this.firePropertyChanged("defaultGenerator", old, generator);
    }

    protected String buildDefaultGenerator() {
        return null;
    }

    @Override
    public JavaIdMapping getParent() {
        return (JavaIdMapping)super.getParent();
    }

    protected JavaIdMapping getIdMapping() {
        return this.getParent();
    }

    @Override
    public GeneratedValueAnnotation getGeneratedValueAnnotation() {
        return this.generatedValueAnnotation;
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.generatorTouches(pos)) {
            return this.getJavaCandidateGeneratorNames(filter);
        }
        return null;
    }

    protected boolean generatorTouches(int pos) {
        return this.generatedValueAnnotation.generatorTouches(pos);
    }

    protected Iterable<String> getJavaCandidateGeneratorNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateGeneratorNames(filter));
    }

    protected Iterable<String> getCandidateGeneratorNames(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateGeneratorNames(), filter);
    }

    protected Iterable<String> getCandidateGeneratorNames() {
        return this.getPersistenceUnit().getUniqueGeneratorNames();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        String generator = this.getGenerator();
        if (generator == null) {
            return;
        }
        for (Generator next : this.getPersistenceUnit().getGenerators()) {
            if (!generator.equals(next.getName())) continue;
            return;
        }
        messages.add(DefaultJpaValidationMessages.buildMessage(1, "ID_MAPPING_UNRESOLVED_GENERATOR_NAME", new String[]{generator}, this.getIdMapping(), this.getGeneratorTextRange(astRoot)));
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getAnnotationTextRange(astRoot);
        return textRange != null ? textRange : this.getIdMapping().getValidationTextRange(astRoot);
    }

    protected TextRange getAnnotationTextRange(CompilationUnit astRoot) {
        return this.generatedValueAnnotation.getTextRange(astRoot);
    }

    @Override
    public TextRange getGeneratorTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.generatedValueAnnotation.getGeneratorTextRange(), astRoot);
    }
}

