/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaRelationship;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.JoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaReferenceTable;
import org.eclipse.jpt.jpa.core.internal.resource.java.NullJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaJoinTable
extends GenericJavaReferenceTable<JoinTableAnnotation>
implements JavaJoinTable {
    protected final AbstractJpaNode.ContextListContainer<JavaJoinColumn, JoinColumnAnnotation> specifiedInverseJoinColumnContainer;
    protected final JavaReadOnlyJoinColumn.Owner inverseJoinColumnOwner = this.buildInverseJoinColumnOwner();
    protected JavaJoinColumn defaultInverseJoinColumn;

    public GenericJavaJoinTable(JavaJoinTableRelationshipStrategy parent, ReadOnlyTable.Owner owner) {
        super(parent, owner);
        this.specifiedInverseJoinColumnContainer = this.buildSpecifiedInverseJoinColumnContainer();
    }

    @Override
    protected JavaReadOnlyJoinColumn.Owner buildJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedInverseJoinColumns();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedInverseJoinColumns());
        this.updateDefaultInverseJoinColumn();
    }

    @Override
    public JoinTableAnnotation getTableAnnotation() {
        return this.getRelationshipStrategy().getJoinTableAnnotation();
    }

    @Override
    protected void removeTableAnnotation() {
    }

    @Override
    public ListIterable<JavaJoinColumn> getInverseJoinColumns() {
        return this.hasSpecifiedInverseJoinColumns() ? this.getSpecifiedInverseJoinColumns() : this.getDefaultInverseJoinColumns();
    }

    @Override
    public int getInverseJoinColumnsSize() {
        return this.hasSpecifiedInverseJoinColumns() ? this.getSpecifiedInverseJoinColumnsSize() : this.defaultInverseJoinColumnsSize();
    }

    @Override
    public void convertDefaultInverseJoinColumnToSpecified() {
        MappingTools.convertJoinTableDefaultToSpecifiedInverseJoinColumn(this);
    }

    @Override
    public ListIterable<JavaJoinColumn> getSpecifiedInverseJoinColumns() {
        return this.specifiedInverseJoinColumnContainer.getContextElements();
    }

    @Override
    public int getSpecifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumnContainer.getContextElementsSize();
    }

    @Override
    public boolean hasSpecifiedInverseJoinColumns() {
        return this.getSpecifiedInverseJoinColumnsSize() != 0;
    }

    @Override
    public JavaJoinColumn getSpecifiedInverseJoinColumn(int index) {
        return this.specifiedInverseJoinColumnContainer.getContextElement(index);
    }

    @Override
    public JavaJoinColumn addSpecifiedInverseJoinColumn() {
        return this.addSpecifiedInverseJoinColumn(this.getSpecifiedInverseJoinColumnsSize());
    }

    @Override
    public JavaJoinColumn addSpecifiedInverseJoinColumn(int index) {
        JoinColumnAnnotation annotation = this.getTableAnnotation().addInverseJoinColumn(index);
        return (JavaJoinColumn)this.specifiedInverseJoinColumnContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumnContainer.indexOfContextElement((JavaJoinColumn)joinColumn));
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(int index) {
        this.getTableAnnotation().removeInverseJoinColumn(index);
        this.removeTableAnnotationIfUnset();
        this.specifiedInverseJoinColumnContainer.removeContextElement(index);
    }

    @Override
    public void moveSpecifiedInverseJoinColumn(int targetIndex, int sourceIndex) {
        this.getTableAnnotation().moveInverseJoinColumn(targetIndex, sourceIndex);
        this.specifiedInverseJoinColumnContainer.moveContextElement(targetIndex, sourceIndex);
    }

    @Override
    public void clearSpecifiedInverseJoinColumns() {
        int index = this.getSpecifiedInverseJoinColumnsSize();
        while (--index >= 0) {
            this.getTableAnnotation().removeInverseJoinColumn(index);
        }
        this.removeTableAnnotationIfUnset();
        this.specifiedInverseJoinColumnContainer.clearContextList();
    }

    protected void syncSpecifiedInverseJoinColumns() {
        this.specifiedInverseJoinColumnContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<JoinColumnAnnotation> getInverseJoinColumnAnnotations() {
        return this.getTableAnnotation().getInverseJoinColumns();
    }

    protected JavaReadOnlyJoinColumn.Owner buildInverseJoinColumnOwner() {
        return new InverseJoinColumnOwner();
    }

    protected AbstractJpaNode.ContextListContainer<JavaJoinColumn, JoinColumnAnnotation> buildSpecifiedInverseJoinColumnContainer() {
        SpecifiedInverseJoinColumnContainer container = new SpecifiedInverseJoinColumnContainer();
        container.initialize();
        return container;
    }

    @Override
    public JavaJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(JavaJoinColumn joinColumn) {
        JavaJoinColumn old = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = joinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", old, joinColumn);
    }

    protected ListIterable<JavaJoinColumn> getDefaultInverseJoinColumns() {
        return this.defaultInverseJoinColumn != null ? new SingleElementListIterable((Object)this.defaultInverseJoinColumn) : EmptyListIterable.instance();
    }

    protected int defaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultInverseJoinColumn() {
        if (this.buildsDefaultInverseJoinColumn()) {
            if (this.defaultInverseJoinColumn == null) {
                this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(new NullJoinColumnAnnotation((JavaResourceNode)this.getTableAnnotation())));
            } else {
                this.defaultInverseJoinColumn.update();
            }
        } else {
            this.setDefaultInverseJoinColumn(null);
        }
    }

    protected boolean buildsDefaultInverseJoinColumn() {
        return !this.hasSpecifiedInverseJoinColumns();
    }

    @Override
    public JavaJoinTableRelationshipStrategy getParent() {
        return (JavaJoinTableRelationshipStrategy)super.getParent();
    }

    protected JavaJoinTableRelationshipStrategy getRelationshipStrategy() {
        return this.getParent();
    }

    @Override
    protected String buildDefaultName() {
        return this.getRelationshipStrategy().getJoinTableDefaultName();
    }

    @Override
    public void initializeFrom(ReadOnlyJoinTable oldTable) {
        super.initializeFrom(oldTable);
        for (ReadOnlyJoinColumn joinColumn : oldTable.getSpecifiedInverseJoinColumns()) {
            this.addSpecifiedInverseJoinColumn().initializeFrom(joinColumn);
        }
    }

    @Override
    public void initializeFromVirtual(ReadOnlyJoinTable virtualTable) {
        super.initializeFromVirtual(virtualTable);
        for (ReadOnlyJoinColumn joinColumn : virtualTable.getInverseJoinColumns()) {
            this.addSpecifiedInverseJoinColumn().initializeFromVirtual(joinColumn);
        }
    }

    protected JavaJoinColumn buildInverseJoinColumn(JoinColumnAnnotation joinColumnAnnotation) {
        return this.buildJoinColumn(this.inverseJoinColumnOwner, joinColumnAnnotation);
    }

    @Override
    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationshipStrategy().getRelationship().getMapping();
    }

    @Override
    public PersistentAttribute getPersistentAttribute() {
        return this.getRelationshipMapping().getPersistentAttribute();
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn column : this.getInverseJoinColumns()) {
            result = column.getJavaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validateJoinColumns(messages, reporter, astRoot);
        this.validateNodes((Iterable<? extends JavaJpaContextNode>)this.getInverseJoinColumns(), messages, reporter, astRoot);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getRelationshipStrategy().validatesAgainstDatabase();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractJoinColumnOwner
    implements JavaReadOnlyJoinColumn.Owner {
        protected AbstractJoinColumnOwner() {
        }

        @Override
        public String getDefaultColumnName(ReadOnlyNamedColumn column) {
            return MappingTools.buildJoinColumnDefaultName((ReadOnlyJoinColumn)column, this);
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return Tools.valuesAreDifferent((Object)this.getDefaultTableName(), (Object)tableName);
        }

        @Override
        public Iterable<String> getCandidateTableNames() {
            return EmptyIterable.instance();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return Tools.valuesAreEqual((Object)GenericJavaJoinTable.this.getName(), (Object)tableName) ? GenericJavaJoinTable.this.getDbTable() : null;
        }

        @Override
        public String getDefaultTableName() {
            return GenericJavaJoinTable.this.getName();
        }

        @Override
        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return GenericJavaJoinTable.this.getValidationTextRange(astRoot);
        }

        protected JavaRelationship getRelationship() {
            return this.getRelationshipStrategy().getRelationship();
        }

        protected JavaJoinTableRelationshipStrategy getRelationshipStrategy() {
            return GenericJavaJoinTable.this.getRelationshipStrategy();
        }
    }

    protected class InverseJoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected InverseJoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            RelationshipMapping relationshipMapping = GenericJavaJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            RelationshipMapping relationshipMapping = GenericJavaJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getName();
        }

        public Table getReferencedColumnDbTable() {
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
        }

        public int getJoinColumnsSize() {
            return GenericJavaJoinTable.this.getInverseJoinColumnsSize();
        }

        public JptValidator buildColumnValidator(ReadOnlyNamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return this.getRelationshipStrategy().buildJoinTableInverseJoinColumnValidator((ReadOnlyJoinColumn)column, this, (JoinColumnTextRangeResolver)textRangeResolver);
        }
    }

    protected class JoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected JoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            return this.getRelationship().getEntity();
        }

        public String getAttributeName() {
            return MappingTools.getTargetAttributeName(GenericJavaJoinTable.this.getRelationshipMapping());
        }

        public Table getReferencedColumnDbTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        protected TypeMapping getTypeMapping() {
            return this.getRelationship().getTypeMapping();
        }

        public int getJoinColumnsSize() {
            return GenericJavaJoinTable.this.getJoinColumnsSize();
        }

        public JptValidator buildColumnValidator(ReadOnlyNamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return this.getRelationshipStrategy().buildJoinTableJoinColumnValidator((ReadOnlyJoinColumn)column, this, (JoinColumnTextRangeResolver)textRangeResolver);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedInverseJoinColumnContainer
    extends AbstractJpaNode.ContextListContainer<JavaJoinColumn, JoinColumnAnnotation> {
        protected SpecifiedInverseJoinColumnContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "specifiedInverseJoinColumns";
        }

        @Override
        protected JavaJoinColumn buildContextElement(JoinColumnAnnotation resourceElement) {
            return GenericJavaJoinTable.this.buildInverseJoinColumn(resourceElement);
        }

        @Override
        protected ListIterable<JoinColumnAnnotation> getResourceElements() {
            return GenericJavaJoinTable.this.getInverseJoinColumnAnnotations();
        }

        @Override
        protected JoinColumnAnnotation getResourceElement(JavaJoinColumn contextElement) {
            return (JoinColumnAnnotation)contextElement.getColumnAnnotation();
        }
    }
}

