/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.ReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.OrderColumnValidator;
import org.eclipse.jpt.jpa.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOrderable2_0;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOrderColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOrderable;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmOrderable
extends AbstractOrmXmlContextNode
implements OrmOrderable2_0 {
    protected String specifiedOrderBy = this.buildSpecifiedOrderBy();
    protected boolean noOrdering = this.buildNoOrdering();
    protected boolean pkOrdering = this.buildPkOrdering();
    protected boolean customOrdering = this.buildCustomOrdering();
    protected final Orderable2_0.Owner owner;
    protected boolean orderColumnOrdering = false;
    protected final OrmOrderColumn2_0 orderColumn;

    public GenericOrmOrderable(OrmAttributeMapping parent) {
        this(parent, null);
    }

    public GenericOrmOrderable(OrmAttributeMapping parent, Orderable2_0.Owner owner) {
        super(parent);
        this.owner = owner;
        this.orderColumnOrdering = this.buildOrderColumnOrdering();
        this.orderColumn = this.buildOrderColumn();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedOrderBy_(this.buildSpecifiedOrderBy());
        this.setNoOrdering_(this.buildNoOrdering());
        this.setPkOrdering_(this.buildPkOrdering());
        this.setCustomOrdering_(this.buildCustomOrdering());
        this.setOrderColumnOrdering_(this.buildOrderColumnOrdering());
        if (this.orderColumn != null) {
            this.orderColumn.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.orderColumn != null) {
            this.orderColumn.update();
        }
    }

    @Override
    public String getSpecifiedOrderBy() {
        return this.specifiedOrderBy;
    }

    @Override
    public void setSpecifiedOrderBy(String orderBy) {
        if (orderBy != null) {
            this.setSpecifiedOrderBy_(orderBy);
            this.setNoOrdering_(false);
            this.setPkOrdering_(orderBy.length() == 0);
            this.setCustomOrdering_(orderBy.length() != 0);
            this.setOrderColumnOrdering_(false);
            this.removeXmlOrderColumn();
            this.getXmlOrderable().setOrderBy(orderBy);
        } else {
            this.setNoOrdering(true);
        }
    }

    protected void setSpecifiedOrderBy_(String orderBy) {
        String old = this.specifiedOrderBy;
        this.specifiedOrderBy = orderBy;
        this.firePropertyChanged("specifiedOrderBy", old, orderBy);
    }

    protected String buildSpecifiedOrderBy() {
        if (this.xmlOrderColumnIsPresent()) {
            return null;
        }
        return this.getXmlOrderBy();
    }

    @Override
    public boolean isNoOrdering() {
        return this.noOrdering;
    }

    @Override
    public void setNoOrdering(boolean noOrdering) {
        if (noOrdering) {
            this.setSpecifiedOrderBy_(null);
            this.setNoOrdering_(true);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
            this.setOrderColumnOrdering_(false);
            this.removeXmlOrderColumn();
            this.getXmlOrderable().setOrderBy(null);
        } else {
            this.setPkOrdering(true);
        }
    }

    protected void setNoOrdering_(boolean noOrdering) {
        boolean old = this.noOrdering;
        this.noOrdering = noOrdering;
        this.firePropertyChanged("noOrdering", old, noOrdering);
    }

    protected boolean buildNoOrdering() {
        return this.isJpa2_0Compatible() ? this.buildNoOrdering2_0() : this.buildNoOrdering1_0();
    }

    protected boolean buildNoOrdering2_0() {
        boolean orderColumnPresent;
        boolean orderByMissing = this.getXmlOrderBy() == null;
        boolean orderByPresent = !orderByMissing;
        boolean orderColumnMissing = this.getXmlOrderColumn() == null;
        boolean bl = orderColumnPresent = !orderColumnMissing;
        return orderByMissing && orderColumnMissing || orderByPresent && orderColumnPresent;
    }

    protected boolean buildNoOrdering1_0() {
        return this.getXmlOrderBy() == null;
    }

    @Override
    public boolean isPkOrdering() {
        return this.pkOrdering;
    }

    @Override
    public void setPkOrdering(boolean pkOrdering) {
        if (pkOrdering) {
            this.setSpecifiedOrderBy("");
        } else {
            this.setNoOrdering(true);
        }
    }

    protected void setPkOrdering_(boolean pkOrdering) {
        boolean old = this.pkOrdering;
        this.pkOrdering = pkOrdering;
        this.firePropertyChanged("pkOrdering", old, pkOrdering);
    }

    protected boolean buildPkOrdering() {
        if (this.xmlOrderColumnIsPresent()) {
            return false;
        }
        String xmlOrderBy = this.getXmlOrderBy();
        return xmlOrderBy != null && xmlOrderBy.length() == 0;
    }

    @Override
    public boolean isCustomOrdering() {
        return this.customOrdering;
    }

    @Override
    public void setCustomOrdering(boolean customOrdering) {
        if (customOrdering) {
            this.setSpecifiedOrderBy_("");
            this.setNoOrdering_(false);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(true);
            this.setOrderColumnOrdering_(false);
            this.removeXmlOrderColumn();
            this.getXmlOrderable().setOrderBy("");
        } else {
            this.setNoOrdering(true);
        }
    }

    protected void setCustomOrdering_(boolean customOrdering) {
        boolean old = this.customOrdering;
        this.customOrdering = customOrdering;
        this.firePropertyChanged("customOrdering", old, customOrdering);
    }

    protected boolean buildCustomOrdering() {
        if (this.xmlOrderColumnIsPresent()) {
            return false;
        }
        String xmlOrderBy = this.getXmlOrderBy();
        return xmlOrderBy != null && xmlOrderBy.length() != 0;
    }

    @Override
    public boolean isOrderColumnOrdering() {
        return this.orderColumnOrdering;
    }

    @Override
    public void setOrderColumnOrdering(boolean orderColumnOrdering) {
        if (orderColumnOrdering) {
            this.setSpecifiedOrderBy_(null);
            this.setNoOrdering_(false);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
            this.setOrderColumnOrdering_(true);
            this.getXmlOrderable().setOrderBy(null);
            this.buildXmlOrderColumn();
        } else {
            this.setNoOrdering(true);
        }
    }

    protected void setOrderColumnOrdering_(boolean orderColumnOrdering) {
        boolean old = this.orderColumnOrdering;
        this.orderColumnOrdering = orderColumnOrdering;
        this.firePropertyChanged("orderColumnOrdering", old, orderColumnOrdering);
    }

    protected boolean buildOrderColumnOrdering() {
        return this.xmlOrderColumnIsPresent() && this.getXmlOrderBy() == null;
    }

    @Override
    public OrmOrderColumn2_0 getOrderColumn() {
        return this.orderColumn;
    }

    protected OrmOrderColumn2_0 buildOrderColumn() {
        return this.isOrmXml2_0Compatible() ? this.getContextNodeFactory2_0().buildOrmOrderColumn(this, new OrderColumnOwner()) : null;
    }

    protected String getXmlOrderBy() {
        return this.getXmlOrderable().getOrderBy();
    }

    protected XmlOrderColumn getXmlOrderColumn() {
        return this.getXmlOrderable().getOrderColumn();
    }

    protected boolean xmlOrderColumnIsPresent() {
        return this.isJpa2_0Compatible() && this.getXmlOrderColumn() != null;
    }

    protected XmlOrderColumn buildXmlOrderColumn() {
        XmlOrderColumn xmlColumn = OrmFactory.eINSTANCE.createXmlOrderColumn();
        this.getXmlOrderable().setOrderColumn(xmlColumn);
        return xmlColumn;
    }

    protected void removeXmlOrderColumn() {
        if (this.xmlOrderColumnIsPresent()) {
            this.getXmlOrderable().setOrderColumn(null);
        }
    }

    @Override
    public OrmAttributeMapping getParent() {
        return (OrmAttributeMapping)super.getParent();
    }

    protected OrmAttributeMapping getAttributeMapping() {
        return this.getParent();
    }

    protected OrmPersistentAttribute getPersistentAttribute() {
        return this.getAttributeMapping().getPersistentAttribute();
    }

    protected XmlOrderable getXmlOrderable() {
        return (XmlOrderable)((Object)this.getAttributeMapping().getXmlAttributeMapping());
    }

    @Override
    public String getDefaultTableName() {
        return this.owner.getTableName();
    }

    protected Table resolveDbTable(String tableName) {
        return this.owner.resolveDbTable(tableName);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlOrderable().getValidationTextRange();
        return textRange != null ? textRange : this.getAttributeMapping().getValidationTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.orderColumnOrdering) {
            this.orderColumn.validate(messages, reporter);
        }
    }

    @Override
    public Iterable<String> getXmlCompletionProposals(int pos) {
        Iterable result = super.getXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.orderColumn != null && (result = this.orderColumn.getXmlCompletionProposals(pos)) != null) {
            return result;
        }
        return null;
    }

    protected class OrderColumnOwner
    implements OrmOrderColumn2_0.Owner {
        protected OrderColumnOwner() {
        }

        public String getDefaultTableName() {
            return GenericOrmOrderable.this.getDefaultTableName();
        }

        public Table resolveDbTable(String tableName) {
            return GenericOrmOrderable.this.resolveDbTable(tableName);
        }

        public String getDefaultColumnName(ReadOnlyNamedColumn column) {
            return String.valueOf(this.getPersistentAttribute().getName()) + "_ORDER";
        }

        public TextRange getValidationTextRange() {
            return GenericOrmOrderable.this.getValidationTextRange();
        }

        public JptValidator buildColumnValidator(ReadOnlyNamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return new OrderColumnValidator((ReadOnlyPersistentAttribute)this.getPersistentAttribute(), (OrderColumn2_0)column, textRangeResolver);
        }

        public XmlOrderColumn getXmlColumn() {
            return GenericOrmOrderable.this.getXmlOrderColumn();
        }

        public XmlOrderColumn buildXmlColumn() {
            return GenericOrmOrderable.this.buildXmlOrderColumn();
        }

        public void removeXmlColumn() {
            GenericOrmOrderable.this.removeXmlOrderColumn();
        }

        protected OrmPersistentAttribute getPersistentAttribute() {
            return GenericOrmOrderable.this.getPersistentAttribute();
        }
    }
}

