/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.validation;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.prefs.JpaValidationPreferencesManager;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IProjectValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaValidator
extends AbstractValidator
implements IValidator {
    public void validate(IValidationContext context, IReporter reporter) {
        this.validate(reporter, ((IProjectValidationContext)context).getProject());
    }

    public void cleanup(IReporter reporter) {
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IReporter reporter = result.getReporter(monitor);
        IProject project = resource.getProject();
        result.setSuspendValidation(project);
        this.validate(reporter, project);
        return result;
    }

    private void clearMarkers(IProject project) {
        try {
            this.clearMarkers_(project);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    private void clearMarkers_(IProject project) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = project.findMarkers("org.eclipse.jpt.jpa.core.jpaProblemMarker", true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
    }

    private void validate(IReporter reporter, IProject project) {
        Iterable<IMessage> messages = this.buildValidationMessages(reporter, project);
        this.clearMarkers(project);
        JpaValidationPreferencesManager prefsManager = new JpaValidationPreferencesManager(project);
        for (IMessage message : messages) {
            if (!prefsManager.problemIsNotIgnored(message.getId())) continue;
            reporter.addMessage((IValidator)this, message);
        }
    }

    private Iterable<IMessage> buildValidationMessages(IReporter reporter, IProject project) {
        try {
            return this.buildValidationMessages_(reporter, project);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
    }

    private Iterable<IMessage> buildValidationMessages_(IReporter reporter, IProject project) throws InterruptedException {
        return this.getJpaProjectReference(project).buildValidationMessages(reporter);
    }

    private JpaProject.Reference getJpaProjectReference(IProject project) {
        return (JpaProject.Reference)project.getAdapter(JpaProject.Reference.class);
    }
}

