/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkTransformerAnnotation;

abstract class SourceEclipseLinkTransformerAnnotation
extends SourceAnnotation
implements EclipseLinkTransformerAnnotation {
    final DeclarationAnnotationElementAdapter<String> transformerClassDeclarationAdapter;
    final AnnotationElementAdapter<String> transformerClassAdapter;
    String transformerClass;
    TextRange transformerClassTextRange;
    final DeclarationAnnotationElementAdapter<String> methodDeclarationAdapter;
    final AnnotationElementAdapter<String> methodAdapter;
    String method;
    TextRange methodTextRange;

    SourceEclipseLinkTransformerAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super((JavaResourceNode)parent, element, daa);
        this.transformerClassDeclarationAdapter = new ConversionDeclarationAnnotationElementAdapter(daa, this.getTransformerClassElementName(), SimpleTypeStringExpressionConverter.instance());
        this.transformerClassAdapter = new AnnotatedElementAnnotationElementAdapter(element, this.transformerClassDeclarationAdapter);
        this.methodDeclarationAdapter = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)this.getMethodElementName());
        this.methodAdapter = new AnnotatedElementAnnotationElementAdapter(element, this.methodDeclarationAdapter);
    }

    public void initialize(CompilationUnit astRoot) {
        this.transformerClass = this.buildTransformerClass(astRoot);
        this.transformerClassTextRange = this.buildTransformerClassTextRange(astRoot);
        this.method = this.buildMethod(astRoot);
        this.methodTextRange = this.buildMethodTextRange(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncTransformerClass(this.buildTransformerClass(astRoot));
        this.transformerClassTextRange = this.buildTransformerClassTextRange(astRoot);
        this.syncMethod(this.buildMethod(astRoot));
        this.methodTextRange = this.buildMethodTextRange(astRoot);
    }

    public boolean isUnset() {
        return super.isUnset() && this.transformerClass == null && this.method == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.transformerClass);
    }

    public String getTransformerClass() {
        return this.transformerClass;
    }

    public void setTransformerClass(String transformerClass) {
        if (this.attributeValueHasChanged(this.transformerClass, transformerClass)) {
            this.transformerClass = transformerClass;
            this.transformerClassAdapter.setValue((Object)transformerClass);
        }
    }

    private void syncTransformerClass(String astTransformerClass) {
        String old = this.transformerClass;
        this.transformerClass = astTransformerClass;
        this.firePropertyChanged("transformerClass", old, astTransformerClass);
    }

    private String buildTransformerClass(CompilationUnit astRoot) {
        return (String)this.transformerClassAdapter.getValue(astRoot);
    }

    public TextRange getTransformerClassTextRange() {
        return this.transformerClassTextRange;
    }

    private TextRange buildTransformerClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.transformerClassDeclarationAdapter, astRoot);
    }

    abstract String getTransformerClassElementName();

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        if (this.attributeValueHasChanged(this.method, method)) {
            this.method = method;
            this.methodAdapter.setValue((Object)method);
        }
    }

    private void syncMethod(String astMethod) {
        String old = this.method;
        this.method = astMethod;
        this.firePropertyChanged("method", old, astMethod);
    }

    private String buildMethod(CompilationUnit astRoot) {
        return (String)this.methodAdapter.getValue(astRoot);
    }

    public TextRange getMethodTextRange() {
        return this.methodTextRange;
    }

    private TextRange buildMethodTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.methodDeclarationAdapter, astRoot);
    }

    abstract String getMethodElementName();
}

