/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.resource.orm;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.translators.SimpleTranslator;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.EclipseLinkOrmPackage;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlNamedConverter;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public class XmlTypeConverter
extends XmlNamedConverter {
    protected static final String DATA_TYPE_EDEFAULT = null;
    protected String dataType = DATA_TYPE_EDEFAULT;
    protected static final String OBJECT_TYPE_EDEFAULT = null;
    protected String objectType = OBJECT_TYPE_EDEFAULT;

    protected XmlTypeConverter() {
    }

    protected EClass eStaticClass() {
        return EclipseLinkOrmPackage.Literals.XML_TYPE_CONVERTER;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String newDataType) {
        String oldDataType = this.dataType;
        this.dataType = newDataType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldDataType, (Object)this.dataType));
        }
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String newObjectType) {
        String oldObjectType = this.objectType;
        this.objectType = newObjectType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldObjectType, (Object)this.objectType));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getDataType();
            }
            case 2: {
                return this.getObjectType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setDataType((String)newValue);
                return;
            }
            case 2: {
                this.setObjectType((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setDataType(DATA_TYPE_EDEFAULT);
                return;
            }
            case 2: {
                this.setObjectType(OBJECT_TYPE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return DATA_TYPE_EDEFAULT == null ? this.dataType != null : !DATA_TYPE_EDEFAULT.equals(this.dataType);
            }
            case 2: {
                return OBJECT_TYPE_EDEFAULT == null ? this.objectType != null : !OBJECT_TYPE_EDEFAULT.equals(this.objectType);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (dataType: ");
        result.append(this.dataType);
        result.append(", objectType: ");
        result.append(this.objectType);
        result.append(')');
        return result.toString();
    }

    public static Translator buildTranslator(String elementName, EStructuralFeature structuralFeature) {
        return new SimpleTranslator(elementName, structuralFeature, 8, XmlTypeConverter.buildTranslatorChildren());
    }

    private static Translator[] buildTranslatorChildren() {
        return new Translator[]{XmlTypeConverter.buildNameTranslator(), XmlTypeConverter.buildDataTypeTranslator(), XmlTypeConverter.buildObjectTypeTranslator()};
    }

    protected static Translator buildDataTypeTranslator() {
        return new Translator("data-type", (EStructuralFeature)EclipseLinkOrmPackage.eINSTANCE.getXmlTypeConverter_DataType(), 1);
    }

    protected static Translator buildObjectTypeTranslator() {
        return new Translator("object-type", (EStructuralFeature)EclipseLinkOrmPackage.eINSTANCE.getXmlTypeConverter_ObjectType(), 1);
    }

    public ReplaceEdit createRenameDataTypeEdit(IType originalType, String newName) {
        String originalName = originalType.getTypeQualifiedName();
        int nameIndex = this.dataType.lastIndexOf(originalName);
        int offset = this.getAttributeNode("data-type").getValueRegionStartOffset() + 1;
        return new ReplaceEdit(offset + nameIndex, originalName.length(), newName);
    }

    public ReplaceEdit createRenameDataTypePackageEdit(String newPackageName) {
        int packageLength = this.dataType.lastIndexOf(46);
        if (newPackageName == "") {
            ++packageLength;
        }
        if (packageLength == -1) {
            packageLength = 0;
            newPackageName = String.valueOf(newPackageName) + '.';
        }
        int offset = this.getAttributeNode("data-type").getValueRegionStartOffset() + 1;
        return new ReplaceEdit(offset, packageLength, newPackageName);
    }

    public ReplaceEdit createRenameObjectTypeEdit(IType originalType, String newName) {
        String originalName = originalType.getTypeQualifiedName();
        int nameIndex = this.objectType.lastIndexOf(originalName);
        int offset = this.getAttributeNode("object-type").getValueRegionStartOffset() + 1;
        return new ReplaceEdit(offset + nameIndex, originalName.length(), newName);
    }

    public ReplaceEdit createRenameObjectTypePackageEdit(String newPackageName) {
        int packageLength = this.objectType.lastIndexOf(46);
        if (newPackageName == "") {
            ++packageLength;
        }
        if (packageLength == -1) {
            packageLength = 0;
            newPackageName = String.valueOf(newPackageName) + '.';
        }
        int offset = this.getAttributeNode("object-type").getValueRegionStartOffset() + 1;
        return new ReplaceEdit(offset, packageLength, newPackageName);
    }
}

