/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.relations;

import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;

public class IsARelation {
    protected static final String SEPARATOR = ";isA;";
    public static final String IS_A_CONNECTION_PROP_KEY = "is_is_a_connection";
    protected JavaPersistentType subclass;
    protected JavaPersistentType superclass;

    public IsARelation(JavaPersistentType subclass, JavaPersistentType superclass) {
        this.subclass = subclass;
        this.superclass = superclass;
    }

    public IsARelation(IJPAEditorFeatureProvider fp, Connection conn) {
        Anchor start = conn.getStart();
        Anchor end = conn.getEnd();
        Object startObj = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)start.eContainer()));
        Object endObj = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)end.eContainer()));
        if (startObj == null || endObj == null) {
            throw new NullPointerException("Some of the connection ends is null");
        }
        if (!(startObj instanceof JavaPersistentType) || !(endObj instanceof JavaPersistentType)) {
            throw new IllegalArgumentException();
        }
        this.subclass = (JavaPersistentType)startObj;
        this.superclass = (JavaPersistentType)endObj;
    }

    public JavaPersistentType getSubclass() {
        return this.subclass;
    }

    public JavaPersistentType getSuperclass() {
        return this.superclass;
    }

    public static boolean isIsAConnection(Connection conn) {
        String val = JPAEditorUtil.getPeUtil().getPropertyValue((PropertyContainer)conn, IS_A_CONNECTION_PROP_KEY);
        return Boolean.TRUE.toString().equals(val);
    }

    public String getId() {
        return IsARelation.generateId(this.subclass, this.superclass);
    }

    public static String generateId(IJPAEditorFeatureProvider fp, Connection conn) {
        Anchor start = conn.getStart();
        Anchor end = conn.getEnd();
        Object startObj = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)start.eContainer()));
        Object endObj = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)end.eContainer()));
        if (startObj == null || endObj == null) {
            return null;
        }
        if (!(startObj instanceof JavaPersistentType) || !(endObj instanceof JavaPersistentType)) {
            return null;
        }
        JavaPersistentType startJpt = (JavaPersistentType)startObj;
        JavaPersistentType endJpt = (JavaPersistentType)endObj;
        return IsARelation.generateId(startJpt, endJpt);
    }

    private static String generateId(JavaPersistentType startJpt, JavaPersistentType endJpt) {
        return "is_a_relation:" + startJpt.getName() + SEPARATOR + endJpt.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        if (!(obj instanceof IsARelation)) {
            return false;
        }
        IsARelation rel = (IsARelation)obj;
        return this.getId().equals(rel.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

