/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.MappedByRelationship;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaRelationshipMapping;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaNullTypeMapping;
import org.eclipse.jpt.jpa.core.resource.java.OwnableRelationshipMappingAnnotation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RemoveAndSaveEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPASolver;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.swt.widgets.Display;

public class EntityChangeListener
extends Thread {
    private static final int PAUSE_DURATION = 250;
    private boolean goOn = true;
    private JPASolver solver;
    private IJPAEditorFeatureProvider featureProvider;
    private Set<String> jptsToUpdate = new HashSet<String>();
    private Hashtable<String, PersistenceUnit> attribsToUpdate = new Hashtable();
    public static final String SEPARATOR = ";";

    EntityChangeListener(JPASolver solver) {
        this.solver = solver;
    }

    public void setFeatureProvider(IJPAEditorFeatureProvider featureProvider) {
        this.featureProvider = featureProvider;
    }

    @Override
    public void run() {
        UpdateFromModel taskClass = new UpdateFromModel();
        while (this.goOn) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                JPADiagramEditorPlugin.logError("Thread sleep interruprted", e);
            }
            Display.getDefault().asyncExec((Runnable)taskClass);
        }
        this.solver = null;
        this.featureProvider = null;
    }

    public void stopThread() {
        this.goOn = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJPTForUpdate(String jptName) {
        Set<String> set = this.jptsToUpdate;
        synchronized (set) {
            this.jptsToUpdate.add(jptName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttribForUpdate(PersistenceUnit pu, String entAtMappedBy) {
        Hashtable<String, PersistenceUnit> hashtable = this.attribsToUpdate;
        synchronized (hashtable) {
            this.attribsToUpdate.put(entAtMappedBy, pu);
        }
    }

    private class UpdateFromModel
    implements Runnable {
        private UpdateFromModel() {
        }

        @Override
        public void run() {
            this.exec();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exec() {
            try {
                JavaPersistentType jpt;
                Set set = EntityChangeListener.this.jptsToUpdate;
                synchronized (set) {
                    Iterator itr = EntityChangeListener.this.jptsToUpdate.iterator();
                    if (itr.hasNext()) {
                        String jptName = (String)itr.next();
                        jpt = (JavaPersistentType)EntityChangeListener.this.featureProvider.getBusinessObjectForKey(jptName);
                        try {
                            JpaArtifactFactory.instance().remakeRelations(EntityChangeListener.this.featureProvider, null, jpt);
                            EntityChangeListener.this.jptsToUpdate.remove(jptName);
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                }
                Collection<Object> vals = EntityChangeListener.this.solver.getVisualizedObjects();
                for (Object o : vals) {
                    PersistenceUnit pu;
                    PersistentType pt;
                    if (!(o instanceof JavaPersistentType)) continue;
                    jpt = (JavaPersistentType)o;
                    ContainerShape entShape = (ContainerShape)EntityChangeListener.this.featureProvider.getPictogramElementForBusinessObject(o);
                    if (entShape == null || (pt = (pu = JpaArtifactFactory.instance().getPersistenceUnit(jpt)).getPersistentType(jpt.getName())) != null && JpaArtifactFactory.instance().hasEntityOrMappedSuperclassAnnotation(jpt)) continue;
                    JpaArtifactFactory.instance().forceSaveEntityClass(jpt, EntityChangeListener.this.featureProvider);
                    if ((jpt.getMapping() == null || jpt.getMapping() instanceof JavaNullTypeMapping) && !JptJpaCorePlugin.getDiscoverAnnotatedClasses((IProject)jpt.getJpaProject().getProject())) {
                        JPAEditorUtil.createUnregisterEntityFromXMLJob(jpt.getJpaProject(), jpt.getName());
                    }
                    RemoveContext ctx = new RemoveContext((PictogramElement)entShape);
                    RemoveAndSaveEntityFeature ft = new RemoveAndSaveEntityFeature(EntityChangeListener.this.featureProvider);
                    ft.remove((IRemoveContext)ctx);
                    break;
                }
                Hashtable hashtable = EntityChangeListener.this.attribsToUpdate;
                synchronized (hashtable) {
                    Set atSet = EntityChangeListener.this.attribsToUpdate.keySet();
                    for (String jptAtMB : atSet) {
                        String[] jptAndAttrib = jptAtMB.split(EntityChangeListener.SEPARATOR);
                        PersistenceUnit pu = (PersistenceUnit)EntityChangeListener.this.attribsToUpdate.get(jptAtMB);
                        String entityName = jptAndAttrib[0];
                        String attribName = jptAndAttrib[1];
                        String mappedBy = jptAndAttrib[2];
                        JavaPersistentType jpt2 = (JavaPersistentType)pu.getPersistentType(entityName);
                        if (jpt2 == null) continue;
                        JavaPersistentAttribute jpa = jpt2.getAttributeNamed(attribName);
                        JpaArtifactFactory.instance().refreshEntityModel(null, jpt2);
                        if (jpa == null) continue;
                        JavaAttributeMapping mapping = jpa.getMapping();
                        Annotation a = mapping.getMappingAnnotation();
                        if (a == null) {
                            JpaArtifactFactory.instance().refreshEntityModel(EntityChangeListener.this.featureProvider, jpt2);
                            mapping = jpa.getMapping();
                            a = mapping.getMappingAnnotation();
                        }
                        if (a == null) {
                            return;
                        }
                        if (!OwnableRelationshipMappingAnnotation.class.isInstance(mapping.getMappingAnnotation())) continue;
                        JavaRelationshipMapping relationshipMapping = (JavaRelationshipMapping)mapping;
                        MappedByRelationship ownableRef = (MappedByRelationship)relationshipMapping.getRelationship();
                        if (!ownableRef.strategyIsMappedBy()) {
                            ownableRef.setStrategyToMappedBy();
                        }
                        ownableRef.getMappedByStrategy().setMappedByAttribute(mappedBy);
                        EntityChangeListener.this.attribsToUpdate.remove(jptAtMB);
                    }
                }
            }
            catch (Exception exception) {}
        }
    }
}

