/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import ch.qos.logback.core.FileAppender;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.SendServerLogMessage;
import org.eclipse.jubula.communication.message.ServerLogResponseMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendServerLogCommand
implements ICommand {
    private static Logger log = LoggerFactory.getLogger(SendServerLogCommand.class);
    private SendServerLogMessage m_message;

    public Message execute() {
        log.info("sending server log");
        ServerLogResponseMessage response = new ServerLogResponseMessage();
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        Iterator appenders = logger.iteratorForAppenders();
        FileAppender fileAppender = null;
        while (appenders.hasNext() && fileAppender == null) {
            Object enumElement = appenders.next();
            if (!(enumElement instanceof FileAppender)) continue;
            fileAppender = (FileAppender)enumElement;
        }
        if (fileAppender != null) {
            File clientLogFile = new File(fileAppender.getFile());
            try {
                BufferedReader reader = new BufferedReader(new FileReader(clientLogFile));
                StringBuffer sb = new StringBuffer();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(String.valueOf(line) + "\n");
                }
                response.setServerLog(sb.toString());
            }
            catch (FileNotFoundException fileNotFoundException) {
                response.setStatus(2);
            }
            catch (IOException iOException) {
                response.setStatus(3);
            }
            catch (SecurityException securityException) {
                response.setStatus(4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                response.setStatus(4);
            }
        } else {
            response.setStatus(1);
        }
        return response;
    }

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (SendServerLogMessage)message;
    }

    public void timeout() {
        log.error(String.valueOf(this.getClass().getName()) + ".timeout() called");
    }
}

