/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.analyze;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jubula.client.analyze.internal.Analyze;
import org.eclipse.jubula.client.analyze.internal.AnalyzeParameter;
import org.eclipse.jubula.client.analyze.internal.Category;
import org.eclipse.jubula.client.analyze.internal.Context;
import org.eclipse.jubula.client.analyze.internal.Renderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionRegistry {
    private static Logger log = LoggerFactory.getLogger(ExtensionRegistry.class);
    private static ExtensionRegistry plugin;
    private static HashMap<String, Analyze> analyzeMap;
    private static HashMap<String, Renderer> rendererMap;
    private static HashMap<String, Category> categoryMap;
    private static HashMap<String, Context> contextMap;

    static {
        analyzeMap = new HashMap();
        rendererMap = new HashMap();
        categoryMap = new HashMap();
        contextMap = new HashMap();
    }

    private ExtensionRegistry() {
    }

    public static Map<String, Analyze> getAnalyze() {
        return Collections.unmodifiableMap(analyzeMap);
    }

    public static Map<String, Renderer> getRenderer() {
        return Collections.unmodifiableMap(rendererMap);
    }

    public static Map<String, Category> getCategory() {
        return Collections.unmodifiableMap(categoryMap);
    }

    public static Map<String, Context> getContexts() {
        return Collections.unmodifiableMap(contextMap);
    }

    public static ExtensionRegistry getInstance() {
        if (plugin == null) {
            plugin = new ExtensionRegistry();
        }
        return plugin;
    }

    private static IExtension[] getExtensions() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.jubula.client.analyze.definition");
        return extensionPoint.getExtensions();
    }

    private static void initializeAnalyze() {
        IExtension[] iExtensionArray = ExtensionRegistry.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement analyze = iConfigurationElementArray[n4];
                if ("Analyze".equals(analyze.getName())) {
                    ExtensionRegistry.handleAnalyze(analyze);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void initializeResultRenderer() {
        IExtension[] iExtensionArray = ExtensionRegistry.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement renderer = iConfigurationElementArray[n4];
                if ("ResultRenderer".equals(renderer.getName())) {
                    ExtensionRegistry.handleResultRenderer(renderer);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void initializeCategories() {
        IExtension[] iExtensionArray = ExtensionRegistry.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement category = iConfigurationElementArray[n4];
                if ("Category".equals(category.getName())) {
                    ExtensionRegistry.handleCategories(category);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void initializeContexts() {
        IExtension[] iExtensionArray = ExtensionRegistry.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement context = iConfigurationElementArray[n4];
                if ("Context".equals(context.getName())) {
                    ExtensionRegistry.handleContexts(context);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void handleAnalyze(IConfigurationElement analyzeConfig) {
        try {
            ArrayList<AnalyzeParameter> parameterList = new ArrayList<AnalyzeParameter>();
            IConfigurationElement[] iConfigurationElementArray = analyzeConfig.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement param = iConfigurationElementArray[n2];
                AnalyzeParameter anaParam = new AnalyzeParameter(param.getAttribute("id"), param.getAttribute("defaultValue"), param.getAttribute("name"), param.getAttribute("description"), "");
                parameterList.add(anaParam);
                ++n2;
            }
            Analyze ana = new Analyze(analyzeConfig.getAttribute("id"), analyzeConfig.getAttribute("name"), analyzeConfig.getAttribute("class"), analyzeConfig.getAttribute("CategoryID"), analyzeConfig.getAttribute("ContextType"), analyzeConfig.getAttribute("ResultType"));
            ana.setExecutableExtension(analyzeConfig.createExecutableExtension("class"));
            ana.setAnalyzeParameter(parameterList);
            analyzeMap.put(analyzeConfig.getAttribute("id"), ana);
        }
        catch (CoreException e) {
            log.error("An error occured: ", (Throwable)e);
        }
    }

    private static void handleResultRenderer(IConfigurationElement rendererConfig) {
        try {
            Renderer renderer = new Renderer(rendererConfig.getAttribute("id"), rendererConfig.getAttribute("rendererClass"), rendererConfig.getAttribute("ResultType"), rendererConfig.createExecutableExtension("rendererClass"));
            rendererMap.put(rendererConfig.getAttribute("id"), renderer);
        }
        catch (CoreException e) {
            log.error("An error occured: ", (Throwable)e);
        }
    }

    private static void handleCategories(IConfigurationElement categoryConfig) {
        Category category = new Category(categoryConfig.getAttribute("id"), categoryConfig.getAttribute("name"), categoryConfig.getAttribute("categoryid"));
        categoryMap.put(categoryConfig.getAttribute("id"), category);
    }

    private static void handleContexts(IConfigurationElement contextConfig) {
        try {
            Context context = new Context(contextConfig.getAttribute("id"), contextConfig.getAttribute("name"), contextConfig.createExecutableExtension("class"));
            contextMap.put(contextConfig.getAttribute("id"), context);
        }
        catch (CoreException e) {
            log.error("An error occured: ", (Throwable)e);
        }
    }

    public void start() {
        ExtensionRegistry.initializeAnalyze();
        ExtensionRegistry.initializeResultRenderer();
        ExtensionRegistry.initializeCategories();
        ExtensionRegistry.initializeContexts();
    }
}

