/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive.businessprocess;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.archive.XmlStorage;
import org.eclipse.jubula.client.archive.errorhandling.IProjectNameConflictResolver;
import org.eclipse.jubula.client.archive.errorhandling.NullProjectNameConflictResolver;
import org.eclipse.jubula.client.archive.i18n.Messages;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesDecorator;
import org.eclipse.jubula.client.core.businessprocess.INameMapper;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.ProjectComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.businessprocess.progress.ProgressMonitorTracker;
import org.eclipse.jubula.client.core.errorhandling.ErrorMessagePresenter;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.utils.ToolkitUtils;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.exception.GDConfigXmlException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.JBVersionException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.jarutils.IVersion;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.xml.businessmodell.ToolkitPluginDescriptor;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStorageBP {
    public static final Logger LOG = LoggerFactory.getLogger(FileStorageBP.class);
    public static final int IMPORT_ALL = 0;
    public static final int IMPORT_TESTCASES = 1;
    private static final int TOTAL_IMPORT_WORK = 100;
    private static final int NUM_HBM_PROGRESS_EVENT_TYPES = 4;
    private static final int PARSE_FILES_WORK = 15;
    private static final int SAVE_TO_DB_WORK = 85;
    private static IProjectNameConflictResolver projectNameConflictResolver = new NullProjectNameConflictResolver();

    private FileStorageBP() {
    }

    public static void exportProjectList(List<IProjectPO> projectList, String exportDirName, EntityManager exportSession, IProgressMonitor monitor, boolean writeToSystemTempDir, List<File> listOfProjectFiles, IProgressConsole console) throws JBException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ExportAllBPExporting, (int)XmlStorage.getWorkToSave(projectList));
        for (IProjectPO proj : projectList) {
            String exportFileName;
            if (subMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            IProjectPO projectToExport = ProjectPM.loadProjectById((Long)proj.getId(), (EntityManager)exportSession);
            String projectFileName = String.valueOf(projectToExport.getDisplayName()) + ".xml";
            if (writeToSystemTempDir) {
                exportFileName = projectFileName;
            } else {
                if (projectToExport.equals((Object)GeneralStorage.getInstance().getProject())) {
                    projectToExport = GeneralStorage.getInstance().getProject();
                }
                exportFileName = String.valueOf(exportDirName) + projectFileName;
            }
            if (subMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            console.writeLine(NLS.bind((String)Messages.ExportAllBPInfoStartingExportProject, (Object[])new Object[]{projectFileName}));
            try {
                if (subMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                XmlStorage.save(projectToExport, exportFileName, true, (IProgressMonitor)subMonitor.newChild(XmlStorage.getWorkToSave(projectToExport)), writeToSystemTempDir, listOfProjectFiles);
                if (subMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                console.writeLine(NLS.bind((String)Messages.ExportAllBPInfoFinishedExportProject, (Object[])new Object[]{projectFileName}));
            }
            catch (PMSaveException e) {
                LOG.error(Messages.CouldNotExportProject, (Throwable)e);
                console.writeErrorLine(NLS.bind((String)Messages.ExportAllBPErrorExportFailedProject, (Object[])new Object[]{projectFileName, e.getMessage()}));
            }
            exportSession.detach((Object)projectToExport);
        }
    }

    public static void importFiles(List<URL> importProjectURLs, IProgressMonitor monitor, IProgressConsole console, boolean openProject) throws PMException, ProjectDeletedException {
        try {
            FileStorageBP.doImport(0, importProjectURLs, SubMonitor.convert((IProgressMonitor)monitor), console, openProject);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static IProjectPO importProject(int elements, List<URL> fileURLs, IProgressMonitor monitor, IProgressConsole console, boolean openProject) throws InterruptedException, PMException, ProjectDeletedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ImportFileBPImporting, (int)100);
        return FileStorageBP.doImport(elements, fileURLs, subMonitor, console, openProject);
    }

    private static IProjectPO doImport(int elements, List<URL> fileURLs, SubMonitor subMonitor, IProgressConsole console, boolean openProject) throws InterruptedException, PMException, ProjectDeletedException {
        ReadFilesOperation readFilesOp = new ReadFilesOperation(elements == 0, fileURLs, console);
        readFilesOp.run((IProgressMonitor)subMonitor.newChild(15));
        ImportOperation importOp = new ImportOperation(elements, readFilesOp.getProjectToMapperMap(), readFilesOp.getProjectToCompCacheMap(), console, openProject);
        try {
            importOp.run((IProgressMonitor)subMonitor.newChild(85));
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)ite);
            if (cause instanceof PMException) {
                throw (PMException)cause;
            }
            if (cause instanceof ProjectDeletedException) {
                throw (ProjectDeletedException)cause;
            }
            throw new RuntimeException(ite);
        }
        return importOp.getProjectToOpen();
    }

    private static void showAbortImport(IProgressConsole console, Exception e) {
        console.writeErrorLine(NLS.bind((String)Messages.ImportFileActionErrorImportFailed, (Object[])new Object[]{e.getMessage()}));
    }

    private static void showErrorDuringImport(IProgressConsole console, String projectFileName, Exception e) {
        console.writeErrorLine(NLS.bind((String)Messages.ImportFileActionErrorImportFailedProject, (Object[])new Object[]{projectFileName, e.getMessage()}));
    }

    private static void showFinishedImport(IProgressConsole console) {
        console.writeLine(Messages.ImportFileActionInfoFinishedImport);
    }

    private static void showFinishedImport(IProgressConsole console, String projectFileName) {
        console.writeLine(NLS.bind((String)Messages.ImportFileActionInfoFinishedImportProject, (Object[])new Object[]{projectFileName}));
    }

    private static void showFinishedReadingProjects(IProgressConsole console) {
        console.writeLine(Messages.ImportFileActionInfoFinishedReadingProjects);
    }

    private static void showIncompatibleToolkit(IProgressConsole console, String projectName, String currentToolkit, String importedToolkit) {
        console.writeErrorLine(NLS.bind((String)Messages.ImportFileActionErrorIncompatibleToolkits, (Object[])new Object[]{projectName, importedToolkit, currentToolkit}));
    }

    private static void showStartingImport(IProgressConsole console) {
        console.writeLine(Messages.ImportFileActionInfoStartingImport);
    }

    private static void showStartingImport(IProgressConsole console, String projectFileName) {
        console.writeLine(NLS.bind((String)Messages.ImportFileActionInfoStartingImportProject, (Object[])new Object[]{projectFileName}));
    }

    private static void showStartingReadingProjects(IProgressConsole console) {
        console.writeLine(Messages.ImportFileActionInfoStartingReadingProjects);
    }

    public static void setProjectNameConflictResolver(IProjectNameConflictResolver resolver) {
        Validate.notNull((Object)resolver);
        projectNameConflictResolver = resolver;
    }

    private static void handlePMReadException(PMReadException e, List<URL> fileURLs) {
        ErrorMessagePresenter.getPresenter().showErrorMessage(new JBException((Object)((Object)e) + Messages.Reading + fileURLs.toArray() + Messages.Failed, MessageIDs.E_IMPORT_PROJECT_XML_FAILED), null, MessageIDs.getMessageObject((Integer)e.getErrorId()).getDetails());
    }

    private static void handleCapDataNotFound(GDConfigXmlException ce) {
        ErrorMessagePresenter.getPresenter().showErrorMessage(MessageIDs.E_IMPORT_PROJECT_CONFIG_CONFLICT, null, new String[]{ce.getMessage()});
    }

    static /* synthetic */ void access$0(IProgressConsole iProgressConsole) {
        FileStorageBP.showStartingImport(iProgressConsole);
    }

    static /* synthetic */ void access$1(IProgressConsole iProgressConsole) {
        FileStorageBP.showStartingReadingProjects(iProgressConsole);
    }

    static /* synthetic */ void access$2(IProgressConsole iProgressConsole) {
        FileStorageBP.showFinishedReadingProjects(iProgressConsole);
    }

    static /* synthetic */ void access$3(PMReadException pMReadException, List list) {
        FileStorageBP.handlePMReadException(pMReadException, list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompleteImportOperation
    implements IRunnableWithProgress {
        private Map<IProjectPO, List<INameMapper>> m_projectToMapperMap;
        private Map<IProjectPO, List<IWritableComponentNameMapper>> m_projectToCompCacheMap;
        private boolean m_isRefreshRequired = false;
        private boolean m_wasImportSuccessful = false;
        private IProgressConsole m_console;

        public CompleteImportOperation(Map<IProjectPO, List<INameMapper>> projectToMapperMap, Map<IProjectPO, List<IWritableComponentNameMapper>> projectToCompCacheMap, IProgressConsole console) {
            this.m_projectToMapperMap = projectToMapperMap;
            this.m_projectToCompCacheMap = projectToCompCacheMap;
            this.m_console = console;
        }

        public void run(IProgressMonitor monitor) throws InterruptedException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ImportFileBPImporting, (int)this.m_projectToMapperMap.size());
            if (this.checkImportProblems()) {
                return;
            }
            for (IProjectPO proj : this.m_projectToMapperMap.keySet()) {
                JBException gde;
                if (subMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                String projectName = proj.getDisplayName();
                FileStorageBP.showStartingImport(this.m_console, projectName);
                try {
                    this.m_wasImportSuccessful = this.importProject(proj, (IProgressMonitor)subMonitor.newChild(1));
                    FileStorageBP.showFinishedImport(this.m_console, projectName);
                }
                catch (PMSaveException e) {
                    LOG.warn(Messages.ErrorWhileImportingProject, (Throwable)e);
                    gde = new JBException((Object)((Object)e) + " " + ":" + Messages.SaveOf + proj.getName() + " " + Messages.Failed, MessageIDs.E_IMPORT_PROJECT_XML_FAILED);
                    FileStorageBP.showErrorDuringImport(this.m_console, projectName, (Exception)gde);
                    ErrorMessagePresenter.getPresenter().showErrorMessage(gde, (Object[])new String[]{proj.getName()}, null);
                }
                catch (PMException pme) {
                    LOG.warn(Messages.ErrorWhileImportingProject, (Throwable)pme);
                    gde = new JBException((Object)((Object)pme) + Messages.ImportOf + proj.getName() + " " + Messages.Failed, MessageIDs.E_IMPORT_PROJECT_XML_FAILED);
                    FileStorageBP.showErrorDuringImport(this.m_console, projectName, (Exception)gde);
                    ErrorMessagePresenter.getPresenter().showErrorMessage(gde, (Object[])new String[]{proj.getName()}, null);
                }
                catch (ProjectDeletedException e) {
                    gde = new JBException((Object)((Object)e) + Messages.ImportOf + proj.getName() + " " + Messages.Failed, MessageIDs.E_ALREADY_DELETED_PROJECT);
                    FileStorageBP.showErrorDuringImport(this.m_console, projectName, (Exception)gde);
                    ErrorMessagePresenter.getPresenter().showErrorMessage(gde, (Object[])new String[]{proj.getName()}, null);
                }
            }
            FileStorageBP.showFinishedImport(this.m_console);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean checkImportProblems() {
            HashMap<String, String> guidToNameMap = new HashMap<String, String>();
            if (this.checkImportedProjects(guidToNameMap)) {
                return true;
            }
            EntityManager circularDependencyCheckSess = Persistor.instance().openSession();
            try {
                if (this.checkNameGuidConflict(guidToNameMap)) {
                    return true;
                }
                try {
                    if (!this.checkCircularDependencies(circularDependencyCheckSess)) return false;
                    return true;
                }
                catch (PMException pme) {
                    ErrorMessagePresenter.getPresenter().showErrorMessage(new JBException((Object)((Object)pme) + Messages.ImportFailed, MessageIDs.E_DATABASE_GENERAL), null, null);
                    return true;
                }
            }
            finally {
                Persistor.instance().dropSessionWithoutLockRelease(circularDependencyCheckSess);
            }
        }

        private boolean checkCircularDependencies(EntityManager circularDependencyCheckSess) {
            for (IProjectPO proj : this.m_projectToMapperMap.keySet()) {
                HashSet checkedProjects = new HashSet();
                HashSet<IProjectPO> illegalProjects = new HashSet<IProjectPO>();
                illegalProjects.add(proj);
                HashSet<IProjectPO> projectsToCheck = new HashSet<IProjectPO>();
                for (IReusedProjectPO reused : proj.getUsedProjects()) {
                    IProjectPO reusedProject = null;
                    for (IProjectPO importedProject : this.m_projectToMapperMap.keySet()) {
                        if (!reused.getProjectGuid().equals(importedProject.getGuid()) || !reused.getMajorNumber().equals(importedProject.getMajorProjectVersion()) || !reused.getMinorNumber().equals(importedProject.getMinorProjectVersion())) continue;
                        reusedProject = importedProject;
                        break;
                    }
                    if (reusedProject == null) {
                        try {
                            reusedProject = ProjectPM.loadReusedProject((IReusedProjectPO)reused, (EntityManager)circularDependencyCheckSess);
                        }
                        catch (JBException jBException) {
                            this.handleCircularDependency(this.m_console, proj.getName());
                            return true;
                        }
                    }
                    if (reusedProject == null) continue;
                    projectsToCheck.add(reusedProject);
                }
                for (IProjectPO projToCheck : projectsToCheck) {
                    ProjectPM.findIllegalProjects((IProjectPO)projToCheck, checkedProjects, illegalProjects, this.m_projectToMapperMap.keySet());
                }
                illegalProjects.remove(proj);
                if (illegalProjects.isEmpty()) continue;
                this.handleCircularDependency(this.m_console, proj.getName());
                return true;
            }
            return false;
        }

        public boolean wasImportSuccessful() {
            return this.m_wasImportSuccessful;
        }

        private boolean importProject(IProjectPO proj, IProgressMonitor monitor) throws PMException, ProjectDeletedException, InterruptedException {
            if (this.projectExists(proj.getGuid(), proj.getMajorProjectVersion(), proj.getMinorProjectVersion())) {
                String projectNameToImport = proj.getName();
                this.handleProjectExists(this.m_console, ProjectNameBP.getInstance().getName(proj.getGuid(), false), projectNameToImport, proj.getMajorProjectVersion(), proj.getMinorProjectVersion());
                return false;
            }
            String selectedProjectName = this.checkProjectAndRename(proj.getGuid(), proj.getName());
            if (selectedProjectName != null) {
                proj.setClientMetaDataVersion(IVersion.JB_CLIENT_METADATA_VERSION);
                boolean willRequireRefresh = false;
                IProjectPO currentProject = GeneralStorage.getInstance().getProject();
                if (currentProject != null) {
                    for (IReusedProjectPO reused : currentProject.getUsedProjects()) {
                        if (this.m_isRefreshRequired || willRequireRefresh) break;
                        String guid = reused.getProjectGuid();
                        Integer majorVersion = reused.getMajorNumber();
                        Integer minorVersion = reused.getMinorNumber();
                        boolean bl = willRequireRefresh = proj.getGuid().equals(guid) && proj.getMajorProjectVersion().equals(majorVersion) && proj.getMinorProjectVersion().equals(minorVersion);
                    }
                    this.m_isRefreshRequired = willRequireRefresh || this.m_isRefreshRequired;
                }
                ProgressMonitorTracker.getInstance().setProgressMonitor(monitor);
                monitor.beginTask("", this.getTotalWork(proj));
                List<INameMapper> mapperList = this.m_projectToMapperMap.get(proj);
                List<IWritableComponentNameMapper> compNameBindingList = this.m_projectToCompCacheMap.get(proj);
                try {
                    ProjectPM.saveProject((IProjectPO)proj, (String)selectedProjectName, mapperList, compNameBindingList);
                }
                finally {
                    ProgressMonitorTracker.getInstance().setProgressMonitor(null);
                }
                UsedToolkitBP.getInstance().refreshToolkitInfo(proj);
                return true;
            }
            return false;
        }

        private int getTotalWork(IProjectPO proj) {
            int totalWork = 1;
            for (ITestSuitePO testSuite : TestSuiteBP.getListOfTestSuites((IProjectPO)proj)) {
                totalWork += this.getWorkForNode((INodePO)testSuite);
            }
            for (ISpecPersistable spec : proj.getSpecObjCont().getSpecObjList()) {
                totalWork += this.getWorkForNode((INodePO)spec);
            }
            return totalWork *= 4;
        }

        private int getWorkForNode(INodePO node) {
            int work = 1;
            if (!(node instanceof IExecTestCasePO)) {
                Iterator childIter = node.getNodeListIterator();
                while (childIter.hasNext()) {
                    work += this.getWorkForNode((INodePO)childIter.next());
                }
            }
            if (node instanceof ISpecTestCasePO) {
                work += ((ISpecTestCasePO)node).getAllEventEventExecTC().size();
            }
            return work;
        }

        private boolean checkImportedProjects(Map<String, String> guidToNameMap) {
            for (IProjectPO proj : this.m_projectToMapperMap.keySet()) {
                String projectName = proj.getName();
                String guid = proj.getGuid();
                Validate.notNull((Object)projectName, (String)Messages.ImportWithoutName);
                Validate.notEmpty((String)projectName, (String)Messages.ImportEmptyName);
                if (this.isSameGuidOtherName(guidToNameMap, projectName, guid)) {
                    this.handleGuidConflict(projectName, guidToNameMap.get(guid));
                    return true;
                }
                if (this.isOtherGuidSameName(guidToNameMap, projectName, guid)) {
                    this.handleNameConflict(projectName);
                    return true;
                }
                guidToNameMap.put(guid, projectName);
            }
            return false;
        }

        private boolean isOtherGuidSameName(Map<String, String> guidToNameMap, String projectName, String guid) {
            return guidToNameMap.containsValue(projectName) && !projectName.equals(guidToNameMap.get(guid));
        }

        private boolean isSameGuidOtherName(Map<String, String> guidToNameMap, String projectName, String guid) {
            return guidToNameMap.containsKey(guid) && !projectName.equals(guidToNameMap.get(guid));
        }

        private void handleNameConflict(String name) {
            ErrorMessagePresenter.getPresenter().showErrorMessage(MessageIDs.E_PROJ_NAME_CONFLICT, (Object[])new String[0], new String[]{name});
        }

        private void handleCircularDependency(IProgressConsole console, String name) {
            console.writeErrorLine(NLS.bind((String)Messages.ErrorMessagePROJ_CIRC_DEPEND, (Object)name));
            ErrorMessagePresenter.getPresenter().showErrorMessage(MessageIDs.E_PROJ_CIRC_DEPEND, (Object[])new String[]{name}, null);
        }

        private String checkProjectAndRename(String guid, String projectName) {
            String selectedName = projectName;
            String existingNameForGuid = ProjectNameBP.getInstance().getName(guid);
            if (existingNameForGuid != null && !existingNameForGuid.equals(projectName)) {
                if (ProjectPM.doesProjectNameExist((String)projectName)) {
                    ArrayList<String> possibleNames = new ArrayList<String>(1);
                    possibleNames.add(existingNameForGuid);
                    selectedName = projectNameConflictResolver.resolveNameConflict(possibleNames);
                } else {
                    String[] possibleNames = new String[]{existingNameForGuid, projectName};
                    selectedName = projectNameConflictResolver.resolveNameConflict(Arrays.asList(possibleNames));
                }
            } else if (ProjectPM.doesProjectNameExist((String)projectName) && !projectName.equals(existingNameForGuid)) {
                ArrayList<String> possibleNames = new ArrayList<String>(1);
                possibleNames.add(existingNameForGuid);
                selectedName = projectNameConflictResolver.resolveNameConflict(possibleNames);
            }
            return selectedName;
        }

        private boolean checkNameGuidConflict(Map<String, String> guidToNameMap) throws PMException {
            Map dbGuidToNameMap = ProjectNameBP.getInstance().readAllProjectNamesFromDB();
            for (String guid : guidToNameMap.keySet()) {
                if (this.isOtherGuidSameName(dbGuidToNameMap, guidToNameMap.get(guid), guid)) {
                    this.handleNameConflict(guidToNameMap.get(guid));
                    return true;
                }
                if (!this.isSameGuidOtherName(dbGuidToNameMap, guid, guidToNameMap.get(guid))) continue;
                this.handleGuidConflict(guidToNameMap.get(guid), (String)dbGuidToNameMap.get(guid));
                return true;
            }
            return false;
        }

        private void handleGuidConflict(String importName, String existingName) {
            ErrorMessagePresenter.getPresenter().showErrorMessage(MessageIDs.E_PROJ_GUID_CONFLICT, (Object[])new String[0], new String[]{importName, existingName});
        }

        private boolean projectExists(String guid, Integer majorNumber, Integer minorNumber) {
            return ProjectPM.doesProjectVersionExist((String)guid, (Integer)majorNumber, (Integer)minorNumber);
        }

        private void handleProjectExists(IProgressConsole console, String existingName, String importName, Integer majNum, Integer minNum) {
            console.writeErrorLine(NLS.bind((String)Messages.ErrorMessageIMPORT_PROJECT_XML_FAILED, (Object[])new String[]{importName}));
            console.writeErrorLine(NLS.bind((String)Messages.ErrorMessageIMPORT_PROJECT_XML_FAILED_EXISTING, (Object[])new String[]{existingName, String.valueOf(majNum), String.valueOf(minNum)}));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImportOperation
    implements IRunnableWithProgress {
        private int m_elements;
        private Map<IProjectPO, List<INameMapper>> m_projectToMapperMap;
        private Map<IProjectPO, List<IWritableComponentNameMapper>> m_projectToCompCacheMap;
        private IProjectPO m_projectToOpen = null;
        private IProgressConsole m_console;
        private boolean m_isOpenProject;

        public ImportOperation(int elements, Map<IProjectPO, List<INameMapper>> projectToMapperMap, Map<IProjectPO, List<IWritableComponentNameMapper>> projectToCompCacheMap, IProgressConsole console, boolean openProject) {
            this.m_elements = elements;
            this.m_projectToMapperMap = projectToMapperMap;
            this.m_projectToCompCacheMap = projectToCompCacheMap;
            this.m_console = console;
            this.m_isOpenProject = openProject;
        }

        public IProjectPO getProjectToOpen() {
            return this.m_projectToOpen;
        }

        public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
            block7: {
                try {
                    try {
                        NodePM.getInstance().setUseCache(true);
                        if (this.m_elements == 0) {
                            Iterator<IProjectPO> iterator;
                            CompleteImportOperation op = new CompleteImportOperation(this.m_projectToMapperMap, this.m_projectToCompCacheMap, this.m_console);
                            op.run(monitor);
                            if (op.wasImportSuccessful() && this.m_isOpenProject && (iterator = this.m_projectToMapperMap.keySet().iterator()).hasNext()) {
                                IProjectPO project;
                                this.m_projectToOpen = project = iterator.next();
                            }
                            break block7;
                        }
                        new PartsImportOperation(this.m_projectToMapperMap, this.m_projectToCompCacheMap, this.m_elements, this.m_console).run(monitor);
                    }
                    catch (GDConfigXmlException ce) {
                        FileStorageBP.handleCapDataNotFound(ce);
                        NodePM.getInstance().setUseCache(false);
                        monitor.done();
                    }
                }
                finally {
                    NodePM.getInstance().setUseCache(false);
                    monitor.done();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PartsImportOperation
    implements IRunnableWithProgress {
        private int m_elements;
        private Map<IProjectPO, List<INameMapper>> m_projectToMapperMap;
        private Map<IProjectPO, List<IWritableComponentNameMapper>> m_projectToCompCacheMap;
        private IProgressConsole m_console;

        public PartsImportOperation(Map<IProjectPO, List<INameMapper>> projectToMapperMap, Map<IProjectPO, List<IWritableComponentNameMapper>> projectToCompMapperMap, int elements, IProgressConsole console) {
            this.m_projectToMapperMap = projectToMapperMap;
            this.m_projectToCompCacheMap = projectToCompMapperMap;
            this.m_elements = elements;
            this.m_console = console;
        }

        public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ImportFileBPImporting, (int)this.m_projectToMapperMap.size());
            try {
                try {
                    for (IProjectPO proj : this.m_projectToMapperMap.keySet()) {
                        if (subMonitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        if ((this.m_elements & 1) != 1) continue;
                        List<INameMapper> mapperList = this.m_projectToMapperMap.get(proj);
                        List<IWritableComponentNameMapper> compMapperList = this.m_projectToCompCacheMap.get(proj);
                        String projectName = proj.getDisplayName();
                        FileStorageBP.showStartingImport(this.m_console, projectName);
                        List specObjList = proj.getSpecObjCont().getSpecObjList();
                        IProjectPO project = GeneralStorage.getInstance().getProject();
                        String importedToolkit = proj.getToolkit();
                        try {
                            String importedLevel = ToolkitSupportBP.getToolkitLevel((String)importedToolkit);
                            String currentToolkit = project.getToolkit();
                            String currentLevel = project.getToolkitLevel();
                            this.tryImport(subMonitor, mapperList, compMapperList, projectName, specObjList, project, importedToolkit, importedLevel, currentToolkit, currentLevel);
                        }
                        catch (ToolkitPluginException e) {
                            FileStorageBP.showErrorDuringImport(this.m_console, proj.getDisplayName(), (Exception)((Object)e));
                        }
                        catch (IncompatibleTypeException ite) {
                            ErrorMessagePresenter.getPresenter().showErrorMessage((JBException)((Object)ite), (Object[])ite.getErrorMessageParams(), null);
                        }
                    }
                }
                catch (PMException e) {
                    FileStorageBP.showAbortImport(this.m_console, (Exception)((Object)e));
                    throw new InvocationTargetException(e);
                }
                catch (ProjectDeletedException e) {
                    FileStorageBP.showAbortImport(this.m_console, (Exception)((Object)e));
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                ProjectNameBP.getInstance().clearCache();
            }
            FileStorageBP.showFinishedImport(this.m_console);
        }

        private void tryImport(SubMonitor subMonitor, List<INameMapper> mapperList, List<IWritableComponentNameMapper> compMapperList, String projectName, List<ISpecPersistable> specObjList, IProjectPO project, String importedToolkit, String importedLevel, String currentToolkit, String currentLevel) throws PMException, ProjectDeletedException, InterruptedException, IncompatibleTypeException, ToolkitPluginException {
            if (this.isToolkitCompatible(importedToolkit, importedLevel, currentToolkit, currentLevel)) {
                for (IWritableComponentNameMapper compMapper : compMapperList) {
                    for (IComponentNamePO added : compMapper.getCompNameCache().getNewNames()) {
                        boolean nameExists = ComponentNamesBP.getInstance().getGuidForName(added.getName(), project.getId()) != null;
                        int counter = 0;
                        while (nameExists) {
                            boolean bl = nameExists = ComponentNamesBP.getInstance().getGuidForName(String.valueOf(added.getName()) + ++counter, project.getId()) != null;
                        }
                        if (counter == 0) continue;
                        added.setName(String.valueOf(added.getName()) + counter);
                    }
                }
                this.importTestCases(mapperList, compMapperList, specObjList, project, (IProgressMonitor)subMonitor.newChild(1));
                FileStorageBP.showFinishedImport(this.m_console, projectName);
            } else {
                String currentToolkitName = this.getToolkitName(currentToolkit);
                String importedToolkitName = this.getToolkitName(importedToolkit);
                FileStorageBP.showIncompatibleToolkit(this.m_console, projectName, currentToolkitName, importedToolkitName);
            }
        }

        private String getToolkitName(String toolkitId) throws ToolkitPluginException {
            CompSystem compSys = ComponentBuilder.getInstance().getCompSystem();
            ToolkitPluginDescriptor desc = compSys.getToolkitPluginDescriptor(toolkitId);
            if (desc == null) {
                throw new ToolkitPluginException(NLS.bind((String)Messages.ToolkitSupportToolkitNotFound, (Object[])new String[]{toolkitId}));
            }
            return desc.getName();
        }

        private boolean importTestCases(List<INameMapper> mapperList, List<IWritableComponentNameMapper> compMapperList, List<ISpecPersistable> specObjList, IProjectPO project, IProgressMonitor monitor) throws PMException, ProjectDeletedException, InterruptedException, IncompatibleTypeException {
            String newName = this.createCategoryName(project.getSpecObjCont().getSpecObjList());
            ICategoryPO category = NodeMaker.createCategoryPO((String)newName);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            ProgressMonitorTracker.getInstance().setProgressMonitor(monitor);
            monitor.beginTask("", this.getTotalWork(specObjList));
            try {
                NodePM.addImportedTestCases((ICategoryPO)category, specObjList);
            }
            finally {
                ProgressMonitorTracker.getInstance().setProgressMonitor(null);
            }
            EntityManager compNameSession = Persistor.instance().openSession();
            EntityTransaction tx = Persistor.instance().getTransaction(compNameSession);
            for (INameMapper mapper : mapperList) {
                mapper.persist(compNameSession, project.getId());
            }
            for (IWritableComponentNameMapper compMapper : compMapperList) {
                CompNamePM.flushCompNames((EntityManager)compNameSession, (Long)project.getId(), (IWritableComponentNameMapper)compMapper);
            }
            Persistor.instance().commitTransaction(compNameSession, tx);
            for (IWritableComponentNameMapper compMapper : compMapperList) {
                compMapper.getCompNameCache().updateStandardMapperAndCleanup(project.getId());
            }
            UsedToolkitBP.getInstance().refreshToolkitInfo(project);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)category, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)category, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.all);
            UsedToolkitBP.getInstance().refreshToolkitInfo(GeneralStorage.getInstance().getProject());
            return true;
        }

        private int getTotalWork(List<ISpecPersistable> specObjList) {
            int totalWork = 0;
            for (ISpecPersistable spec : specObjList) {
                totalWork += this.getWorkForNode((INodePO)spec);
            }
            return totalWork *= 3;
        }

        private int getWorkForNode(INodePO node) {
            int work = 1;
            if (!(node instanceof IExecTestCasePO)) {
                Iterator childIter = node.getNodeListIterator();
                while (childIter.hasNext()) {
                    work += this.getWorkForNode((INodePO)childIter.next());
                }
            }
            if (node instanceof ISpecTestCasePO) {
                work += ((ISpecTestCasePO)node).getAllEventEventExecTC().size();
            }
            return work;
        }

        private boolean isToolkitCompatible(String importedToolkit, String importedLevel, String currentToolkit, String currentLevel) {
            return importedToolkit.equals(currentToolkit) || ToolkitUtils.doesToolkitInclude((String)currentToolkit, (String)importedToolkit) || ToolkitUtils.isToolkitMoreConcrete((String)currentLevel, (String)importedLevel);
        }

        private String createCategoryName(List<ISpecPersistable> specObjList) {
            String standardName = Messages.TreeOpsBPImportedCat;
            int postfix = 1;
            String newName = String.valueOf(standardName) + postfix;
            HashSet<String> usedNames = new HashSet<String>();
            for (ISpecPersistable node : specObjList) {
                if (!(node instanceof ICategoryPO) || !node.getName().startsWith(standardName)) continue;
                usedNames.add(node.getName());
            }
            while (usedNames.contains(newName)) {
                newName = String.valueOf(standardName) + ++postfix;
            }
            return newName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReadFilesOperation
    implements IRunnableWithProgress {
        private boolean m_isImportWholeProjects;
        private Map<IProjectPO, List<INameMapper>> m_projectToMapperMap;
        private Map<IProjectPO, List<IWritableComponentNameMapper>> m_projectToCompMapperMap;
        private List<URL> m_fileURLs;
        private IProgressConsole m_console;

        public ReadFilesOperation(boolean isImportWholeProjects, List<URL> fileURLs, IProgressConsole console) {
            this.m_isImportWholeProjects = isImportWholeProjects;
            this.m_fileURLs = fileURLs;
            this.m_projectToMapperMap = new LinkedHashMap<IProjectPO, List<INameMapper>>();
            this.m_projectToCompMapperMap = new LinkedHashMap<IProjectPO, List<IWritableComponentNameMapper>>();
            this.m_console = console;
        }

        /*
         * Unable to fully structure code
         */
        public void run(IProgressMonitor monitor) throws InterruptedException {
            if (this.m_fileURLs == null) {
                return;
            }
            subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ImportFileBPReading, (int)this.m_fileURLs.size());
            try {
                try {
                    FileStorageBP.access$0(this.m_console);
                    FileStorageBP.access$1(this.m_console);
                    for (URL fileURL : this.m_fileURLs) {
                        paramNameMapper = new ParamNameBPDecorator((IParamNameMapper)ParamNameBP.getInstance());
                        compNameCache = new ComponentNamesDecorator(null);
                        fileName = fileURL.getFile();
                        this.m_console.writeLine(NLS.bind((String)Messages.ImportFileActionInfoStartingReadingProject, (Object)fileName));
                        try {
                            proj = new XmlStorage().readProject(fileURL, (IParamNameMapper)paramNameMapper, (IWritableComponentNameCache)compNameCache, this.m_isImportWholeProjects == false, (IProgressMonitor)subMonitor.newChild(1), this.m_console);
                            mapperList = new ArrayList<ParamNameBPDecorator>();
                            compNameMapperList = new ArrayList<ProjectComponentNameMapper>();
                            mapperList.add(paramNameMapper);
                            compNameMapperList.add(new ProjectComponentNameMapper((IWritableComponentNameCache)compNameCache, proj));
                            this.m_projectToMapperMap.put(proj, mapperList);
                            this.m_projectToCompMapperMap.put(proj, compNameMapperList);
                            continue;
                        }
                        catch (JBVersionException e) {
                            ** for (msg : e.getErrorMsgs())
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.m_console.writeErrorLine((String)msg);
                            continue;
                        }
lbl30:
                        // 1 sources

                        this.m_console.writeErrorLine(NLS.bind((String)Messages.ImportFileActionErrorImportFailed, (Object)fileName));
                    }
                    FileStorageBP.access$2(this.m_console);
                }
                catch (PMReadException e) {
                    FileStorageBP.access$3(e, this.m_fileURLs);
                    monitor.done();
                }
                catch (GDConfigXmlException ce) {
                    FileStorageBP.access$4(ce);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }

        public Map<IProjectPO, List<INameMapper>> getProjectToMapperMap() {
            return this.m_projectToMapperMap;
        }

        public Map<IProjectPO, List<IWritableComponentNameMapper>> getProjectToCompCacheMap() {
            return this.m_projectToCompMapperMap;
        }
    }
}

