/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.NullComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ProjectComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.TestCaseComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.TestSuiteComponentNameMapper;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IProjectPropertiesPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompNameMapperFactory {
    private static Logger log = LoggerFactory.getLogger(CompNameMapperFactory.class);

    private CompNameMapperFactory() {
    }

    public static IWritableComponentNameMapper createCompNameMapper(IPersistentObject node, IWritableComponentNameCache componentNameCache) throws IllegalArgumentException {
        Validate.notNull((Object)node);
        if (node instanceof ISpecTestCasePO) {
            return new TestCaseComponentNameMapper(componentNameCache, (ISpecTestCasePO)node);
        }
        if (node instanceof ITestSuitePO) {
            return new TestSuiteComponentNameMapper(componentNameCache, (ITestSuitePO)node);
        }
        if (node instanceof IAUTMainPO) {
            return new ObjectMappingComponentNameMapper(componentNameCache, (IAUTMainPO)node);
        }
        if (node instanceof IProjectPO) {
            return new ProjectComponentNameMapper(componentNameCache, (IProjectPO)node);
        }
        if (node instanceof IProjectPropertiesPO) {
            return new NullComponentNameMapper();
        }
        if (node instanceof ITestJobPO) {
            return new NullComponentNameMapper();
        }
        if (node instanceof ITestDataCategoryPO) {
            return new NullComponentNameMapper();
        }
        try {
            throw new IllegalArgumentException();
        }
        catch (IllegalArgumentException iae) {
            log.warn("Could not find a Component Name mapper that supports context type: " + node.getClass() + "; Returning an empty mapper implementation.", (Throwable)iae);
            return new NullComponentNameMapper();
        }
    }
}

