/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jubula.client.core.model.IAbstractGUIDNamePO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GuidNameCache<GUID_NAME_PO extends IAbstractGUIDNamePO> {
    private Map<String, GUID_NAME_PO> m_namesToInsert = new HashMap<String, GUID_NAME_PO>();
    private Map<String, String> m_namesToUpdate = new HashMap<String, String>();
    private Map<String, String> m_namesToCache = new HashMap<String, String>();
    private Set<String> m_namesToDelete = new HashSet<String>();

    protected final void updateLocalCache() {
        for (String guid : this.m_namesToInsert.keySet()) {
            this.m_namesToCache.put(guid, ((IAbstractGUIDNamePO)this.m_namesToInsert.get(guid)).getName());
        }
        for (String guid : this.m_namesToDelete) {
            this.m_namesToCache.remove(guid);
        }
        for (String guid : this.m_namesToUpdate.keySet()) {
            if (!this.m_namesToCache.containsKey(guid)) continue;
            this.m_namesToCache.put(guid, this.m_namesToUpdate.get(guid));
        }
    }

    protected final void addNameToInsert(GUID_NAME_PO guidNamePO) {
        this.m_namesToInsert.put(guidNamePO.getGuid(), guidNamePO);
    }

    protected final GUID_NAME_PO removeNameToInsert(GUID_NAME_PO guidNamePO) {
        return (GUID_NAME_PO)((IAbstractGUIDNamePO)this.m_namesToInsert.remove(guidNamePO.getGuid()));
    }

    protected final GUID_NAME_PO removeNameToInsert(String guid) {
        return (GUID_NAME_PO)((IAbstractGUIDNamePO)this.m_namesToInsert.remove(guid));
    }

    protected final void addNameToCache(String guid, String name) {
        this.m_namesToCache.put(guid, name);
    }

    protected final void addNameToDelete(String guid) {
        this.m_namesToDelete.add(guid);
    }

    public final void addNameToUpdate(String guid, String newName) {
        if (this.m_namesToInsert.containsKey(guid)) {
            IAbstractGUIDNamePO name = (IAbstractGUIDNamePO)this.m_namesToInsert.get(guid);
            name.setName(newName);
        } else {
            this.m_namesToUpdate.put(guid, newName);
        }
    }

    protected final String getName(String guid) {
        String name = null;
        if (this.m_namesToUpdate.get(guid) != null) {
            name = this.m_namesToUpdate.get(guid);
        } else if (this.m_namesToCache.get(guid) != null) {
            name = this.m_namesToCache.get(guid);
        } else if (this.m_namesToInsert.get(guid) != null) {
            name = ((IAbstractGUIDNamePO)this.m_namesToInsert.get(guid)).getName();
        }
        return name;
    }

    protected final List<GUID_NAME_PO> getNamesToInsert() {
        return new ArrayList<GUID_NAME_PO>(this.m_namesToInsert.values());
    }

    protected final List<String> getNameGuidsToDelete() {
        return new ArrayList<String>(this.m_namesToDelete);
    }

    protected final List<String> getNameGuidsToUpdate() {
        return new ArrayList<String>(this.m_namesToUpdate.keySet());
    }

    public void clearAllNames() {
        this.m_namesToDelete.clear();
        this.m_namesToInsert.clear();
        this.m_namesToUpdate.clear();
    }

    protected final void removeNamePO(String guid) {
        if (this.m_namesToUpdate.get(guid) != null) {
            this.m_namesToUpdate.remove(guid);
            this.m_namesToDelete.add(guid);
        } else if (this.m_namesToInsert.get(guid) != null) {
            this.m_namesToInsert.remove(guid);
        } else {
            this.m_namesToDelete.add(guid);
        }
    }

    protected final String getNameToUpdate(String guid) {
        return this.m_namesToUpdate.get(guid);
    }
}

