/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.utils.IGenericListener;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.dialogs.NagDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.DialogStatusParameter;
import org.eclipse.jubula.client.ui.rcp.widgets.AutConfigComponent;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.tools.exception.UnexpectedGenericTypeException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AUTConfigPropertiesDialog
extends TitleAreaDialog
implements DataEventDispatcher.IDialogStatusListener {
    private static Logger log = LoggerFactory.getLogger(AUTConfigPropertiesDialog.class);
    private IAUTConfigPO m_autConfig;
    private String m_toolkit = "";
    private String m_autName;
    private IValidator m_autIdValidator;

    public AUTConfigPropertiesDialog(Shell parentShell, IAUTConfigPO autConfig, String toolkit, String autName, IValidator autIdValidator) {
        super(parentShell);
        this.m_autConfig = autConfig;
        this.m_toolkit = toolkit;
        this.m_autName = autName;
        this.m_autIdValidator = autIdValidator;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        DataEventDispatcher.getInstance().getDialogStatusListenerMgr().addListener((IGenericListener)this);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.autConfigPropDialogContextId");
        this.setTitle(Messages.ProjectWizardAutSettings);
        this.setMessage(Messages.ProjectWizardAUTData);
        try {
            Composite autConfigComposite = ToolkitSupportBP.getAutConfigComposite((String)this.m_toolkit, (Composite)parent, (int)768, (Map)this.m_autConfig.getConfigMap(), (String)this.m_autName);
            autConfigComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            if (autConfigComposite instanceof AutConfigComponent) {
                ((AutConfigComponent)autConfigComposite).setAutIdValidator(this.m_autIdValidator);
            }
        }
        catch (ToolkitPluginException e) {
            log.error(String.valueOf(Messages.NoAUTConfigPageForToolkit) + ":" + " " + String.valueOf(this.m_toolkit), (Throwable)e);
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_NO_AUTCONFIG_DIALOG);
        }
        return parent;
    }

    protected void okPressed() {
        if (this.canExecFileGetUsed()) {
            NagDialog.runNagDialog(this.getShell(), "InfoNagger.DefineSwingOrSwtExecutable", "org.eclipse.jubula.client.ua.help.autConfigSettingWizardPagePageContextId");
        }
        super.okPressed();
    }

    public boolean close() {
        DataEventDispatcher.getInstance().getDialogStatusListenerMgr().removeListener((IGenericListener)this);
        return super.close();
    }

    private boolean canExecFileGetUsed() {
        return this.m_autConfig.getValue("EXECUTABLE", null) != null && (this.m_toolkit.equals("com.bredexsw.guidancer.SwtToolkitPlugin") || this.m_toolkit.equals("com.bredexsw.guidancer.SwingToolkitPlugin"));
    }

    public void eventOccured(List<? extends Object> params) {
        DialogStatusParameter parameter = (DialogStatusParameter)params.get(0);
        this.setMessage(parameter.getMessage(), parameter.getStatusType());
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(parameter.getButtonState().booleanValue());
        }
    }

    public void checkGenericListElementType(List<? extends Object> params) throws UnexpectedGenericTypeException {
        Validate.noNullElements(params);
        Class<DialogStatusParameter> type = null;
        int index = 0;
        if (!(params.get(0) instanceof DialogStatusParameter)) {
            type = DialogStatusParameter.class;
        }
        if (type != null) {
            StringBuilder msg = new StringBuilder();
            msg.append(Messages.GenericType).append(" ").append(type).append(" ").append(Messages.WasExpectedBut).append(" ").append(params.get(index).getClass()).append(" ").append(Messages.WasFound).append(".");
            throw new UnexpectedGenericTypeException(msg.toString(), MessageIDs.E_UNEXPECTED_EXCEPTION);
        }
    }
}

