/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.businessprocess.StartAutBP;
import org.eclipse.jubula.client.ui.rcp.controllers.TestExecutionGUIController;
import org.eclipse.jubula.client.ui.rcp.dialogs.NagDialog;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class StartAutHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String AUT_TO_START = "org.eclipse.jubula.client.ui.rcp.commands.ChooseAutCommand.parameter.autToStart";
    public static final String AUT_CONF_TO_START = "org.eclipse.jubula.client.ui.rcp.commands.ChooseAutCommand.parameter.autConfigToStart";
    public static final String LAST_STARTED_AUT = "org.eclipse.jubula.client.ui.rcp.commands.ChooseAutCommand.state.lastStartedAut";
    public static final String LAST_STARTED_AUT_CONFIG = "org.eclipse.jubula.client.ui.rcp.commands.ChooseAutCommand.state.lastStartedAutConfig";

    public Object execute(ExecutionEvent event) {
        State lastStartedAutConfigState;
        State lastStartedAutState;
        Object autToStartObj = null;
        Object autConfigToStartObj = null;
        IAUTMainPO autToStart = null;
        IAUTConfigPO autConfigToStart = null;
        try {
            autToStartObj = event.getObjectParameterForExecution(AUT_TO_START);
            autConfigToStartObj = event.getObjectParameterForExecution(AUT_CONF_TO_START);
        }
        catch (ExecutionException executionException) {}
        if (autToStartObj instanceof IAUTMainPO && autConfigToStartObj instanceof IAUTConfigPO) {
            autToStart = (IAUTMainPO)autToStartObj;
            autConfigToStart = (IAUTConfigPO)autConfigToStartObj;
        } else {
            lastStartedAutState = event.getCommand().getState(LAST_STARTED_AUT);
            lastStartedAutConfigState = event.getCommand().getState(LAST_STARTED_AUT_CONFIG);
            if (lastStartedAutState != null && lastStartedAutConfigState != null) {
                Object autStateValue = lastStartedAutState.getValue();
                Object autConfigStateValue = lastStartedAutConfigState.getValue();
                if (autStateValue instanceof IAUTMainPO && autConfigStateValue instanceof IAUTConfigPO) {
                    IAUTMainPO lastAUT = (IAUTMainPO)autStateValue;
                    Long currentProjectId = GeneralStorage.getInstance().getProject().getId();
                    if (ObjectUtils.equals((Object)lastAUT.getParentProjectId(), (Object)currentProjectId)) {
                        autToStart = (IAUTMainPO)autStateValue;
                        autConfigToStart = (IAUTConfigPO)autConfigStateValue;
                    }
                }
            }
        }
        if (autToStart != null && autConfigToStart != null) {
            this.startAut(autToStart, autConfigToStart);
            lastStartedAutState = event.getCommand().getState(LAST_STARTED_AUT);
            lastStartedAutConfigState = event.getCommand().getState(LAST_STARTED_AUT_CONFIG);
            if (lastStartedAutState != null && lastStartedAutConfigState != null) {
                lastStartedAutState.setValue((Object)autToStart);
                lastStartedAutConfigState.setValue((Object)autConfigToStart);
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IAUTConfigPO lastUsedConf;
        Object autObj = parameters.get(AUT_TO_START);
        Object autConfObj = parameters.get(AUT_CONF_TO_START);
        boolean setChecked = false;
        IAUTMainPO lastUsedAut = StartAutBP.getInstance().getLastUsedAut();
        if (lastUsedAut != null && lastUsedAut.getId().toString().equals(autObj) && (lastUsedConf = StartAutBP.getInstance().getLastUsedConf()) != null && lastUsedConf.getId().toString().equals(autConfObj)) {
            setChecked = true;
        }
        element.setChecked(setChecked);
    }

    private void startAut(IAUTMainPO aut, IAUTConfigPO conf) {
        if (aut.getToolkit().equals("com.bredexsw.guidancer.RcpToolkitPlugin")) {
            NagDialog.runNagDialog(null, "InfoNagger.RunRcpAut", "org.eclipse.jubula.client.ua.help.autConfigSettingWizardPagePageContextId");
        }
        StartAutBP.getInstance().fireAutStarted();
        TestExecutionGUIController.startAUT(aut, conf);
        StartAutBP.getInstance().setLastUsedAut(aut);
        StartAutBP.getInstance().setLastUsedAutConf(conf);
    }
}

